/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorRequest;
import software.amazon.awssdk.services.frauddetector.model.ModelEndpointStatus;
import software.amazon.awssdk.services.frauddetector.model.ModelInputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelOutputConfiguration;
import software.amazon.awssdk.services.frauddetector.model.ModelSource;
import software.amazon.awssdk.services.frauddetector.model.Role;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutExternalModelRequest
extends FraudDetectorRequest
implements ToCopyableBuilder<Builder, PutExternalModelRequest> {
    private static final SdkField<String> MODEL_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutExternalModelRequest.getter(PutExternalModelRequest::modelEndpoint)).setter(PutExternalModelRequest.setter(Builder::modelEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpoint").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutExternalModelRequest.getter(PutExternalModelRequest::modelSourceAsString)).setter(PutExternalModelRequest.setter(Builder::modelSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()}).build();
    private static final SdkField<Role> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutExternalModelRequest.getter(PutExternalModelRequest::role)).setter(PutExternalModelRequest.setter(Builder::role)).constructor(Role::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("role").build()}).build();
    private static final SdkField<ModelInputConfiguration> INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutExternalModelRequest.getter(PutExternalModelRequest::inputConfiguration)).setter(PutExternalModelRequest.setter(Builder::inputConfiguration)).constructor(ModelInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputConfiguration").build()}).build();
    private static final SdkField<ModelOutputConfiguration> OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutExternalModelRequest.getter(PutExternalModelRequest::outputConfiguration)).setter(PutExternalModelRequest.setter(Builder::outputConfiguration)).constructor(ModelOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfiguration").build()}).build();
    private static final SdkField<String> MODEL_ENDPOINT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutExternalModelRequest.getter(PutExternalModelRequest::modelEndpointStatusAsString)).setter(PutExternalModelRequest.setter(Builder::modelEndpointStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelEndpointStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ENDPOINT_FIELD, MODEL_SOURCE_FIELD, ROLE_FIELD, INPUT_CONFIGURATION_FIELD, OUTPUT_CONFIGURATION_FIELD, MODEL_ENDPOINT_STATUS_FIELD));
    private final String modelEndpoint;
    private final String modelSource;
    private final Role role;
    private final ModelInputConfiguration inputConfiguration;
    private final ModelOutputConfiguration outputConfiguration;
    private final String modelEndpointStatus;

    private PutExternalModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelEndpoint = builder.modelEndpoint;
        this.modelSource = builder.modelSource;
        this.role = builder.role;
        this.inputConfiguration = builder.inputConfiguration;
        this.outputConfiguration = builder.outputConfiguration;
        this.modelEndpointStatus = builder.modelEndpointStatus;
    }

    public String modelEndpoint() {
        return this.modelEndpoint;
    }

    public ModelSource modelSource() {
        return ModelSource.fromValue(this.modelSource);
    }

    public String modelSourceAsString() {
        return this.modelSource;
    }

    public Role role() {
        return this.role;
    }

    public ModelInputConfiguration inputConfiguration() {
        return this.inputConfiguration;
    }

    public ModelOutputConfiguration outputConfiguration() {
        return this.outputConfiguration;
    }

    public ModelEndpointStatus modelEndpointStatus() {
        return ModelEndpointStatus.fromValue(this.modelEndpointStatus);
    }

    public String modelEndpointStatusAsString() {
        return this.modelEndpointStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelEndpointStatusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutExternalModelRequest)) {
            return false;
        }
        PutExternalModelRequest other = (PutExternalModelRequest)((Object)obj);
        return Objects.equals(this.modelEndpoint(), other.modelEndpoint()) && Objects.equals(this.modelSourceAsString(), other.modelSourceAsString()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.inputConfiguration(), other.inputConfiguration()) && Objects.equals(this.outputConfiguration(), other.outputConfiguration()) && Objects.equals(this.modelEndpointStatusAsString(), other.modelEndpointStatusAsString());
    }

    public String toString() {
        return ToString.builder((String)"PutExternalModelRequest").add("ModelEndpoint", (Object)this.modelEndpoint()).add("ModelSource", (Object)this.modelSourceAsString()).add("Role", (Object)this.role()).add("InputConfiguration", (Object)this.inputConfiguration()).add("OutputConfiguration", (Object)this.outputConfiguration()).add("ModelEndpointStatus", (Object)this.modelEndpointStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelEndpoint": {
                return Optional.ofNullable(clazz.cast(this.modelEndpoint()));
            }
            case "modelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSourceAsString()));
            }
            case "role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "inputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inputConfiguration()));
            }
            case "outputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.outputConfiguration()));
            }
            case "modelEndpointStatus": {
                return Optional.ofNullable(clazz.cast(this.modelEndpointStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutExternalModelRequest, T> g) {
        return obj -> g.apply((PutExternalModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorRequest.BuilderImpl
    implements Builder {
        private String modelEndpoint;
        private String modelSource;
        private Role role;
        private ModelInputConfiguration inputConfiguration;
        private ModelOutputConfiguration outputConfiguration;
        private String modelEndpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(PutExternalModelRequest model) {
            super(model);
            this.modelEndpoint(model.modelEndpoint);
            this.modelSource(model.modelSource);
            this.role(model.role);
            this.inputConfiguration(model.inputConfiguration);
            this.outputConfiguration(model.outputConfiguration);
            this.modelEndpointStatus(model.modelEndpointStatus);
        }

        public final String getModelEndpoint() {
            return this.modelEndpoint;
        }

        @Override
        public final Builder modelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
            return this;
        }

        public final void setModelEndpoint(String modelEndpoint) {
            this.modelEndpoint = modelEndpoint;
        }

        public final String getModelSource() {
            return this.modelSource;
        }

        @Override
        public final Builder modelSource(String modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        @Override
        public final Builder modelSource(ModelSource modelSource) {
            this.modelSource(modelSource == null ? null : modelSource.toString());
            return this;
        }

        public final void setModelSource(String modelSource) {
            this.modelSource = modelSource;
        }

        public final Role.Builder getRole() {
            return this.role != null ? this.role.toBuilder() : null;
        }

        @Override
        public final Builder role(Role role) {
            this.role = role;
            return this;
        }

        public final void setRole(Role.BuilderImpl role) {
            this.role = role != null ? role.build() : null;
        }

        public final ModelInputConfiguration.Builder getInputConfiguration() {
            return this.inputConfiguration != null ? this.inputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder inputConfiguration(ModelInputConfiguration inputConfiguration) {
            this.inputConfiguration = inputConfiguration;
            return this;
        }

        public final void setInputConfiguration(ModelInputConfiguration.BuilderImpl inputConfiguration) {
            this.inputConfiguration = inputConfiguration != null ? inputConfiguration.build() : null;
        }

        public final ModelOutputConfiguration.Builder getOutputConfiguration() {
            return this.outputConfiguration != null ? this.outputConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder outputConfiguration(ModelOutputConfiguration outputConfiguration) {
            this.outputConfiguration = outputConfiguration;
            return this;
        }

        public final void setOutputConfiguration(ModelOutputConfiguration.BuilderImpl outputConfiguration) {
            this.outputConfiguration = outputConfiguration != null ? outputConfiguration.build() : null;
        }

        public final String getModelEndpointStatus() {
            return this.modelEndpointStatus;
        }

        @Override
        public final Builder modelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
            return this;
        }

        @Override
        public final Builder modelEndpointStatus(ModelEndpointStatus modelEndpointStatus) {
            this.modelEndpointStatus(modelEndpointStatus == null ? null : modelEndpointStatus.toString());
            return this;
        }

        public final void setModelEndpointStatus(String modelEndpointStatus) {
            this.modelEndpointStatus = modelEndpointStatus;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutExternalModelRequest build() {
            return new PutExternalModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutExternalModelRequest> {
        public Builder modelEndpoint(String var1);

        public Builder modelSource(String var1);

        public Builder modelSource(ModelSource var1);

        public Builder role(Role var1);

        default public Builder role(Consumer<Role.Builder> role) {
            return this.role((Role)((Role.Builder)Role.builder().applyMutation(role)).build());
        }

        public Builder inputConfiguration(ModelInputConfiguration var1);

        default public Builder inputConfiguration(Consumer<ModelInputConfiguration.Builder> inputConfiguration) {
            return this.inputConfiguration((ModelInputConfiguration)((ModelInputConfiguration.Builder)ModelInputConfiguration.builder().applyMutation(inputConfiguration)).build());
        }

        public Builder outputConfiguration(ModelOutputConfiguration var1);

        default public Builder outputConfiguration(Consumer<ModelOutputConfiguration.Builder> outputConfiguration) {
            return this.outputConfiguration((ModelOutputConfiguration)((ModelOutputConfiguration.Builder)ModelOutputConfiguration.builder().applyMutation(outputConfiguration)).build());
        }

        public Builder modelEndpointStatus(String var1);

        public Builder modelEndpointStatus(ModelEndpointStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

