/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ListOfModelScoresCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelScores;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPredictionResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetPredictionResponse> {
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetPredictionResponse.getter(GetPredictionResponse::outcomes)).setter(GetPredictionResponse.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ModelScores>> MODEL_SCORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetPredictionResponse.getter(GetPredictionResponse::modelScores)).setter(GetPredictionResponse.setter(Builder::modelScores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelScores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelScores::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTCOMES_FIELD, MODEL_SCORES_FIELD));
    private final List<String> outcomes;
    private final List<ModelScores> modelScores;

    private GetPredictionResponse(BuilderImpl builder) {
        super(builder);
        this.outcomes = builder.outcomes;
        this.modelScores = builder.modelScores;
    }

    public List<String> outcomes() {
        return this.outcomes;
    }

    public List<ModelScores> modelScores() {
        return this.modelScores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.outcomes());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelScores());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPredictionResponse)) {
            return false;
        }
        GetPredictionResponse other = (GetPredictionResponse)((Object)obj);
        return Objects.equals(this.outcomes(), other.outcomes()) && Objects.equals(this.modelScores(), other.modelScores());
    }

    public String toString() {
        return ToString.builder((String)"GetPredictionResponse").add("Outcomes", this.outcomes()).add("ModelScores", this.modelScores()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
            case "modelScores": {
                return Optional.ofNullable(clazz.cast(this.modelScores()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPredictionResponse, T> g) {
        return obj -> g.apply((GetPredictionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();
        private List<ModelScores> modelScores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPredictionResponse model) {
            super(model);
            this.outcomes(model.outcomes);
            this.modelScores(model.modelScores);
        }

        public final Collection<String> getOutcomes() {
            return this.outcomes;
        }

        @Override
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomes(String ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        public final Collection<ModelScores.Builder> getModelScores() {
            return this.modelScores != null ? (Collection)this.modelScores.stream().map(ModelScores::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modelScores(Collection<ModelScores> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copy(modelScores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(ModelScores ... modelScores) {
            this.modelScores(Arrays.asList(modelScores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelScores(Consumer<ModelScores.Builder> ... modelScores) {
            this.modelScores(Stream.of(modelScores).map(c -> (ModelScores)((ModelScores.Builder)ModelScores.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModelScores(Collection<ModelScores.BuilderImpl> modelScores) {
            this.modelScores = ListOfModelScoresCopier.copyFromBuilder(modelScores);
        }

        @Override
        public GetPredictionResponse build() {
            return new GetPredictionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPredictionResponse> {
        public Builder outcomes(Collection<String> var1);

        public Builder outcomes(String ... var1);

        public Builder modelScores(Collection<ModelScores> var1);

        public Builder modelScores(ModelScores ... var1);

        public Builder modelScores(Consumer<ModelScores.Builder> ... var1);
    }
}

