/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.CsvIndexToVariableMapCopier;
import software.amazon.awssdk.services.frauddetector.model.JsonKeyToVariableMapCopier;
import software.amazon.awssdk.services.frauddetector.model.ModelOutputDataFormat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelOutputConfiguration> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModelOutputConfiguration.getter(ModelOutputConfiguration::formatAsString)).setter(ModelOutputConfiguration.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<Map<String, String>> JSON_KEY_TO_VARIABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ModelOutputConfiguration.getter(ModelOutputConfiguration::jsonKeyToVariableMap)).setter(ModelOutputConfiguration.setter(Builder::jsonKeyToVariableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jsonKeyToVariableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CSV_INDEX_TO_VARIABLE_MAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ModelOutputConfiguration.getter(ModelOutputConfiguration::csvIndexToVariableMap)).setter(ModelOutputConfiguration.setter(Builder::csvIndexToVariableMap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvIndexToVariableMap").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD, JSON_KEY_TO_VARIABLE_MAP_FIELD, CSV_INDEX_TO_VARIABLE_MAP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String format;
    private final Map<String, String> jsonKeyToVariableMap;
    private final Map<String, String> csvIndexToVariableMap;

    private ModelOutputConfiguration(BuilderImpl builder) {
        this.format = builder.format;
        this.jsonKeyToVariableMap = builder.jsonKeyToVariableMap;
        this.csvIndexToVariableMap = builder.csvIndexToVariableMap;
    }

    public ModelOutputDataFormat format() {
        return ModelOutputDataFormat.fromValue(this.format);
    }

    public String formatAsString() {
        return this.format;
    }

    public Map<String, String> jsonKeyToVariableMap() {
        return this.jsonKeyToVariableMap;
    }

    public Map<String, String> csvIndexToVariableMap() {
        return this.csvIndexToVariableMap;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jsonKeyToVariableMap());
        hashCode = 31 * hashCode + Objects.hashCode(this.csvIndexToVariableMap());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelOutputConfiguration)) {
            return false;
        }
        ModelOutputConfiguration other = (ModelOutputConfiguration)obj;
        return Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.jsonKeyToVariableMap(), other.jsonKeyToVariableMap()) && Objects.equals(this.csvIndexToVariableMap(), other.csvIndexToVariableMap());
    }

    public String toString() {
        return ToString.builder((String)"ModelOutputConfiguration").add("Format", (Object)this.formatAsString()).add("JsonKeyToVariableMap", this.jsonKeyToVariableMap()).add("CsvIndexToVariableMap", this.csvIndexToVariableMap()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "jsonKeyToVariableMap": {
                return Optional.ofNullable(clazz.cast(this.jsonKeyToVariableMap()));
            }
            case "csvIndexToVariableMap": {
                return Optional.ofNullable(clazz.cast(this.csvIndexToVariableMap()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelOutputConfiguration, T> g) {
        return obj -> g.apply((ModelOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String format;
        private Map<String, String> jsonKeyToVariableMap = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> csvIndexToVariableMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelOutputConfiguration model) {
            this.format(model.format);
            this.jsonKeyToVariableMap(model.jsonKeyToVariableMap);
            this.csvIndexToVariableMap(model.csvIndexToVariableMap);
        }

        public final String getFormatAsString() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ModelOutputDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Map<String, String> getJsonKeyToVariableMap() {
            return this.jsonKeyToVariableMap;
        }

        @Override
        public final Builder jsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = JsonKeyToVariableMapCopier.copy(jsonKeyToVariableMap);
            return this;
        }

        public final void setJsonKeyToVariableMap(Map<String, String> jsonKeyToVariableMap) {
            this.jsonKeyToVariableMap = JsonKeyToVariableMapCopier.copy(jsonKeyToVariableMap);
        }

        public final Map<String, String> getCsvIndexToVariableMap() {
            return this.csvIndexToVariableMap;
        }

        @Override
        public final Builder csvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
            this.csvIndexToVariableMap = CsvIndexToVariableMapCopier.copy(csvIndexToVariableMap);
            return this;
        }

        public final void setCsvIndexToVariableMap(Map<String, String> csvIndexToVariableMap) {
            this.csvIndexToVariableMap = CsvIndexToVariableMapCopier.copy(csvIndexToVariableMap);
        }

        public ModelOutputConfiguration build() {
            return new ModelOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelOutputConfiguration> {
        public Builder format(String var1);

        public Builder format(ModelOutputDataFormat var1);

        public Builder jsonKeyToVariableMap(Map<String, String> var1);

        public Builder csvIndexToVariableMap(Map<String, String> var1);
    }
}

