/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fis.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ExperimentActionStatus {
    PENDING("pending"),
    INITIATING("initiating"),
    RUNNING("running"),
    COMPLETED("completed"),
    CANCELLED("cancelled"),
    STOPPING("stopping"),
    STOPPED("stopped"),
    FAILED("failed"),
    SKIPPED("skipped"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExperimentActionStatus> VALUE_MAP;
    private final String value;

    private ExperimentActionStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExperimentActionStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExperimentActionStatus> knownValues() {
        EnumSet<ExperimentActionStatus> knownValues = EnumSet.allOf(ExperimentActionStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ExperimentActionStatus.class, ExperimentActionStatus::toString);
    }
}

