/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eventbridge.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConnectionResourceParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeConnectionResourceParameters> {
    private static final SdkField<String> RESOURCE_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceConfigurationArn").getter(DescribeConnectionResourceParameters.getter(DescribeConnectionResourceParameters::resourceConfigurationArn)).setter(DescribeConnectionResourceParameters.setter(Builder::resourceConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfigurationArn").build()}).build();
    private static final SdkField<String> RESOURCE_ASSOCIATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceAssociationArn").getter(DescribeConnectionResourceParameters.getter(DescribeConnectionResourceParameters::resourceAssociationArn)).setter(DescribeConnectionResourceParameters.setter(Builder::resourceAssociationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceAssociationArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_CONFIGURATION_ARN_FIELD, RESOURCE_ASSOCIATION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeConnectionResourceParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceConfigurationArn;
    private final String resourceAssociationArn;

    private DescribeConnectionResourceParameters(BuilderImpl builder) {
        this.resourceConfigurationArn = builder.resourceConfigurationArn;
        this.resourceAssociationArn = builder.resourceAssociationArn;
    }

    public final String resourceConfigurationArn() {
        return this.resourceConfigurationArn;
    }

    public final String resourceAssociationArn() {
        return this.resourceAssociationArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAssociationArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectionResourceParameters)) {
            return false;
        }
        DescribeConnectionResourceParameters other = (DescribeConnectionResourceParameters)obj;
        return Objects.equals(this.resourceConfigurationArn(), other.resourceConfigurationArn()) && Objects.equals(this.resourceAssociationArn(), other.resourceAssociationArn());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConnectionResourceParameters").add("ResourceConfigurationArn", (Object)this.resourceConfigurationArn()).add("ResourceAssociationArn", (Object)this.resourceAssociationArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceConfigurationArn()));
            }
            case "ResourceAssociationArn": {
                return Optional.ofNullable(clazz.cast(this.resourceAssociationArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ResourceConfigurationArn", RESOURCE_CONFIGURATION_ARN_FIELD);
        map.put("ResourceAssociationArn", RESOURCE_ASSOCIATION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectionResourceParameters, T> g) {
        return obj -> g.apply((DescribeConnectionResourceParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceConfigurationArn;
        private String resourceAssociationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectionResourceParameters model) {
            this.resourceConfigurationArn(model.resourceConfigurationArn);
            this.resourceAssociationArn(model.resourceAssociationArn);
        }

        public final String getResourceConfigurationArn() {
            return this.resourceConfigurationArn;
        }

        public final void setResourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
        }

        @Override
        public final Builder resourceConfigurationArn(String resourceConfigurationArn) {
            this.resourceConfigurationArn = resourceConfigurationArn;
            return this;
        }

        public final String getResourceAssociationArn() {
            return this.resourceAssociationArn;
        }

        public final void setResourceAssociationArn(String resourceAssociationArn) {
            this.resourceAssociationArn = resourceAssociationArn;
        }

        @Override
        public final Builder resourceAssociationArn(String resourceAssociationArn) {
            this.resourceAssociationArn = resourceAssociationArn;
            return this;
        }

        public DescribeConnectionResourceParameters build() {
            return new DescribeConnectionResourceParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeConnectionResourceParameters> {
        public Builder resourceConfigurationArn(String var1);

        public Builder resourceAssociationArn(String var1);
    }
}

