/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.emr.model.DescribeClusterRequest;
import software.amazon.awssdk.services.emr.model.DescribeClusterResponse;
import software.amazon.awssdk.services.emr.model.DescribeStepRequest;
import software.amazon.awssdk.services.emr.model.DescribeStepResponse;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.waiters.EmrWaiter;
import software.amazon.awssdk.services.emr.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultEmrWaiter
implements EmrWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final EmrClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeClusterResponse> clusterRunningWaiter;
    private final Waiter<DescribeStepResponse> stepCompleteWaiter;
    private final Waiter<DescribeClusterResponse> clusterTerminatedWaiter;

    private DefaultEmrWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EmrClient)EmrClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.clusterRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterResponse.class).acceptors(DefaultEmrWaiter.clusterRunningWaiterAcceptors())).overrideConfiguration(DefaultEmrWaiter.clusterRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.stepCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStepResponse.class).acceptors(DefaultEmrWaiter.stepCompleteWaiterAcceptors())).overrideConfiguration(DefaultEmrWaiter.stepCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.clusterTerminatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeClusterResponse.class).acceptors(DefaultEmrWaiter.clusterTerminatedWaiterAcceptors())).overrideConfiguration(DefaultEmrWaiter.clusterTerminatedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterRunning(DescribeClusterRequest describeClusterRequest) {
        return this.clusterRunningWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterRunning(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterRunningWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEmrWaiter.clusterRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterTerminated(DescribeClusterRequest describeClusterRequest) {
        return this.clusterTerminatedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)));
    }

    @Override
    public WaiterResponse<DescribeClusterResponse> waitUntilClusterTerminated(DescribeClusterRequest describeClusterRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.clusterTerminatedWaiter.run(() -> this.client.describeCluster(this.applyWaitersUserAgent(describeClusterRequest)), DefaultEmrWaiter.clusterTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStepResponse> waitUntilStepComplete(DescribeStepRequest describeStepRequest) {
        return this.stepCompleteWaiter.run(() -> this.client.describeStep(this.applyWaitersUserAgent(describeStepRequest)));
    }

    @Override
    public WaiterResponse<DescribeStepResponse> waitUntilStepComplete(DescribeStepRequest describeStepRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.stepCompleteWaiter.run(() -> this.client.describeStep(this.applyWaitersUserAgent(describeStepRequest)), DefaultEmrWaiter.stepCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "WAITING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATING");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Cluster.Status.State=TERMINATING) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Cluster.Status.State=TERMINATED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED_WITH_ERRORS");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Cluster.Status.State=TERMINATED_WITH_ERRORS) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStepResponse>> stepCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStepResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStepResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Step").field("Status").field("State").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Step").field("Status").field("State").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Step.Status.State=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Step").field("Status").field("State").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Step.Status.State=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeClusterResponse>> clusterTerminatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeClusterResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeClusterResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Cluster").field("Status").field("State").value(), "TERMINATED_WITH_ERRORS");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (Cluster.Status.State=TERMINATED_WITH_ERRORS) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration clusterRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration stepCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration clusterTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EmrWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EmrRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EmrRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EmrWaiter.Builder {
        private EmrClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public EmrWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EmrWaiter.Builder client(EmrClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EmrWaiter build() {
            return new DefaultEmrWaiter(this);
        }
    }
}

