/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.elasticloadbalancingv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the target group stickiness for a rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TargetGroupStickinessConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<TargetGroupStickinessConfig.Builder, TargetGroupStickinessConfig> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(TargetGroupStickinessConfig::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Integer> DURATION_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DurationSeconds").getter(getter(TargetGroupStickinessConfig::durationSeconds))
            .setter(setter(Builder::durationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            DURATION_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final Integer durationSeconds;

    private TargetGroupStickinessConfig(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.durationSeconds = builder.durationSeconds;
    }

    /**
     * <p>
     * Indicates whether target group stickiness is enabled.
     * </p>
     * 
     * @return Indicates whether target group stickiness is enabled.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The time period, in seconds, during which requests from a client should be routed to the same target group. The
     * range is 1-604800 seconds (7 days).
     * </p>
     * 
     * @return The time period, in seconds, during which requests from a client should be routed to the same target
     *         group. The range is 1-604800 seconds (7 days).
     */
    public final Integer durationSeconds() {
        return durationSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(durationSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetGroupStickinessConfig)) {
            return false;
        }
        TargetGroupStickinessConfig other = (TargetGroupStickinessConfig) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(durationSeconds(), other.durationSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TargetGroupStickinessConfig").add("Enabled", enabled())
                .add("DurationSeconds", durationSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "DurationSeconds":
            return Optional.ofNullable(clazz.cast(durationSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetGroupStickinessConfig, T> g) {
        return obj -> g.apply((TargetGroupStickinessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TargetGroupStickinessConfig> {
        /**
         * <p>
         * Indicates whether target group stickiness is enabled.
         * </p>
         * 
         * @param enabled
         *        Indicates whether target group stickiness is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The time period, in seconds, during which requests from a client should be routed to the same target group.
         * The range is 1-604800 seconds (7 days).
         * </p>
         * 
         * @param durationSeconds
         *        The time period, in seconds, during which requests from a client should be routed to the same target
         *        group. The range is 1-604800 seconds (7 days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationSeconds(Integer durationSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private Integer durationSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetGroupStickinessConfig model) {
            enabled(model.enabled);
            durationSeconds(model.durationSeconds);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final Integer getDurationSeconds() {
            return durationSeconds;
        }

        public final void setDurationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
        }

        @Override
        public final Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public TargetGroupStickinessConfig build() {
            return new TargetGroupStickinessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
