/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDownloadUrlForLayerResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
    private static final SdkField<String> DOWNLOAD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("downloadUrl").getter(GetDownloadUrlForLayerResponse.getter(GetDownloadUrlForLayerResponse::downloadUrl)).setter(GetDownloadUrlForLayerResponse.setter(Builder::downloadUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadUrl").build()}).build();
    private static final SdkField<String> LAYER_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("layerDigest").getter(GetDownloadUrlForLayerResponse.getter(GetDownloadUrlForLayerResponse::layerDigest)).setter(GetDownloadUrlForLayerResponse.setter(Builder::layerDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerDigest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOWNLOAD_URL_FIELD, LAYER_DIGEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDownloadUrlForLayerResponse.memberNameToFieldInitializer();
    private final String downloadUrl;
    private final String layerDigest;

    private GetDownloadUrlForLayerResponse(BuilderImpl builder) {
        super(builder);
        this.downloadUrl = builder.downloadUrl;
        this.layerDigest = builder.layerDigest;
    }

    public final String downloadUrl() {
        return this.downloadUrl;
    }

    public final String layerDigest() {
        return this.layerDigest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDownloadUrlForLayerResponse)) {
            return false;
        }
        GetDownloadUrlForLayerResponse other = (GetDownloadUrlForLayerResponse)((Object)obj);
        return Objects.equals(this.downloadUrl(), other.downloadUrl()) && Objects.equals(this.layerDigest(), other.layerDigest());
    }

    public final String toString() {
        return ToString.builder((String)"GetDownloadUrlForLayerResponse").add("DownloadUrl", (Object)this.downloadUrl()).add("LayerDigest", (Object)this.layerDigest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "downloadUrl": {
                return Optional.ofNullable(clazz.cast(this.downloadUrl()));
            }
            case "layerDigest": {
                return Optional.ofNullable(clazz.cast(this.layerDigest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("downloadUrl", DOWNLOAD_URL_FIELD);
        map.put("layerDigest", LAYER_DIGEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDownloadUrlForLayerResponse, T> g) {
        return obj -> g.apply((GetDownloadUrlForLayerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String downloadUrl;
        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDownloadUrlForLayerResponse model) {
            super(model);
            this.downloadUrl(model.downloadUrl);
            this.layerDigest(model.layerDigest);
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        @Override
        public GetDownloadUrlForLayerResponse build() {
            return new GetDownloadUrlForLayerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
        public Builder downloadUrl(String var1);

        public Builder layerDigest(String var1);
    }
}

