/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.EncryptionConfigurationForRepositoryCreationTemplate;
import software.amazon.awssdk.services.ecr.model.ImageTagMutability;
import software.amazon.awssdk.services.ecr.model.RCTAppliedFor;
import software.amazon.awssdk.services.ecr.model.RCTAppliedForListCopier;
import software.amazon.awssdk.services.ecr.model.Tag;
import software.amazon.awssdk.services.ecr.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateRepositoryCreationTemplateRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, UpdateRepositoryCreationTemplateRequest> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::prefix)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::description)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EncryptionConfigurationForRepositoryCreationTemplate> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::encryptionConfiguration)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfigurationForRepositoryCreationTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final SdkField<List<Tag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTags").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::resourceTags)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageTagMutability").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::imageTagMutabilityAsString)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::imageTagMutability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build()}).build();
    private static final SdkField<String> REPOSITORY_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryPolicy").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::repositoryPolicy)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::repositoryPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryPolicy").build()}).build();
    private static final SdkField<String> LIFECYCLE_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecyclePolicy").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::lifecyclePolicy)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::lifecyclePolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicy").build()}).build();
    private static final SdkField<List<String>> APPLIED_FOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("appliedFor").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::appliedForAsStrings)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::appliedForWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appliedFor").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customRoleArn").getter(UpdateRepositoryCreationTemplateRequest.getter(UpdateRepositoryCreationTemplateRequest::customRoleArn)).setter(UpdateRepositoryCreationTemplateRequest.setter(Builder::customRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD, DESCRIPTION_FIELD, ENCRYPTION_CONFIGURATION_FIELD, RESOURCE_TAGS_FIELD, IMAGE_TAG_MUTABILITY_FIELD, REPOSITORY_POLICY_FIELD, LIFECYCLE_POLICY_FIELD, APPLIED_FOR_FIELD, CUSTOM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateRepositoryCreationTemplateRequest.memberNameToFieldInitializer();
    private final String prefix;
    private final String description;
    private final EncryptionConfigurationForRepositoryCreationTemplate encryptionConfiguration;
    private final List<Tag> resourceTags;
    private final String imageTagMutability;
    private final String repositoryPolicy;
    private final String lifecyclePolicy;
    private final List<String> appliedFor;
    private final String customRoleArn;

    private UpdateRepositoryCreationTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.prefix = builder.prefix;
        this.description = builder.description;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.resourceTags = builder.resourceTags;
        this.imageTagMutability = builder.imageTagMutability;
        this.repositoryPolicy = builder.repositoryPolicy;
        this.lifecyclePolicy = builder.lifecyclePolicy;
        this.appliedFor = builder.appliedFor;
        this.customRoleArn = builder.customRoleArn;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String description() {
        return this.description;
    }

    public final EncryptionConfigurationForRepositoryCreationTemplate encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> resourceTags() {
        return this.resourceTags;
    }

    public final ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(this.imageTagMutability);
    }

    public final String imageTagMutabilityAsString() {
        return this.imageTagMutability;
    }

    public final String repositoryPolicy() {
        return this.repositoryPolicy;
    }

    public final String lifecyclePolicy() {
        return this.lifecyclePolicy;
    }

    public final List<RCTAppliedFor> appliedFor() {
        return RCTAppliedForListCopier.copyStringToEnum(this.appliedFor);
    }

    public final boolean hasAppliedFor() {
        return this.appliedFor != null && !(this.appliedFor instanceof SdkAutoConstructList);
    }

    public final List<String> appliedForAsStrings() {
        return this.appliedFor;
    }

    public final String customRoleArn() {
        return this.customRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTagMutabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAppliedFor() ? this.appliedForAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRepositoryCreationTemplateRequest)) {
            return false;
        }
        UpdateRepositoryCreationTemplateRequest other = (UpdateRepositoryCreationTemplateRequest)((Object)obj);
        return Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && Objects.equals(this.imageTagMutabilityAsString(), other.imageTagMutabilityAsString()) && Objects.equals(this.repositoryPolicy(), other.repositoryPolicy()) && Objects.equals(this.lifecyclePolicy(), other.lifecyclePolicy()) && this.hasAppliedFor() == other.hasAppliedFor() && Objects.equals(this.appliedForAsStrings(), other.appliedForAsStrings()) && Objects.equals(this.customRoleArn(), other.customRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateRepositoryCreationTemplateRequest").add("Prefix", (Object)this.prefix()).add("Description", (Object)this.description()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("ImageTagMutability", (Object)this.imageTagMutabilityAsString()).add("RepositoryPolicy", (Object)this.repositoryPolicy()).add("LifecyclePolicy", (Object)this.lifecyclePolicy()).add("AppliedFor", this.hasAppliedFor() ? this.appliedForAsStrings() : null).add("CustomRoleArn", (Object)this.customRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "imageTagMutability": {
                return Optional.ofNullable(clazz.cast(this.imageTagMutabilityAsString()));
            }
            case "repositoryPolicy": {
                return Optional.ofNullable(clazz.cast(this.repositoryPolicy()));
            }
            case "lifecyclePolicy": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicy()));
            }
            case "appliedFor": {
                return Optional.ofNullable(clazz.cast(this.appliedForAsStrings()));
            }
            case "customRoleArn": {
                return Optional.ofNullable(clazz.cast(this.customRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("prefix", PREFIX_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        map.put("imageTagMutability", IMAGE_TAG_MUTABILITY_FIELD);
        map.put("repositoryPolicy", REPOSITORY_POLICY_FIELD);
        map.put("lifecyclePolicy", LIFECYCLE_POLICY_FIELD);
        map.put("appliedFor", APPLIED_FOR_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRepositoryCreationTemplateRequest, T> g) {
        return obj -> g.apply((UpdateRepositoryCreationTemplateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String prefix;
        private String description;
        private EncryptionConfigurationForRepositoryCreationTemplate encryptionConfiguration;
        private List<Tag> resourceTags = DefaultSdkAutoConstructList.getInstance();
        private String imageTagMutability;
        private String repositoryPolicy;
        private String lifecyclePolicy;
        private List<String> appliedFor = DefaultSdkAutoConstructList.getInstance();
        private String customRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRepositoryCreationTemplateRequest model) {
            super(model);
            this.prefix(model.prefix);
            this.description(model.description);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.resourceTags(model.resourceTags);
            this.imageTagMutability(model.imageTagMutability);
            this.repositoryPolicy(model.repositoryPolicy);
            this.lifecyclePolicy(model.lifecyclePolicy);
            this.appliedForWithStrings(model.appliedFor);
            this.customRoleArn(model.customRoleArn);
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EncryptionConfigurationForRepositoryCreationTemplate.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfigurationForRepositoryCreationTemplate.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfigurationForRepositoryCreationTemplate encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public final List<Tag.Builder> getResourceTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<Tag.BuilderImpl> resourceTags) {
            this.resourceTags = TagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<Tag> resourceTags) {
            this.resourceTags = TagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Tag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<Tag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getImageTagMutability() {
            return this.imageTagMutability;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final String getRepositoryPolicy() {
            return this.repositoryPolicy;
        }

        public final void setRepositoryPolicy(String repositoryPolicy) {
            this.repositoryPolicy = repositoryPolicy;
        }

        @Override
        public final Builder repositoryPolicy(String repositoryPolicy) {
            this.repositoryPolicy = repositoryPolicy;
            return this;
        }

        public final String getLifecyclePolicy() {
            return this.lifecyclePolicy;
        }

        public final void setLifecyclePolicy(String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
        }

        @Override
        public final Builder lifecyclePolicy(String lifecyclePolicy) {
            this.lifecyclePolicy = lifecyclePolicy;
            return this;
        }

        public final Collection<String> getAppliedFor() {
            if (this.appliedFor instanceof SdkAutoConstructList) {
                return null;
            }
            return this.appliedFor;
        }

        public final void setAppliedFor(Collection<String> appliedFor) {
            this.appliedFor = RCTAppliedForListCopier.copy(appliedFor);
        }

        @Override
        public final Builder appliedForWithStrings(Collection<String> appliedFor) {
            this.appliedFor = RCTAppliedForListCopier.copy(appliedFor);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedForWithStrings(String ... appliedFor) {
            this.appliedForWithStrings(Arrays.asList(appliedFor));
            return this;
        }

        @Override
        public final Builder appliedFor(Collection<RCTAppliedFor> appliedFor) {
            this.appliedFor = RCTAppliedForListCopier.copyEnumToString(appliedFor);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appliedFor(RCTAppliedFor ... appliedFor) {
            this.appliedFor(Arrays.asList(appliedFor));
            return this;
        }

        public final String getCustomRoleArn() {
            return this.customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRepositoryCreationTemplateRequest build() {
            return new UpdateRepositoryCreationTemplateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateRepositoryCreationTemplateRequest> {
        public Builder prefix(String var1);

        public Builder description(String var1);

        public Builder encryptionConfiguration(EncryptionConfigurationForRepositoryCreationTemplate var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfigurationForRepositoryCreationTemplate.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfigurationForRepositoryCreationTemplate)((EncryptionConfigurationForRepositoryCreationTemplate.Builder)EncryptionConfigurationForRepositoryCreationTemplate.builder().applyMutation(encryptionConfiguration)).build());
        }

        public Builder resourceTags(Collection<Tag> var1);

        public Builder resourceTags(Tag ... var1);

        public Builder resourceTags(Consumer<Tag.Builder> ... var1);

        public Builder imageTagMutability(String var1);

        public Builder imageTagMutability(ImageTagMutability var1);

        public Builder repositoryPolicy(String var1);

        public Builder lifecyclePolicy(String var1);

        public Builder appliedForWithStrings(Collection<String> var1);

        public Builder appliedForWithStrings(String ... var1);

        public Builder appliedFor(Collection<RCTAppliedFor> var1);

        public Builder appliedFor(RCTAppliedFor ... var1);

        public Builder customRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

