/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ImageUsageResourceTypeOptionValuesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageUsageResourceTypeOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageUsageResourceTypeOption> {
    private static final SdkField<String> OPTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionName").getter(ImageUsageResourceTypeOption.getter(ImageUsageResourceTypeOption::optionName)).setter(ImageUsageResourceTypeOption.setter(Builder::optionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionName").unmarshallLocationName("optionName").build()}).build();
    private static final SdkField<List<String>> OPTION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OptionValues").getter(ImageUsageResourceTypeOption.getter(ImageUsageResourceTypeOption::optionValues)).setter(ImageUsageResourceTypeOption.setter(Builder::optionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionValueSet").unmarshallLocationName("optionValueSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_NAME_FIELD, OPTION_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageUsageResourceTypeOption.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String optionName;
    private final List<String> optionValues;

    private ImageUsageResourceTypeOption(BuilderImpl builder) {
        this.optionName = builder.optionName;
        this.optionValues = builder.optionValues;
    }

    public final String optionName() {
        return this.optionName;
    }

    public final boolean hasOptionValues() {
        return this.optionValues != null && !(this.optionValues instanceof SdkAutoConstructList);
    }

    public final List<String> optionValues() {
        return this.optionValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionValues() ? this.optionValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageUsageResourceTypeOption)) {
            return false;
        }
        ImageUsageResourceTypeOption other = (ImageUsageResourceTypeOption)obj;
        return Objects.equals(this.optionName(), other.optionName()) && this.hasOptionValues() == other.hasOptionValues() && Objects.equals(this.optionValues(), other.optionValues());
    }

    public final String toString() {
        return ToString.builder((String)"ImageUsageResourceTypeOption").add("OptionName", (Object)this.optionName()).add("OptionValues", this.hasOptionValues() ? this.optionValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionName": {
                return Optional.ofNullable(clazz.cast(this.optionName()));
            }
            case "OptionValues": {
                return Optional.ofNullable(clazz.cast(this.optionValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OptionName", OPTION_NAME_FIELD);
        map.put("OptionValueSet", OPTION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageUsageResourceTypeOption, T> g) {
        return obj -> g.apply((ImageUsageResourceTypeOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String optionName;
        private List<String> optionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageUsageResourceTypeOption model) {
            this.optionName(model.optionName);
            this.optionValues(model.optionValues);
        }

        public final String getOptionName() {
            return this.optionName;
        }

        public final void setOptionName(String optionName) {
            this.optionName = optionName;
        }

        @Override
        public final Builder optionName(String optionName) {
            this.optionName = optionName;
            return this;
        }

        public final Collection<String> getOptionValues() {
            if (this.optionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.optionValues;
        }

        public final void setOptionValues(Collection<String> optionValues) {
            this.optionValues = ImageUsageResourceTypeOptionValuesListCopier.copy(optionValues);
        }

        @Override
        public final Builder optionValues(Collection<String> optionValues) {
            this.optionValues = ImageUsageResourceTypeOptionValuesListCopier.copy(optionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionValues(String ... optionValues) {
            this.optionValues(Arrays.asList(optionValues));
            return this;
        }

        public ImageUsageResourceTypeOption build() {
            return new ImageUsageResourceTypeOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageUsageResourceTypeOption> {
        public Builder optionName(String var1);

        public Builder optionValues(Collection<String> var1);

        public Builder optionValues(String ... var1);
    }
}

