/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the neuron accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NeuronInfo implements SdkPojo, Serializable, ToCopyableBuilder<NeuronInfo.Builder, NeuronInfo> {
    private static final SdkField<List<NeuronDeviceInfo>> NEURON_DEVICES_FIELD = SdkField
            .<List<NeuronDeviceInfo>> builder(MarshallingType.LIST)
            .memberName("NeuronDevices")
            .getter(getter(NeuronInfo::neuronDevices))
            .setter(setter(Builder::neuronDevices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NeuronDevices")
                    .unmarshallLocationName("neuronDevices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<NeuronDeviceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(NeuronDeviceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<Integer> TOTAL_NEURON_DEVICE_MEMORY_IN_MIB_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNeuronDeviceMemoryInMiB")
            .getter(getter(NeuronInfo::totalNeuronDeviceMemoryInMiB))
            .setter(setter(Builder::totalNeuronDeviceMemoryInMiB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNeuronDeviceMemoryInMiB")
                    .unmarshallLocationName("totalNeuronDeviceMemoryInMiB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEURON_DEVICES_FIELD,
            TOTAL_NEURON_DEVICE_MEMORY_IN_MIB_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<NeuronDeviceInfo> neuronDevices;

    private final Integer totalNeuronDeviceMemoryInMiB;

    private NeuronInfo(BuilderImpl builder) {
        this.neuronDevices = builder.neuronDevices;
        this.totalNeuronDeviceMemoryInMiB = builder.totalNeuronDeviceMemoryInMiB;
    }

    /**
     * For responses, this returns true if the service returned a value for the NeuronDevices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNeuronDevices() {
        return neuronDevices != null && !(neuronDevices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes the neuron accelerators for the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNeuronDevices} method.
     * </p>
     * 
     * @return Describes the neuron accelerators for the instance type.
     */
    public final List<NeuronDeviceInfo> neuronDevices() {
        return neuronDevices;
    }

    /**
     * <p>
     * The total size of the memory for the neuron accelerators for the instance type, in MiB.
     * </p>
     * 
     * @return The total size of the memory for the neuron accelerators for the instance type, in MiB.
     */
    public final Integer totalNeuronDeviceMemoryInMiB() {
        return totalNeuronDeviceMemoryInMiB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasNeuronDevices() ? neuronDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalNeuronDeviceMemoryInMiB());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeuronInfo)) {
            return false;
        }
        NeuronInfo other = (NeuronInfo) obj;
        return hasNeuronDevices() == other.hasNeuronDevices() && Objects.equals(neuronDevices(), other.neuronDevices())
                && Objects.equals(totalNeuronDeviceMemoryInMiB(), other.totalNeuronDeviceMemoryInMiB());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NeuronInfo").add("NeuronDevices", hasNeuronDevices() ? neuronDevices() : null)
                .add("TotalNeuronDeviceMemoryInMiB", totalNeuronDeviceMemoryInMiB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NeuronDevices":
            return Optional.ofNullable(clazz.cast(neuronDevices()));
        case "TotalNeuronDeviceMemoryInMiB":
            return Optional.ofNullable(clazz.cast(totalNeuronDeviceMemoryInMiB()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NeuronDevices", NEURON_DEVICES_FIELD);
        map.put("TotalNeuronDeviceMemoryInMiB", TOTAL_NEURON_DEVICE_MEMORY_IN_MIB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeuronInfo, T> g) {
        return obj -> g.apply((NeuronInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NeuronInfo> {
        /**
         * <p>
         * Describes the neuron accelerators for the instance type.
         * </p>
         * 
         * @param neuronDevices
         *        Describes the neuron accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neuronDevices(Collection<NeuronDeviceInfo> neuronDevices);

        /**
         * <p>
         * Describes the neuron accelerators for the instance type.
         * </p>
         * 
         * @param neuronDevices
         *        Describes the neuron accelerators for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neuronDevices(NeuronDeviceInfo... neuronDevices);

        /**
         * <p>
         * Describes the neuron accelerators for the instance type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.NeuronDeviceInfo.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.NeuronDeviceInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.NeuronDeviceInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #neuronDevices(List<NeuronDeviceInfo>)}.
         * 
         * @param neuronDevices
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.NeuronDeviceInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #neuronDevices(java.util.Collection<NeuronDeviceInfo>)
         */
        Builder neuronDevices(Consumer<NeuronDeviceInfo.Builder>... neuronDevices);

        /**
         * <p>
         * The total size of the memory for the neuron accelerators for the instance type, in MiB.
         * </p>
         * 
         * @param totalNeuronDeviceMemoryInMiB
         *        The total size of the memory for the neuron accelerators for the instance type, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB);
    }

    static final class BuilderImpl implements Builder {
        private List<NeuronDeviceInfo> neuronDevices = DefaultSdkAutoConstructList.getInstance();

        private Integer totalNeuronDeviceMemoryInMiB;

        private BuilderImpl() {
        }

        private BuilderImpl(NeuronInfo model) {
            neuronDevices(model.neuronDevices);
            totalNeuronDeviceMemoryInMiB(model.totalNeuronDeviceMemoryInMiB);
        }

        public final List<NeuronDeviceInfo.Builder> getNeuronDevices() {
            List<NeuronDeviceInfo.Builder> result = NeuronDeviceInfoListCopier.copyToBuilder(this.neuronDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNeuronDevices(Collection<NeuronDeviceInfo.BuilderImpl> neuronDevices) {
            this.neuronDevices = NeuronDeviceInfoListCopier.copyFromBuilder(neuronDevices);
        }

        @Override
        public final Builder neuronDevices(Collection<NeuronDeviceInfo> neuronDevices) {
            this.neuronDevices = NeuronDeviceInfoListCopier.copy(neuronDevices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neuronDevices(NeuronDeviceInfo... neuronDevices) {
            neuronDevices(Arrays.asList(neuronDevices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder neuronDevices(Consumer<NeuronDeviceInfo.Builder>... neuronDevices) {
            neuronDevices(Stream.of(neuronDevices).map(c -> NeuronDeviceInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotalNeuronDeviceMemoryInMiB() {
            return totalNeuronDeviceMemoryInMiB;
        }

        public final void setTotalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB) {
            this.totalNeuronDeviceMemoryInMiB = totalNeuronDeviceMemoryInMiB;
        }

        @Override
        public final Builder totalNeuronDeviceMemoryInMiB(Integer totalNeuronDeviceMemoryInMiB) {
            this.totalNeuronDeviceMemoryInMiB = totalNeuronDeviceMemoryInMiB;
            return this;
        }

        @Override
        public NeuronInfo build() {
            return new NeuronInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
