/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an instance type to use in a Capacity Reservation Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationFleetInstanceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationFleetInstanceSpecification.Builder, ReservationFleetInstanceSpecification> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(ReservationFleetInstanceSpecification::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("InstanceType").build()).build();

    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstancePlatform")
            .getter(getter(ReservationFleetInstanceSpecification::instancePlatformAsString))
            .setter(setter(Builder::instancePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform")
                    .unmarshallLocationName("InstancePlatform").build()).build();

    private static final SdkField<Double> WEIGHT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Weight")
            .getter(getter(ReservationFleetInstanceSpecification::weight))
            .setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight")
                    .unmarshallLocationName("Weight").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(ReservationFleetInstanceSpecification::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("AvailabilityZone").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(ReservationFleetInstanceSpecification::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("AvailabilityZoneId").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(ReservationFleetInstanceSpecification::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("EbsOptimized").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority")
            .getter(getter(ReservationFleetInstanceSpecification::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority")
                    .unmarshallLocationName("Priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INSTANCE_PLATFORM_FIELD, WEIGHT_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, EBS_OPTIMIZED_FIELD,
            PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("InstanceType", INSTANCE_TYPE_FIELD);
                    put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
                    put("Weight", WEIGHT_FIELD);
                    put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
                    put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
                    put("EbsOptimized", EBS_OPTIMIZED_FIELD);
                    put("Priority", PRIORITY_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String instancePlatform;

    private final Double weight;

    private final String availabilityZone;

    private final String availabilityZoneId;

    private final Boolean ebsOptimized;

    private final Integer priority;

    private ReservationFleetInstanceSpecification(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.weight = builder.weight;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.ebsOptimized = builder.ebsOptimized;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The instance type for which the Capacity Reservation Fleet reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for which the Capacity Reservation Fleet reserves capacity.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type for which the Capacity Reservation Fleet reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for which the Capacity Reservation Fleet reserves capacity.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation Fleet reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(instancePlatform);
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation Fleet reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final String instancePlatformAsString() {
        return instancePlatform;
    }

    /**
     * <p>
     * The number of capacity units provided by the specified instance type. This value, together with the total target
     * capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves capacity.
     * Both values are based on units that make sense for your workload. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target
     * capacity</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The number of capacity units provided by the specified instance type. This value, together with the total
     *         target capacity that you specify for the Fleet determine the number of instances for which the Fleet
     *         reserves capacity. Both values are based on units that make sense for your workload. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total
     *         target capacity</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Double weight() {
        return weight;
    }

    /**
     * <p>
     * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity Reservation Fleet
     * can't span Availability Zones. All instance type specifications that you specify for the Fleet must use the same
     * Availability Zone.
     * </p>
     * 
     * @return The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
     *         Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for
     *         the Fleet must use the same Availability Zone.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
     * Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet
     * must use the same Availability Zone.
     * </p>
     * 
     * @return The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
     *         Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for
     *         the Fleet must use the same Availability Zone.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This optimization
     * provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O
     * performance. This optimization isn't available with all instance types. Additional usage charges apply when using
     * EBS-optimized instance types.
     * </p>
     * 
     * @return Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This
     *         optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide
     *         optimal I/O performance. This optimization isn't available with all instance types. Additional usage
     *         charges apply when using EBS-optimized instance types.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The priority to assign to the instance type. This value is used to determine which of the instance types
     * specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type
     * priority</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The priority to assign to the instance type. This value is used to determine which of the instance types
     *         specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority"
     *         >Instance type priority</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationFleetInstanceSpecification)) {
            return false;
        }
        ReservationFleetInstanceSpecification other = (ReservationFleetInstanceSpecification) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instancePlatformAsString(), other.instancePlatformAsString())
                && Objects.equals(weight(), other.weight()) && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(ebsOptimized(), other.ebsOptimized()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReservationFleetInstanceSpecification").add("InstanceType", instanceTypeAsString())
                .add("InstancePlatform", instancePlatformAsString()).add("Weight", weight())
                .add("AvailabilityZone", availabilityZone()).add("AvailabilityZoneId", availabilityZoneId())
                .add("EbsOptimized", ebsOptimized()).add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstancePlatform":
            return Optional.ofNullable(clazz.cast(instancePlatformAsString()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ReservationFleetInstanceSpecification, T> g) {
        return obj -> g.apply((ReservationFleetInstanceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationFleetInstanceSpecification> {
        /**
         * <p>
         * The instance type for which the Capacity Reservation Fleet reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The instance type for which the Capacity Reservation Fleet reserves capacity.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for which the Capacity Reservation Fleet reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The instance type for which the Capacity Reservation Fleet reserves capacity.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(String instancePlatform);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation Fleet reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform);

        /**
         * <p>
         * The number of capacity units provided by the specified instance type. This value, together with the total
         * target capacity that you specify for the Fleet determine the number of instances for which the Fleet reserves
         * capacity. Both values are based on units that make sense for your workload. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target
         * capacity</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param weight
         *        The number of capacity units provided by the specified instance type. This value, together with the
         *        total target capacity that you specify for the Fleet determine the number of instances for which the
         *        Fleet reserves capacity. Both values are based on units that make sense for your workload. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total
         *        target capacity</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Double weight);

        /**
         * <p>
         * The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity Reservation
         * Fleet can't span Availability Zones. All instance type specifications that you specify for the Fleet must use
         * the same Availability Zone.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
         *        Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for
         *        the Fleet must use the same Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A Capacity
         * Reservation Fleet can't span Availability Zones. All instance type specifications that you specify for the
         * Fleet must use the same Availability Zone.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone in which the Capacity Reservation Fleet reserves the capacity. A
         *        Capacity Reservation Fleet can't span Availability Zones. All instance type specifications that you
         *        specify for the Fleet must use the same Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This optimization
         * provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal I/O
         * performance. This optimization isn't available with all instance types. Additional usage charges apply when
         * using EBS-optimized instance types.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the Capacity Reservation Fleet supports EBS-optimized instances types. This
         *        optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to
         *        provide optimal I/O performance. This optimization isn't available with all instance types. Additional
         *        usage charges apply when using EBS-optimized instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The priority to assign to the instance type. This value is used to determine which of the instance types
         * specified for the Fleet should be prioritized for use. A lower value indicates a high priority. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance
         * type priority</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param priority
         *        The priority to assign to the instance type. This value is used to determine which of the instance
         *        types specified for the Fleet should be prioritized for use. A lower value indicates a high priority.
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority"
         *        >Instance type priority</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String instancePlatform;

        private Double weight;

        private String availabilityZone;

        private String availabilityZoneId;

        private Boolean ebsOptimized;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationFleetInstanceSpecification model) {
            instanceType(model.instanceType);
            instancePlatform(model.instancePlatform);
            weight(model.weight);
            availabilityZone(model.availabilityZone);
            availabilityZoneId(model.availabilityZoneId);
            ebsOptimized(model.ebsOptimized);
            priority(model.priority);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getInstancePlatform() {
            return instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final Double getWeight() {
            return weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public ReservationFleetInstanceSpecification build() {
            return new ReservationFleetInstanceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
