/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteNetworkAclEntryRequest extends Ec2Request implements
        ToCopyableBuilder<DeleteNetworkAclEntryRequest.Builder, DeleteNetworkAclEntryRequest> {
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun")
            .getter(getter(DeleteNetworkAclEntryRequest::dryRun))
            .setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun")
                    .unmarshallLocationName("dryRun").build()).build();

    private static final SdkField<String> NETWORK_ACL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkAclId")
            .getter(getter(DeleteNetworkAclEntryRequest::networkAclId))
            .setter(setter(Builder::networkAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAclId")
                    .unmarshallLocationName("networkAclId").build()).build();

    private static final SdkField<Integer> RULE_NUMBER_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RuleNumber")
            .getter(getter(DeleteNetworkAclEntryRequest::ruleNumber))
            .setter(setter(Builder::ruleNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNumber")
                    .unmarshallLocationName("ruleNumber").build()).build();

    private static final SdkField<Boolean> EGRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Egress")
            .getter(getter(DeleteNetworkAclEntryRequest::egress))
            .setter(setter(Builder::egress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Egress")
                    .unmarshallLocationName("egress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DRY_RUN_FIELD,
            NETWORK_ACL_ID_FIELD, RULE_NUMBER_FIELD, EGRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DryRun", DRY_RUN_FIELD);
                    put("NetworkAclId", NETWORK_ACL_ID_FIELD);
                    put("RuleNumber", RULE_NUMBER_FIELD);
                    put("Egress", EGRESS_FIELD);
                }
            });

    private final Boolean dryRun;

    private final String networkAclId;

    private final Integer ruleNumber;

    private final Boolean egress;

    private DeleteNetworkAclEntryRequest(BuilderImpl builder) {
        super(builder);
        this.dryRun = builder.dryRun;
        this.networkAclId = builder.networkAclId;
        this.ruleNumber = builder.ruleNumber;
        this.egress = builder.egress;
    }

    /**
     * <p>
     * Checks whether you have the required permissions for the action, without actually making the request, and
     * provides an error response. If you have the required permissions, the error response is
     * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     * </p>
     * 
     * @return Checks whether you have the required permissions for the action, without actually making the request, and
     *         provides an error response. If you have the required permissions, the error response is
     *         <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public final String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The rule number of the entry to delete.
     * </p>
     * 
     * @return The rule number of the entry to delete.
     */
    public final Integer ruleNumber() {
        return ruleNumber;
    }

    /**
     * <p>
     * Indicates whether the rule is an egress rule.
     * </p>
     * 
     * @return Indicates whether the rule is an egress rule.
     */
    public final Boolean egress() {
        return egress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(networkAclId());
        hashCode = 31 * hashCode + Objects.hashCode(ruleNumber());
        hashCode = 31 * hashCode + Objects.hashCode(egress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNetworkAclEntryRequest)) {
            return false;
        }
        DeleteNetworkAclEntryRequest other = (DeleteNetworkAclEntryRequest) obj;
        return Objects.equals(dryRun(), other.dryRun()) && Objects.equals(networkAclId(), other.networkAclId())
                && Objects.equals(ruleNumber(), other.ruleNumber()) && Objects.equals(egress(), other.egress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteNetworkAclEntryRequest").add("DryRun", dryRun()).add("NetworkAclId", networkAclId())
                .add("RuleNumber", ruleNumber()).add("Egress", egress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        case "NetworkAclId":
            return Optional.ofNullable(clazz.cast(networkAclId()));
        case "RuleNumber":
            return Optional.ofNullable(clazz.cast(ruleNumber()));
        case "Egress":
            return Optional.ofNullable(clazz.cast(egress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteNetworkAclEntryRequest, T> g) {
        return obj -> g.apply((DeleteNetworkAclEntryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Request.Builder, SdkPojo, CopyableBuilder<Builder, DeleteNetworkAclEntryRequest> {
        /**
         * <p>
         * Checks whether you have the required permissions for the action, without actually making the request, and
         * provides an error response. If you have the required permissions, the error response is
         * <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * </p>
         * 
         * @param dryRun
         *        Checks whether you have the required permissions for the action, without actually making the request,
         *        and provides an error response. If you have the required permissions, the error response is
         *        <code>DryRunOperation</code>. Otherwise, it is <code>UnauthorizedOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The rule number of the entry to delete.
         * </p>
         * 
         * @param ruleNumber
         *        The rule number of the entry to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNumber(Integer ruleNumber);

        /**
         * <p>
         * Indicates whether the rule is an egress rule.
         * </p>
         * 
         * @param egress
         *        Indicates whether the rule is an egress rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder egress(Boolean egress);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends Ec2Request.BuilderImpl implements Builder {
        private Boolean dryRun;

        private String networkAclId;

        private Integer ruleNumber;

        private Boolean egress;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNetworkAclEntryRequest model) {
            super(model);
            dryRun(model.dryRun);
            networkAclId(model.networkAclId);
            ruleNumber(model.ruleNumber);
            egress(model.egress);
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final Integer getRuleNumber() {
            return ruleNumber;
        }

        public final void setRuleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
        }

        @Override
        public final Builder ruleNumber(Integer ruleNumber) {
            this.ruleNumber = ruleNumber;
            return this;
        }

        public final Boolean getEgress() {
            return egress;
        }

        public final void setEgress(Boolean egress) {
            this.egress = egress;
        }

        @Override
        public final Builder egress(Boolean egress) {
            this.egress = egress;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteNetworkAclEntryRequest build() {
            return new DeleteNetworkAclEntryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
