/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmProductInstanceResponse extends Ec2Response implements
        ToCopyableBuilder<ConfirmProductInstanceResponse.Builder, ConfirmProductInstanceResponse> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OwnerId")
            .getter(getter(ConfirmProductInstanceResponse::ownerId))
            .setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId")
                    .unmarshallLocationName("ownerId").build()).build();

    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnValue")
            .getter(getter(ConfirmProductInstanceResponse::returnValue))
            .setter(setter(Builder::returnValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return")
                    .unmarshallLocationName("return").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD,
            RETURN_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("OwnerId", OWNER_ID_FIELD);
                    put("Return", RETURN_VALUE_FIELD);
                }
            });

    private final String ownerId;

    private final Boolean returnValue;

    private ConfirmProductInstanceResponse(BuilderImpl builder) {
        super(builder);
        this.ownerId = builder.ownerId;
        this.returnValue = builder.returnValue;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the instance owner. This is only present if the product code is attached to
     * the instance.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the instance owner. This is only present if the product code is
     *         attached to the instance.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The return value of the request. Returns <code>true</code> if the specified product code is owned by the
     * requester and associated with the specified instance.
     * </p>
     * 
     * @return The return value of the request. Returns <code>true</code> if the specified product code is owned by the
     *         requester and associated with the specified instance.
     */
    public final Boolean returnValue() {
        return returnValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(returnValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmProductInstanceResponse)) {
            return false;
        }
        ConfirmProductInstanceResponse other = (ConfirmProductInstanceResponse) obj;
        return Objects.equals(ownerId(), other.ownerId()) && Objects.equals(returnValue(), other.returnValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfirmProductInstanceResponse").add("OwnerId", ownerId()).add("ReturnValue", returnValue())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "ReturnValue":
            return Optional.ofNullable(clazz.cast(returnValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConfirmProductInstanceResponse, T> g) {
        return obj -> g.apply((ConfirmProductInstanceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, ConfirmProductInstanceResponse> {
        /**
         * <p>
         * The Amazon Web Services account ID of the instance owner. This is only present if the product code is
         * attached to the instance.
         * </p>
         * 
         * @param ownerId
         *        The Amazon Web Services account ID of the instance owner. This is only present if the product code is
         *        attached to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The return value of the request. Returns <code>true</code> if the specified product code is owned by the
         * requester and associated with the specified instance.
         * </p>
         * 
         * @param returnValue
         *        The return value of the request. Returns <code>true</code> if the specified product code is owned by
         *        the requester and associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnValue(Boolean returnValue);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String ownerId;

        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmProductInstanceResponse model) {
            super(model);
            ownerId(model.ownerId);
            returnValue(model.returnValue);
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Boolean getReturnValue() {
            return returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        @Override
        public ConfirmProductInstanceResponse build() {
            return new ConfirmProductInstanceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
