/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.Trust;

public class DescribeTrustsPublisher
implements SdkPublisher<DescribeTrustsResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeTrustsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeTrustsPublisher(DirectoryAsyncClient client, DescribeTrustsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeTrustsPublisher(DirectoryAsyncClient client, DescribeTrustsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeTrustsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeTrustsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Trust> trusts() {
        Function<DescribeTrustsResponse, Iterator> getIterator = response -> {
            if (response != null && response.trusts() != null) {
                return response.trusts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeTrustsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeTrustsResponseFetcher
    implements AsyncPageFetcher<DescribeTrustsResponse> {
        private DescribeTrustsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTrustsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeTrustsResponse> nextPage(DescribeTrustsResponse previousPage) {
            if (previousPage == null) {
                return DescribeTrustsPublisher.this.client.describeTrusts(DescribeTrustsPublisher.this.firstRequest);
            }
            return DescribeTrustsPublisher.this.client.describeTrusts((DescribeTrustsRequest)((Object)DescribeTrustsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

