/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The policy directives and their values that CloudFront includes as values for the
 * <code>Content-Security-Policy</code> HTTP response header.
 * </p>
 * <p>
 * For more information about the <code>Content-Security-Policy</code> HTTP response header, see <a
 * href="https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy">Content-Security-Policy</a>
 * in the MDN Web Docs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyContentSecurityPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyContentSecurityPolicy.Builder, ResponseHeadersPolicyContentSecurityPolicy> {
    private static final SdkField<Boolean> OVERRIDE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Override")
            .getter(getter(ResponseHeadersPolicyContentSecurityPolicy::override))
            .setter(setter(Builder::override))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Override")
                    .unmarshallLocationName("Override").build()).build();

    private static final SdkField<String> CONTENT_SECURITY_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentSecurityPolicy")
            .getter(getter(ResponseHeadersPolicyContentSecurityPolicy::contentSecurityPolicy))
            .setter(setter(Builder::contentSecurityPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSecurityPolicy")
                    .unmarshallLocationName("ContentSecurityPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_FIELD,
            CONTENT_SECURITY_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean override;

    private final String contentSecurityPolicy;

    private ResponseHeadersPolicyContentSecurityPolicy(BuilderImpl builder) {
        this.override = builder.override;
        this.contentSecurityPolicy = builder.contentSecurityPolicy;
    }

    /**
     * <p>
     * A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP response
     * header received from the origin with the one specified in this response headers policy.
     * </p>
     * 
     * @return A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP
     *         response header received from the origin with the one specified in this response headers policy.
     */
    public final Boolean override() {
        return override;
    }

    /**
     * <p>
     * The policy directives and their values that CloudFront includes as values for the
     * <code>Content-Security-Policy</code> HTTP response header.
     * </p>
     * 
     * @return The policy directives and their values that CloudFront includes as values for the
     *         <code>Content-Security-Policy</code> HTTP response header.
     */
    public final String contentSecurityPolicy() {
        return contentSecurityPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(override());
        hashCode = 31 * hashCode + Objects.hashCode(contentSecurityPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyContentSecurityPolicy)) {
            return false;
        }
        ResponseHeadersPolicyContentSecurityPolicy other = (ResponseHeadersPolicyContentSecurityPolicy) obj;
        return Objects.equals(override(), other.override())
                && Objects.equals(contentSecurityPolicy(), other.contentSecurityPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyContentSecurityPolicy").add("Override", override())
                .add("ContentSecurityPolicy", contentSecurityPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Override":
            return Optional.ofNullable(clazz.cast(override()));
        case "ContentSecurityPolicy":
            return Optional.ofNullable(clazz.cast(contentSecurityPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Override", OVERRIDE_FIELD);
        map.put("ContentSecurityPolicy", CONTENT_SECURITY_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyContentSecurityPolicy, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyContentSecurityPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyContentSecurityPolicy> {
        /**
         * <p>
         * A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP response
         * header received from the origin with the one specified in this response headers policy.
         * </p>
         * 
         * @param override
         *        A Boolean that determines whether CloudFront overrides the <code>Content-Security-Policy</code> HTTP
         *        response header received from the origin with the one specified in this response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder override(Boolean override);

        /**
         * <p>
         * The policy directives and their values that CloudFront includes as values for the
         * <code>Content-Security-Policy</code> HTTP response header.
         * </p>
         * 
         * @param contentSecurityPolicy
         *        The policy directives and their values that CloudFront includes as values for the
         *        <code>Content-Security-Policy</code> HTTP response header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSecurityPolicy(String contentSecurityPolicy);
    }

    static final class BuilderImpl implements Builder {
        private Boolean override;

        private String contentSecurityPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyContentSecurityPolicy model) {
            override(model.override);
            contentSecurityPolicy(model.contentSecurityPolicy);
        }

        public final Boolean getOverride() {
            return override;
        }

        public final void setOverride(Boolean override) {
            this.override = override;
        }

        @Override
        public final Builder override(Boolean override) {
            this.override = override;
            return this;
        }

        public final String getContentSecurityPolicy() {
            return contentSecurityPolicy;
        }

        public final void setContentSecurityPolicy(String contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
        }

        @Override
        public final Builder contentSecurityPolicy(String contentSecurityPolicy) {
            this.contentSecurityPolicy = contentSecurityPolicy;
            return this;
        }

        @Override
        public ResponseHeadersPolicyContentSecurityPolicy build() {
            return new ResponseHeadersPolicyContentSecurityPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
