/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublishFunctionResponse extends CloudFrontResponse implements
        ToCopyableBuilder<PublishFunctionResponse.Builder, PublishFunctionResponse> {
    private static final SdkField<FunctionSummary> FUNCTION_SUMMARY_FIELD = SdkField
            .<FunctionSummary> builder(MarshallingType.SDK_POJO)
            .memberName("FunctionSummary")
            .getter(getter(PublishFunctionResponse::functionSummary))
            .setter(setter(Builder::functionSummary))
            .constructor(FunctionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FunctionSummary")
                    .unmarshallLocationName("FunctionSummary").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final FunctionSummary functionSummary;

    private PublishFunctionResponse(BuilderImpl builder) {
        super(builder);
        this.functionSummary = builder.functionSummary;
    }

    /**
     * <p>
     * Contains configuration information and metadata about a CloudFront function.
     * </p>
     * 
     * @return Contains configuration information and metadata about a CloudFront function.
     */
    public final FunctionSummary functionSummary() {
        return functionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(functionSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishFunctionResponse)) {
            return false;
        }
        PublishFunctionResponse other = (PublishFunctionResponse) obj;
        return Objects.equals(functionSummary(), other.functionSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublishFunctionResponse").add("FunctionSummary", functionSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FunctionSummary":
            return Optional.ofNullable(clazz.cast(functionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FunctionSummary", FUNCTION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PublishFunctionResponse, T> g) {
        return obj -> g.apply((PublishFunctionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontResponse.Builder, SdkPojo, CopyableBuilder<Builder, PublishFunctionResponse> {
        /**
         * <p>
         * Contains configuration information and metadata about a CloudFront function.
         * </p>
         * 
         * @param functionSummary
         *        Contains configuration information and metadata about a CloudFront function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionSummary(FunctionSummary functionSummary);

        /**
         * <p>
         * Contains configuration information and metadata about a CloudFront function.
         * </p>
         * This is a convenience method that creates an instance of the {@link FunctionSummary.Builder} avoiding the
         * need to create one manually via {@link FunctionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FunctionSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #functionSummary(FunctionSummary)}.
         * 
         * @param functionSummary
         *        a consumer that will call methods on {@link FunctionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #functionSummary(FunctionSummary)
         */
        default Builder functionSummary(Consumer<FunctionSummary.Builder> functionSummary) {
            return functionSummary(FunctionSummary.builder().applyMutation(functionSummary).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private FunctionSummary functionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishFunctionResponse model) {
            super(model);
            functionSummary(model.functionSummary);
        }

        public final FunctionSummary.Builder getFunctionSummary() {
            return functionSummary != null ? functionSummary.toBuilder() : null;
        }

        public final void setFunctionSummary(FunctionSummary.BuilderImpl functionSummary) {
            this.functionSummary = functionSummary != null ? functionSummary.build() : null;
        }

        @Override
        public final Builder functionSummary(FunctionSummary functionSummary) {
            this.functionSummary = functionSummary;
            return this;
        }

        @Override
        public PublishFunctionResponse build() {
            return new PublishFunctionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
