/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyAttachment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyAttachment> {
    private static final SdkField<String> POLICY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyId").getter(PolicyAttachment.getter(PolicyAttachment::policyId)).setter(PolicyAttachment.setter(Builder::policyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyId").build()}).build();
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectIdentifier").getter(PolicyAttachment.getter(PolicyAttachment::objectIdentifier)).setter(PolicyAttachment.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyType").getter(PolicyAttachment.getter(PolicyAttachment::policyType)).setter(PolicyAttachment.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ID_FIELD, OBJECT_IDENTIFIER_FIELD, POLICY_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String policyId;
    private final String objectIdentifier;
    private final String policyType;

    private PolicyAttachment(BuilderImpl builder) {
        this.policyId = builder.policyId;
        this.objectIdentifier = builder.objectIdentifier;
        this.policyType = builder.policyType;
    }

    public final String policyId() {
        return this.policyId;
    }

    public final String objectIdentifier() {
        return this.objectIdentifier;
    }

    public final String policyType() {
        return this.policyType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyAttachment)) {
            return false;
        }
        PolicyAttachment other = (PolicyAttachment)obj;
        return Objects.equals(this.policyId(), other.policyId()) && Objects.equals(this.objectIdentifier(), other.objectIdentifier()) && Objects.equals(this.policyType(), other.policyType());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyAttachment").add("PolicyId", (Object)this.policyId()).add("ObjectIdentifier", (Object)this.objectIdentifier()).add("PolicyType", (Object)this.policyType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyId": {
                return Optional.ofNullable(clazz.cast(this.policyId()));
            }
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
            case "PolicyType": {
                return Optional.ofNullable(clazz.cast(this.policyType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyAttachment, T> g) {
        return obj -> g.apply((PolicyAttachment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String policyId;
        private String objectIdentifier;
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyAttachment model) {
            this.policyId(model.policyId);
            this.objectIdentifier(model.objectIdentifier);
            this.policyType(model.policyType);
        }

        public final String getPolicyId() {
            return this.policyId;
        }

        public final void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        @Override
        public final Builder policyId(String policyId) {
            this.policyId = policyId;
            return this;
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        public PolicyAttachment build() {
            return new PolicyAttachment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyAttachment> {
        public Builder policyId(String var1);

        public Builder objectIdentifier(String var1);

        public Builder policyType(String var1);
    }
}

