/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.dlm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <b>[Snapshot policies only]</b> Specifies information about the archive storage tier retention period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArchiveRetainRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ArchiveRetainRule.Builder, ArchiveRetainRule> {
    private static final SdkField<RetentionArchiveTier> RETENTION_ARCHIVE_TIER_FIELD = SdkField
            .<RetentionArchiveTier> builder(MarshallingType.SDK_POJO).memberName("RetentionArchiveTier")
            .getter(getter(ArchiveRetainRule::retentionArchiveTier)).setter(setter(Builder::retentionArchiveTier))
            .constructor(RetentionArchiveTier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionArchiveTier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_ARCHIVE_TIER_FIELD));

    private static final long serialVersionUID = 1L;

    private final RetentionArchiveTier retentionArchiveTier;

    private ArchiveRetainRule(BuilderImpl builder) {
        this.retentionArchiveTier = builder.retentionArchiveTier;
    }

    /**
     * <p>
     * Information about retention period in the Amazon EBS Snapshots Archive. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS
     * snapshots</a>.
     * </p>
     * 
     * @return Information about retention period in the Amazon EBS Snapshots Archive. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS
     *         snapshots</a>.
     */
    public final RetentionArchiveTier retentionArchiveTier() {
        return retentionArchiveTier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionArchiveTier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveRetainRule)) {
            return false;
        }
        ArchiveRetainRule other = (ArchiveRetainRule) obj;
        return Objects.equals(retentionArchiveTier(), other.retentionArchiveTier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArchiveRetainRule").add("RetentionArchiveTier", retentionArchiveTier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionArchiveTier":
            return Optional.ofNullable(clazz.cast(retentionArchiveTier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArchiveRetainRule, T> g) {
        return obj -> g.apply((ArchiveRetainRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArchiveRetainRule> {
        /**
         * <p>
         * Information about retention period in the Amazon EBS Snapshots Archive. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS
         * snapshots</a>.
         * </p>
         * 
         * @param retentionArchiveTier
         *        Information about retention period in the Amazon EBS Snapshots Archive. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS
         *        snapshots</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionArchiveTier(RetentionArchiveTier retentionArchiveTier);

        /**
         * <p>
         * Information about retention period in the Amazon EBS Snapshots Archive. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/snapshot-archive.html">Archive Amazon EBS
         * snapshots</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link RetentionArchiveTier.Builder} avoiding
         * the need to create one manually via {@link RetentionArchiveTier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RetentionArchiveTier.Builder#build()} is called immediately and
         * its result is passed to {@link #retentionArchiveTier(RetentionArchiveTier)}.
         * 
         * @param retentionArchiveTier
         *        a consumer that will call methods on {@link RetentionArchiveTier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retentionArchiveTier(RetentionArchiveTier)
         */
        default Builder retentionArchiveTier(Consumer<RetentionArchiveTier.Builder> retentionArchiveTier) {
            return retentionArchiveTier(RetentionArchiveTier.builder().applyMutation(retentionArchiveTier).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RetentionArchiveTier retentionArchiveTier;

        private BuilderImpl() {
        }

        private BuilderImpl(ArchiveRetainRule model) {
            retentionArchiveTier(model.retentionArchiveTier);
        }

        public final RetentionArchiveTier.Builder getRetentionArchiveTier() {
            return retentionArchiveTier != null ? retentionArchiveTier.toBuilder() : null;
        }

        public final void setRetentionArchiveTier(RetentionArchiveTier.BuilderImpl retentionArchiveTier) {
            this.retentionArchiveTier = retentionArchiveTier != null ? retentionArchiveTier.build() : null;
        }

        @Override
        public final Builder retentionArchiveTier(RetentionArchiveTier retentionArchiveTier) {
            this.retentionArchiveTier = retentionArchiveTier;
            return this;
        }

        @Override
        public ArchiveRetainRule build() {
            return new ArchiveRetainRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
