/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An entry of update information related to a requested update type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateInfoEntry implements SdkPojo, Serializable, ToCopyableBuilder<UpdateInfoEntry.Builder, UpdateInfoEntry> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(UpdateInfoEntry::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateInfoEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(UpdateInfoEntry::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiatedBy").getter(getter(UpdateInfoEntry::initiatedBy)).setter(setter(Builder::initiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()).build();

    private static final SdkField<UpdateValue> NEW_VALUE_FIELD = SdkField.<UpdateValue> builder(MarshallingType.SDK_POJO)
            .memberName("NewValue").getter(getter(UpdateInfoEntry::newValue)).setter(setter(Builder::newValue))
            .constructor(UpdateValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()).build();

    private static final SdkField<UpdateValue> PREVIOUS_VALUE_FIELD = SdkField.<UpdateValue> builder(MarshallingType.SDK_POJO)
            .memberName("PreviousValue").getter(getter(UpdateInfoEntry::previousValue)).setter(setter(Builder::previousValue))
            .constructor(UpdateValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValue").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(UpdateInfoEntry::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDateTime").getter(getter(UpdateInfoEntry::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, INITIATED_BY_FIELD, NEW_VALUE_FIELD, PREVIOUS_VALUE_FIELD, START_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String status;

    private final String statusReason;

    private final String initiatedBy;

    private final UpdateValue newValue;

    private final UpdateValue previousValue;

    private final Instant startTime;

    private final Instant lastUpdatedDateTime;

    private UpdateInfoEntry(BuilderImpl builder) {
        this.region = builder.region;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.initiatedBy = builder.initiatedBy;
        this.newValue = builder.newValue;
        this.previousValue = builder.previousValue;
        this.startTime = builder.startTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The name of the Region.
     * </p>
     * 
     * @return The name of the Region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The status of the update performed on the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the update performed on the directory.
     * @see UpdateStatus
     */
    public final UpdateStatus status() {
        return UpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the update performed on the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the update performed on the directory.
     * @see UpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason for the current status of the update type activity.
     * </p>
     * 
     * @return The reason for the current status of the update type activity.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * This specifies if the update was initiated by the customer or by the service team.
     * </p>
     * 
     * @return This specifies if the update was initiated by the customer or by the service team.
     */
    public final String initiatedBy() {
        return initiatedBy;
    }

    /**
     * <p>
     * The new value of the target setting.
     * </p>
     * 
     * @return The new value of the target setting.
     */
    public final UpdateValue newValue() {
        return newValue;
    }

    /**
     * <p>
     * The old value of the target setting.
     * </p>
     * 
     * @return The old value of the target setting.
     */
    public final UpdateValue previousValue() {
        return previousValue;
    }

    /**
     * <p>
     * The start time of the <code>UpdateDirectorySetup</code> for the particular type.
     * </p>
     * 
     * @return The start time of the <code>UpdateDirectorySetup</code> for the particular type.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The last updated date and time of a particular directory setting.
     * </p>
     * 
     * @return The last updated date and time of a particular directory setting.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        hashCode = 31 * hashCode + Objects.hashCode(previousValue());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInfoEntry)) {
            return false;
        }
        UpdateInfoEntry other = (UpdateInfoEntry) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(initiatedBy(), other.initiatedBy())
                && Objects.equals(newValue(), other.newValue()) && Objects.equals(previousValue(), other.previousValue())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateInfoEntry").add("Region", region()).add("Status", statusAsString())
                .add("StatusReason", statusReason()).add("InitiatedBy", initiatedBy()).add("NewValue", newValue())
                .add("PreviousValue", previousValue()).add("StartTime", startTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "InitiatedBy":
            return Optional.ofNullable(clazz.cast(initiatedBy()));
        case "NewValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        case "PreviousValue":
            return Optional.ofNullable(clazz.cast(previousValue()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateInfoEntry, T> g) {
        return obj -> g.apply((UpdateInfoEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateInfoEntry> {
        /**
         * <p>
         * The name of the Region.
         * </p>
         * 
         * @param region
         *        The name of the Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The status of the update performed on the directory.
         * </p>
         * 
         * @param status
         *        The status of the update performed on the directory.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the update performed on the directory.
         * </p>
         * 
         * @param status
         *        The status of the update performed on the directory.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(UpdateStatus status);

        /**
         * <p>
         * The reason for the current status of the update type activity.
         * </p>
         * 
         * @param statusReason
         *        The reason for the current status of the update type activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * This specifies if the update was initiated by the customer or by the service team.
         * </p>
         * 
         * @param initiatedBy
         *        This specifies if the update was initiated by the customer or by the service team.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedBy(String initiatedBy);

        /**
         * <p>
         * The new value of the target setting.
         * </p>
         * 
         * @param newValue
         *        The new value of the target setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(UpdateValue newValue);

        /**
         * <p>
         * The new value of the target setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateValue.Builder} avoiding the need to
         * create one manually via {@link UpdateValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateValue.Builder#build()} is called immediately and its result
         * is passed to {@link #newValue(UpdateValue)}.
         * 
         * @param newValue
         *        a consumer that will call methods on {@link UpdateValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newValue(UpdateValue)
         */
        default Builder newValue(Consumer<UpdateValue.Builder> newValue) {
            return newValue(UpdateValue.builder().applyMutation(newValue).build());
        }

        /**
         * <p>
         * The old value of the target setting.
         * </p>
         * 
         * @param previousValue
         *        The old value of the target setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousValue(UpdateValue previousValue);

        /**
         * <p>
         * The old value of the target setting.
         * </p>
         * This is a convenience method that creates an instance of the {@link UpdateValue.Builder} avoiding the need to
         * create one manually via {@link UpdateValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateValue.Builder#build()} is called immediately and its result
         * is passed to {@link #previousValue(UpdateValue)}.
         * 
         * @param previousValue
         *        a consumer that will call methods on {@link UpdateValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousValue(UpdateValue)
         */
        default Builder previousValue(Consumer<UpdateValue.Builder> previousValue) {
            return previousValue(UpdateValue.builder().applyMutation(previousValue).build());
        }

        /**
         * <p>
         * The start time of the <code>UpdateDirectorySetup</code> for the particular type.
         * </p>
         * 
         * @param startTime
         *        The start time of the <code>UpdateDirectorySetup</code> for the particular type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The last updated date and time of a particular directory setting.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The last updated date and time of a particular directory setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String status;

        private String statusReason;

        private String initiatedBy;

        private UpdateValue newValue;

        private UpdateValue previousValue;

        private Instant startTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInfoEntry model) {
            region(model.region);
            status(model.status);
            statusReason(model.statusReason);
            initiatedBy(model.initiatedBy);
            newValue(model.newValue);
            previousValue(model.previousValue);
            startTime(model.startTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getInitiatedBy() {
            return initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        public final UpdateValue.Builder getNewValue() {
            return newValue != null ? newValue.toBuilder() : null;
        }

        public final void setNewValue(UpdateValue.BuilderImpl newValue) {
            this.newValue = newValue != null ? newValue.build() : null;
        }

        @Override
        public final Builder newValue(UpdateValue newValue) {
            this.newValue = newValue;
            return this;
        }

        public final UpdateValue.Builder getPreviousValue() {
            return previousValue != null ? previousValue.toBuilder() : null;
        }

        public final void setPreviousValue(UpdateValue.BuilderImpl previousValue) {
            this.previousValue = previousValue != null ? previousValue.build() : null;
        }

        @Override
        public final Builder previousValue(UpdateValue previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public UpdateInfoEntry build() {
            return new UpdateInfoEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
