/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.devicefarm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a condition for a device pool.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rule implements SdkPojo, Serializable, ToCopyableBuilder<Rule.Builder, Rule> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attribute").getter(getter(Rule::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()).build();

    private static final SdkField<String> OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("operator").getter(getter(Rule::operatorAsString)).setter(setter(Builder::operator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(Rule::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            OPERATOR_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final String operator;

    private final String value;

    private Rule(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.operator = builder.operator;
        this.value = builder.value;
    }

    /**
     * <p>
     * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
     * </p>
     * <p>
     * The supported operators for each attribute are provided in the following list.
     * </p>
     * <dl>
     * <dt>APPIUM_VERSION</dt>
     * <dd>
     * <p>
     * The Appium version for the test.
     * </p>
     * <p>
     * Supported operators: <code>CONTAINS</code>
     * </p>
     * </dd>
     * <dt>ARN</dt>
     * <dd>
     * <p>
     * The Amazon Resource Name (ARN) of the device (for example,
     * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>AVAILABILITY</dt>
     * <dd>
     * <p>
     * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
     * TEMPORARY_NOT_AVAILABLE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * </dd>
     * <dt>FLEET_TYPE</dt>
     * <dd>
     * <p>
     * The fleet type. Valid values are PUBLIC or PRIVATE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * </dd>
     * <dt>FORM_FACTOR</dt>
     * <dd>
     * <p>
     * The device form factor. Valid values are PHONE or TABLET.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>INSTANCE_ARN</dt>
     * <dd>
     * <p>
     * The Amazon Resource Name (ARN) of the device instance.
     * </p>
     * <p>
     * Supported operators: <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>INSTANCE_LABELS</dt>
     * <dd>
     * <p>
     * The label of the device instance.
     * </p>
     * <p>
     * Supported operators: <code>CONTAINS</code>
     * </p>
     * </dd>
     * <dt>MANUFACTURER</dt>
     * <dd>
     * <p>
     * The device manufacturer (for example, Apple).
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>MODEL</dt>
     * <dd>
     * <p>
     * The device model, such as Apple iPad Air 2 or Google Pixel.
     * </p>
     * <p>
     * Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>OS_VERSION</dt>
     * <dd>
     * <p>
     * The operating system version (for example, 10.3.2).
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
     * <code>IN</code>, <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>PLATFORM</dt>
     * <dd>
     * <p>
     * The device platform. Valid values are ANDROID or IOS.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>REMOTE_ACCESS_ENABLED</dt>
     * <dd>
     * <p>
     * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * </dd>
     * <dt>REMOTE_DEBUG_ENABLED</dt>
     * <dd>
     * <p>
     * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * <p>
     * Because remote debugging is <a
     * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>, this
     * filter is ignored.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
     *         <p>
     *         The supported operators for each attribute are provided in the following list.
     *         </p>
     *         <dl>
     *         <dt>APPIUM_VERSION</dt>
     *         <dd>
     *         <p>
     *         The Appium version for the test.
     *         </p>
     *         <p>
     *         Supported operators: <code>CONTAINS</code>
     *         </p>
     *         </dd>
     *         <dt>ARN</dt>
     *         <dd>
     *         <p>
     *         The Amazon Resource Name (ARN) of the device (for example,
     *         <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>AVAILABILITY</dt>
     *         <dd>
     *         <p>
     *         The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
     *         TEMPORARY_NOT_AVAILABLE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         </dd>
     *         <dt>FLEET_TYPE</dt>
     *         <dd>
     *         <p>
     *         The fleet type. Valid values are PUBLIC or PRIVATE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         </dd>
     *         <dt>FORM_FACTOR</dt>
     *         <dd>
     *         <p>
     *         The device form factor. Valid values are PHONE or TABLET.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>INSTANCE_ARN</dt>
     *         <dd>
     *         <p>
     *         The Amazon Resource Name (ARN) of the device instance.
     *         </p>
     *         <p>
     *         Supported operators: <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>INSTANCE_LABELS</dt>
     *         <dd>
     *         <p>
     *         The label of the device instance.
     *         </p>
     *         <p>
     *         Supported operators: <code>CONTAINS</code>
     *         </p>
     *         </dd>
     *         <dt>MANUFACTURER</dt>
     *         <dd>
     *         <p>
     *         The device manufacturer (for example, Apple).
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>MODEL</dt>
     *         <dd>
     *         <p>
     *         The device model, such as Apple iPad Air 2 or Google Pixel.
     *         </p>
     *         <p>
     *         Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>OS_VERSION</dt>
     *         <dd>
     *         <p>
     *         The operating system version (for example, 10.3.2).
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
     *         <code>IN</code>, <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>PLATFORM</dt>
     *         <dd>
     *         <p>
     *         The device platform. Valid values are ANDROID or IOS.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>REMOTE_ACCESS_ENABLED</dt>
     *         <dd>
     *         <p>
     *         Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         </dd>
     *         <dt>REMOTE_DEBUG_ENABLED</dt>
     *         <dd>
     *         <p>
     *         Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         <p>
     *         Because remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
     *         this filter is ignored.
     *         </p>
     *         </dd>
     * @see DeviceAttribute
     */
    public final DeviceAttribute attribute() {
        return DeviceAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
     * </p>
     * <p>
     * The supported operators for each attribute are provided in the following list.
     * </p>
     * <dl>
     * <dt>APPIUM_VERSION</dt>
     * <dd>
     * <p>
     * The Appium version for the test.
     * </p>
     * <p>
     * Supported operators: <code>CONTAINS</code>
     * </p>
     * </dd>
     * <dt>ARN</dt>
     * <dd>
     * <p>
     * The Amazon Resource Name (ARN) of the device (for example,
     * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>AVAILABILITY</dt>
     * <dd>
     * <p>
     * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
     * TEMPORARY_NOT_AVAILABLE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * </dd>
     * <dt>FLEET_TYPE</dt>
     * <dd>
     * <p>
     * The fleet type. Valid values are PUBLIC or PRIVATE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * </dd>
     * <dt>FORM_FACTOR</dt>
     * <dd>
     * <p>
     * The device form factor. Valid values are PHONE or TABLET.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>INSTANCE_ARN</dt>
     * <dd>
     * <p>
     * The Amazon Resource Name (ARN) of the device instance.
     * </p>
     * <p>
     * Supported operators: <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>INSTANCE_LABELS</dt>
     * <dd>
     * <p>
     * The label of the device instance.
     * </p>
     * <p>
     * Supported operators: <code>CONTAINS</code>
     * </p>
     * </dd>
     * <dt>MANUFACTURER</dt>
     * <dd>
     * <p>
     * The device manufacturer (for example, Apple).
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>MODEL</dt>
     * <dd>
     * <p>
     * The device model, such as Apple iPad Air 2 or Google Pixel.
     * </p>
     * <p>
     * Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>OS_VERSION</dt>
     * <dd>
     * <p>
     * The operating system version (for example, 10.3.2).
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
     * <code>IN</code>, <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>PLATFORM</dt>
     * <dd>
     * <p>
     * The device platform. Valid values are ANDROID or IOS.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     * </p>
     * </dd>
     * <dt>REMOTE_ACCESS_ENABLED</dt>
     * <dd>
     * <p>
     * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * </dd>
     * <dt>REMOTE_DEBUG_ENABLED</dt>
     * <dd>
     * <p>
     * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     * </p>
     * <p>
     * Supported operators: <code>EQUALS</code>
     * </p>
     * <p>
     * Because remote debugging is <a
     * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>, this
     * filter is ignored.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link DeviceAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #attributeAsString}.
     * </p>
     * 
     * @return The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
     *         <p>
     *         The supported operators for each attribute are provided in the following list.
     *         </p>
     *         <dl>
     *         <dt>APPIUM_VERSION</dt>
     *         <dd>
     *         <p>
     *         The Appium version for the test.
     *         </p>
     *         <p>
     *         Supported operators: <code>CONTAINS</code>
     *         </p>
     *         </dd>
     *         <dt>ARN</dt>
     *         <dd>
     *         <p>
     *         The Amazon Resource Name (ARN) of the device (for example,
     *         <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>AVAILABILITY</dt>
     *         <dd>
     *         <p>
     *         The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
     *         TEMPORARY_NOT_AVAILABLE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         </dd>
     *         <dt>FLEET_TYPE</dt>
     *         <dd>
     *         <p>
     *         The fleet type. Valid values are PUBLIC or PRIVATE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         </dd>
     *         <dt>FORM_FACTOR</dt>
     *         <dd>
     *         <p>
     *         The device form factor. Valid values are PHONE or TABLET.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>INSTANCE_ARN</dt>
     *         <dd>
     *         <p>
     *         The Amazon Resource Name (ARN) of the device instance.
     *         </p>
     *         <p>
     *         Supported operators: <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>INSTANCE_LABELS</dt>
     *         <dd>
     *         <p>
     *         The label of the device instance.
     *         </p>
     *         <p>
     *         Supported operators: <code>CONTAINS</code>
     *         </p>
     *         </dd>
     *         <dt>MANUFACTURER</dt>
     *         <dd>
     *         <p>
     *         The device manufacturer (for example, Apple).
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>MODEL</dt>
     *         <dd>
     *         <p>
     *         The device model, such as Apple iPad Air 2 or Google Pixel.
     *         </p>
     *         <p>
     *         Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>OS_VERSION</dt>
     *         <dd>
     *         <p>
     *         The operating system version (for example, 10.3.2).
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
     *         <code>IN</code>, <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>PLATFORM</dt>
     *         <dd>
     *         <p>
     *         The device platform. Valid values are ANDROID or IOS.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
     *         </p>
     *         </dd>
     *         <dt>REMOTE_ACCESS_ENABLED</dt>
     *         <dd>
     *         <p>
     *         Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         </dd>
     *         <dt>REMOTE_DEBUG_ENABLED</dt>
     *         <dd>
     *         <p>
     *         Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
     *         </p>
     *         <p>
     *         Supported operators: <code>EQUALS</code>
     *         </p>
     *         <p>
     *         Because remote debugging is <a
     *         href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
     *         this filter is ignored.
     *         </p>
     *         </dd>
     * @see DeviceAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * Specifies how Device Farm compares the rule's attribute to the value. For the operators that are supported by
     * each attribute, see the attribute descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return Specifies how Device Farm compares the rule's attribute to the value. For the operators that are
     *         supported by each attribute, see the attribute descriptions.
     * @see RuleOperator
     */
    public final RuleOperator operator() {
        return RuleOperator.fromValue(operator);
    }

    /**
     * <p>
     * Specifies how Device Farm compares the rule's attribute to the value. For the operators that are supported by
     * each attribute, see the attribute descriptions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operator} will
     * return {@link RuleOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operatorAsString}.
     * </p>
     * 
     * @return Specifies how Device Farm compares the rule's attribute to the value. For the operators that are
     *         supported by each attribute, see the attribute descriptions.
     * @see RuleOperator
     */
    public final String operatorAsString() {
        return operator;
    }

    /**
     * <p>
     * The rule's value.
     * </p>
     * 
     * @return The rule's value.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString())
                && Objects.equals(operatorAsString(), other.operatorAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rule").add("Attribute", attributeAsString()).add("Operator", operatorAsString())
                .add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "operator":
            return Optional.ofNullable(clazz.cast(operatorAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rule, T> g) {
        return obj -> g.apply((Rule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rule> {
        /**
         * <p>
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
         * </p>
         * <p>
         * The supported operators for each attribute are provided in the following list.
         * </p>
         * <dl>
         * <dt>APPIUM_VERSION</dt>
         * <dd>
         * <p>
         * The Appium version for the test.
         * </p>
         * <p>
         * Supported operators: <code>CONTAINS</code>
         * </p>
         * </dd>
         * <dt>ARN</dt>
         * <dd>
         * <p>
         * The Amazon Resource Name (ARN) of the device (for example,
         * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>AVAILABILITY</dt>
         * <dd>
         * <p>
         * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * </dd>
         * <dt>FLEET_TYPE</dt>
         * <dd>
         * <p>
         * The fleet type. Valid values are PUBLIC or PRIVATE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * </dd>
         * <dt>FORM_FACTOR</dt>
         * <dd>
         * <p>
         * The device form factor. Valid values are PHONE or TABLET.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>INSTANCE_ARN</dt>
         * <dd>
         * <p>
         * The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * <p>
         * Supported operators: <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>INSTANCE_LABELS</dt>
         * <dd>
         * <p>
         * The label of the device instance.
         * </p>
         * <p>
         * Supported operators: <code>CONTAINS</code>
         * </p>
         * </dd>
         * <dt>MANUFACTURER</dt>
         * <dd>
         * <p>
         * The device manufacturer (for example, Apple).
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>MODEL</dt>
         * <dd>
         * <p>
         * The device model, such as Apple iPad Air 2 or Google Pixel.
         * </p>
         * <p>
         * Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>OS_VERSION</dt>
         * <dd>
         * <p>
         * The operating system version (for example, 10.3.2).
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
         * <code>IN</code>, <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>PLATFORM</dt>
         * <dd>
         * <p>
         * The device platform. Valid values are ANDROID or IOS.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>REMOTE_ACCESS_ENABLED</dt>
         * <dd>
         * <p>
         * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * </dd>
         * <dt>REMOTE_DEBUG_ENABLED</dt>
         * <dd>
         * <p>
         * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * <p>
         * Because remote debugging is <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
         * this filter is ignored.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param attribute
         *        The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
         *        <p>
         *        The supported operators for each attribute are provided in the following list.
         *        </p>
         *        <dl>
         *        <dt>APPIUM_VERSION</dt>
         *        <dd>
         *        <p>
         *        The Appium version for the test.
         *        </p>
         *        <p>
         *        Supported operators: <code>CONTAINS</code>
         *        </p>
         *        </dd>
         *        <dt>ARN</dt>
         *        <dd>
         *        <p>
         *        The Amazon Resource Name (ARN) of the device (for example,
         *        <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>AVAILABILITY</dt>
         *        <dd>
         *        <p>
         *        The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         *        TEMPORARY_NOT_AVAILABLE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        </dd>
         *        <dt>FLEET_TYPE</dt>
         *        <dd>
         *        <p>
         *        The fleet type. Valid values are PUBLIC or PRIVATE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        </dd>
         *        <dt>FORM_FACTOR</dt>
         *        <dd>
         *        <p>
         *        The device form factor. Valid values are PHONE or TABLET.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>INSTANCE_ARN</dt>
         *        <dd>
         *        <p>
         *        The Amazon Resource Name (ARN) of the device instance.
         *        </p>
         *        <p>
         *        Supported operators: <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>INSTANCE_LABELS</dt>
         *        <dd>
         *        <p>
         *        The label of the device instance.
         *        </p>
         *        <p>
         *        Supported operators: <code>CONTAINS</code>
         *        </p>
         *        </dd>
         *        <dt>MANUFACTURER</dt>
         *        <dd>
         *        <p>
         *        The device manufacturer (for example, Apple).
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>MODEL</dt>
         *        <dd>
         *        <p>
         *        The device model, such as Apple iPad Air 2 or Google Pixel.
         *        </p>
         *        <p>
         *        Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>OS_VERSION</dt>
         *        <dd>
         *        <p>
         *        The operating system version (for example, 10.3.2).
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>,
         *        <code>GREATER_THAN_OR_EQUALS</code>, <code>IN</code>, <code>LESS_THAN</code>,
         *        <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>PLATFORM</dt>
         *        <dd>
         *        <p>
         *        The device platform. Valid values are ANDROID or IOS.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>REMOTE_ACCESS_ENABLED</dt>
         *        <dd>
         *        <p>
         *        Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        </dd>
         *        <dt>REMOTE_DEBUG_ENABLED</dt>
         *        <dd>
         *        <p>
         *        Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        <p>
         *        Because remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>, this filter is ignored.
         *        </p>
         *        </dd>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.
         * </p>
         * <p>
         * The supported operators for each attribute are provided in the following list.
         * </p>
         * <dl>
         * <dt>APPIUM_VERSION</dt>
         * <dd>
         * <p>
         * The Appium version for the test.
         * </p>
         * <p>
         * Supported operators: <code>CONTAINS</code>
         * </p>
         * </dd>
         * <dt>ARN</dt>
         * <dd>
         * <p>
         * The Amazon Resource Name (ARN) of the device (for example,
         * <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>AVAILABILITY</dt>
         * <dd>
         * <p>
         * The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         * TEMPORARY_NOT_AVAILABLE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * </dd>
         * <dt>FLEET_TYPE</dt>
         * <dd>
         * <p>
         * The fleet type. Valid values are PUBLIC or PRIVATE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * </dd>
         * <dt>FORM_FACTOR</dt>
         * <dd>
         * <p>
         * The device form factor. Valid values are PHONE or TABLET.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>INSTANCE_ARN</dt>
         * <dd>
         * <p>
         * The Amazon Resource Name (ARN) of the device instance.
         * </p>
         * <p>
         * Supported operators: <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>INSTANCE_LABELS</dt>
         * <dd>
         * <p>
         * The label of the device instance.
         * </p>
         * <p>
         * Supported operators: <code>CONTAINS</code>
         * </p>
         * </dd>
         * <dt>MANUFACTURER</dt>
         * <dd>
         * <p>
         * The device manufacturer (for example, Apple).
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>MODEL</dt>
         * <dd>
         * <p>
         * The device model, such as Apple iPad Air 2 or Google Pixel.
         * </p>
         * <p>
         * Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>OS_VERSION</dt>
         * <dd>
         * <p>
         * The operating system version (for example, 10.3.2).
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>, <code>GREATER_THAN_OR_EQUALS</code>,
         * <code>IN</code>, <code>LESS_THAN</code>, <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>PLATFORM</dt>
         * <dd>
         * <p>
         * The device platform. Valid values are ANDROID or IOS.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         * </p>
         * </dd>
         * <dt>REMOTE_ACCESS_ENABLED</dt>
         * <dd>
         * <p>
         * Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * </dd>
         * <dt>REMOTE_DEBUG_ENABLED</dt>
         * <dd>
         * <p>
         * Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         * </p>
         * <p>
         * Supported operators: <code>EQUALS</code>
         * </p>
         * <p>
         * Because remote debugging is <a
         * href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer supported</a>,
         * this filter is ignored.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param attribute
         *        The rule's stringified attribute. For example, specify the value as <code>"\"abc\""</code>.</p>
         *        <p>
         *        The supported operators for each attribute are provided in the following list.
         *        </p>
         *        <dl>
         *        <dt>APPIUM_VERSION</dt>
         *        <dd>
         *        <p>
         *        The Appium version for the test.
         *        </p>
         *        <p>
         *        Supported operators: <code>CONTAINS</code>
         *        </p>
         *        </dd>
         *        <dt>ARN</dt>
         *        <dd>
         *        <p>
         *        The Amazon Resource Name (ARN) of the device (for example,
         *        <code>arn:aws:devicefarm:us-west-2::device:12345Example</code>.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>AVAILABILITY</dt>
         *        <dd>
         *        <p>
         *        The current availability of the device. Valid values are AVAILABLE, HIGHLY_AVAILABLE, BUSY, or
         *        TEMPORARY_NOT_AVAILABLE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        </dd>
         *        <dt>FLEET_TYPE</dt>
         *        <dd>
         *        <p>
         *        The fleet type. Valid values are PUBLIC or PRIVATE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        </dd>
         *        <dt>FORM_FACTOR</dt>
         *        <dd>
         *        <p>
         *        The device form factor. Valid values are PHONE or TABLET.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>INSTANCE_ARN</dt>
         *        <dd>
         *        <p>
         *        The Amazon Resource Name (ARN) of the device instance.
         *        </p>
         *        <p>
         *        Supported operators: <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>INSTANCE_LABELS</dt>
         *        <dd>
         *        <p>
         *        The label of the device instance.
         *        </p>
         *        <p>
         *        Supported operators: <code>CONTAINS</code>
         *        </p>
         *        </dd>
         *        <dt>MANUFACTURER</dt>
         *        <dd>
         *        <p>
         *        The device manufacturer (for example, Apple).
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>MODEL</dt>
         *        <dd>
         *        <p>
         *        The device model, such as Apple iPad Air 2 or Google Pixel.
         *        </p>
         *        <p>
         *        Supported operators: <code>CONTAINS</code>, <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>OS_VERSION</dt>
         *        <dd>
         *        <p>
         *        The operating system version (for example, 10.3.2).
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>GREATER_THAN</code>,
         *        <code>GREATER_THAN_OR_EQUALS</code>, <code>IN</code>, <code>LESS_THAN</code>,
         *        <code>LESS_THAN_OR_EQUALS</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>PLATFORM</dt>
         *        <dd>
         *        <p>
         *        The device platform. Valid values are ANDROID or IOS.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>, <code>IN</code>, <code>NOT_IN</code>
         *        </p>
         *        </dd>
         *        <dt>REMOTE_ACCESS_ENABLED</dt>
         *        <dd>
         *        <p>
         *        Whether the device is enabled for remote access. Valid values are TRUE or FALSE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        </dd>
         *        <dt>REMOTE_DEBUG_ENABLED</dt>
         *        <dd>
         *        <p>
         *        Whether the device is enabled for remote debugging. Valid values are TRUE or FALSE.
         *        </p>
         *        <p>
         *        Supported operators: <code>EQUALS</code>
         *        </p>
         *        <p>
         *        Because remote debugging is <a
         *        href="https://docs.aws.amazon.com/devicefarm/latest/developerguide/history.html">no longer
         *        supported</a>, this filter is ignored.
         *        </p>
         *        </dd>
         * @see DeviceAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceAttribute
         */
        Builder attribute(DeviceAttribute attribute);

        /**
         * <p>
         * Specifies how Device Farm compares the rule's attribute to the value. For the operators that are supported by
         * each attribute, see the attribute descriptions.
         * </p>
         * 
         * @param operator
         *        Specifies how Device Farm compares the rule's attribute to the value. For the operators that are
         *        supported by each attribute, see the attribute descriptions.
         * @see RuleOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOperator
         */
        Builder operator(String operator);

        /**
         * <p>
         * Specifies how Device Farm compares the rule's attribute to the value. For the operators that are supported by
         * each attribute, see the attribute descriptions.
         * </p>
         * 
         * @param operator
         *        Specifies how Device Farm compares the rule's attribute to the value. For the operators that are
         *        supported by each attribute, see the attribute descriptions.
         * @see RuleOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleOperator
         */
        Builder operator(RuleOperator operator);

        /**
         * <p>
         * The rule's value.
         * </p>
         * 
         * @param value
         *        The rule's value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private String operator;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            attribute(model.attribute);
            operator(model.operator);
            value(model.value);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(DeviceAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getOperator() {
            return operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(RuleOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public Rule build() {
            return new Rule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
