/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.datasync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The performance data that DataSync Discovery collects about an on-premises storage system resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaxP95Performance implements SdkPojo, Serializable,
        ToCopyableBuilder<MaxP95Performance.Builder, MaxP95Performance> {
    private static final SdkField<Double> IOPS_READ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("IopsRead").getter(getter(MaxP95Performance::iopsRead)).setter(setter(Builder::iopsRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsRead").build()).build();

    private static final SdkField<Double> IOPS_WRITE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("IopsWrite").getter(getter(MaxP95Performance::iopsWrite)).setter(setter(Builder::iopsWrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsWrite").build()).build();

    private static final SdkField<Double> IOPS_OTHER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("IopsOther").getter(getter(MaxP95Performance::iopsOther)).setter(setter(Builder::iopsOther))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsOther").build()).build();

    private static final SdkField<Double> IOPS_TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("IopsTotal").getter(getter(MaxP95Performance::iopsTotal)).setter(setter(Builder::iopsTotal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IopsTotal").build()).build();

    private static final SdkField<Double> THROUGHPUT_READ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThroughputRead").getter(getter(MaxP95Performance::throughputRead))
            .setter(setter(Builder::throughputRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputRead").build()).build();

    private static final SdkField<Double> THROUGHPUT_WRITE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThroughputWrite").getter(getter(MaxP95Performance::throughputWrite))
            .setter(setter(Builder::throughputWrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputWrite").build()).build();

    private static final SdkField<Double> THROUGHPUT_OTHER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThroughputOther").getter(getter(MaxP95Performance::throughputOther))
            .setter(setter(Builder::throughputOther))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputOther").build()).build();

    private static final SdkField<Double> THROUGHPUT_TOTAL_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ThroughputTotal").getter(getter(MaxP95Performance::throughputTotal))
            .setter(setter(Builder::throughputTotal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputTotal").build()).build();

    private static final SdkField<Double> LATENCY_READ_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LatencyRead").getter(getter(MaxP95Performance::latencyRead)).setter(setter(Builder::latencyRead))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatencyRead").build()).build();

    private static final SdkField<Double> LATENCY_WRITE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LatencyWrite").getter(getter(MaxP95Performance::latencyWrite)).setter(setter(Builder::latencyWrite))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatencyWrite").build()).build();

    private static final SdkField<Double> LATENCY_OTHER_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("LatencyOther").getter(getter(MaxP95Performance::latencyOther)).setter(setter(Builder::latencyOther))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatencyOther").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_READ_FIELD,
            IOPS_WRITE_FIELD, IOPS_OTHER_FIELD, IOPS_TOTAL_FIELD, THROUGHPUT_READ_FIELD, THROUGHPUT_WRITE_FIELD,
            THROUGHPUT_OTHER_FIELD, THROUGHPUT_TOTAL_FIELD, LATENCY_READ_FIELD, LATENCY_WRITE_FIELD, LATENCY_OTHER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Double iopsRead;

    private final Double iopsWrite;

    private final Double iopsOther;

    private final Double iopsTotal;

    private final Double throughputRead;

    private final Double throughputWrite;

    private final Double throughputOther;

    private final Double throughputTotal;

    private final Double latencyRead;

    private final Double latencyWrite;

    private final Double latencyOther;

    private MaxP95Performance(BuilderImpl builder) {
        this.iopsRead = builder.iopsRead;
        this.iopsWrite = builder.iopsWrite;
        this.iopsOther = builder.iopsOther;
        this.iopsTotal = builder.iopsTotal;
        this.throughputRead = builder.throughputRead;
        this.throughputWrite = builder.throughputWrite;
        this.throughputOther = builder.throughputOther;
        this.throughputTotal = builder.throughputTotal;
        this.latencyRead = builder.latencyRead;
        this.latencyWrite = builder.latencyWrite;
        this.latencyOther = builder.latencyOther;
    }

    /**
     * <p>
     * Peak IOPS related to read operations.
     * </p>
     * 
     * @return Peak IOPS related to read operations.
     */
    public final Double iopsRead() {
        return iopsRead;
    }

    /**
     * <p>
     * Peak IOPS related to write operations.
     * </p>
     * 
     * @return Peak IOPS related to write operations.
     */
    public final Double iopsWrite() {
        return iopsWrite;
    }

    /**
     * <p>
     * Peak IOPS unrelated to read and write operations.
     * </p>
     * 
     * @return Peak IOPS unrelated to read and write operations.
     */
    public final Double iopsOther() {
        return iopsOther;
    }

    /**
     * <p>
     * Peak total IOPS on your on-premises storage system resource.
     * </p>
     * 
     * @return Peak total IOPS on your on-premises storage system resource.
     */
    public final Double iopsTotal() {
        return iopsTotal;
    }

    /**
     * <p>
     * Peak throughput related to read operations.
     * </p>
     * 
     * @return Peak throughput related to read operations.
     */
    public final Double throughputRead() {
        return throughputRead;
    }

    /**
     * <p>
     * Peak throughput related to write operations.
     * </p>
     * 
     * @return Peak throughput related to write operations.
     */
    public final Double throughputWrite() {
        return throughputWrite;
    }

    /**
     * <p>
     * Peak throughput unrelated to read and write operations.
     * </p>
     * 
     * @return Peak throughput unrelated to read and write operations.
     */
    public final Double throughputOther() {
        return throughputOther;
    }

    /**
     * <p>
     * Peak total throughput on your on-premises storage system resource.
     * </p>
     * 
     * @return Peak total throughput on your on-premises storage system resource.
     */
    public final Double throughputTotal() {
        return throughputTotal;
    }

    /**
     * <p>
     * Peak latency for read operations.
     * </p>
     * 
     * @return Peak latency for read operations.
     */
    public final Double latencyRead() {
        return latencyRead;
    }

    /**
     * <p>
     * Peak latency for write operations.
     * </p>
     * 
     * @return Peak latency for write operations.
     */
    public final Double latencyWrite() {
        return latencyWrite;
    }

    /**
     * <p>
     * Peak latency for operations unrelated to read and write operations.
     * </p>
     * 
     * @return Peak latency for operations unrelated to read and write operations.
     */
    public final Double latencyOther() {
        return latencyOther;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iopsRead());
        hashCode = 31 * hashCode + Objects.hashCode(iopsWrite());
        hashCode = 31 * hashCode + Objects.hashCode(iopsOther());
        hashCode = 31 * hashCode + Objects.hashCode(iopsTotal());
        hashCode = 31 * hashCode + Objects.hashCode(throughputRead());
        hashCode = 31 * hashCode + Objects.hashCode(throughputWrite());
        hashCode = 31 * hashCode + Objects.hashCode(throughputOther());
        hashCode = 31 * hashCode + Objects.hashCode(throughputTotal());
        hashCode = 31 * hashCode + Objects.hashCode(latencyRead());
        hashCode = 31 * hashCode + Objects.hashCode(latencyWrite());
        hashCode = 31 * hashCode + Objects.hashCode(latencyOther());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaxP95Performance)) {
            return false;
        }
        MaxP95Performance other = (MaxP95Performance) obj;
        return Objects.equals(iopsRead(), other.iopsRead()) && Objects.equals(iopsWrite(), other.iopsWrite())
                && Objects.equals(iopsOther(), other.iopsOther()) && Objects.equals(iopsTotal(), other.iopsTotal())
                && Objects.equals(throughputRead(), other.throughputRead())
                && Objects.equals(throughputWrite(), other.throughputWrite())
                && Objects.equals(throughputOther(), other.throughputOther())
                && Objects.equals(throughputTotal(), other.throughputTotal())
                && Objects.equals(latencyRead(), other.latencyRead()) && Objects.equals(latencyWrite(), other.latencyWrite())
                && Objects.equals(latencyOther(), other.latencyOther());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaxP95Performance").add("IopsRead", iopsRead()).add("IopsWrite", iopsWrite())
                .add("IopsOther", iopsOther()).add("IopsTotal", iopsTotal()).add("ThroughputRead", throughputRead())
                .add("ThroughputWrite", throughputWrite()).add("ThroughputOther", throughputOther())
                .add("ThroughputTotal", throughputTotal()).add("LatencyRead", latencyRead()).add("LatencyWrite", latencyWrite())
                .add("LatencyOther", latencyOther()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IopsRead":
            return Optional.ofNullable(clazz.cast(iopsRead()));
        case "IopsWrite":
            return Optional.ofNullable(clazz.cast(iopsWrite()));
        case "IopsOther":
            return Optional.ofNullable(clazz.cast(iopsOther()));
        case "IopsTotal":
            return Optional.ofNullable(clazz.cast(iopsTotal()));
        case "ThroughputRead":
            return Optional.ofNullable(clazz.cast(throughputRead()));
        case "ThroughputWrite":
            return Optional.ofNullable(clazz.cast(throughputWrite()));
        case "ThroughputOther":
            return Optional.ofNullable(clazz.cast(throughputOther()));
        case "ThroughputTotal":
            return Optional.ofNullable(clazz.cast(throughputTotal()));
        case "LatencyRead":
            return Optional.ofNullable(clazz.cast(latencyRead()));
        case "LatencyWrite":
            return Optional.ofNullable(clazz.cast(latencyWrite()));
        case "LatencyOther":
            return Optional.ofNullable(clazz.cast(latencyOther()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaxP95Performance, T> g) {
        return obj -> g.apply((MaxP95Performance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaxP95Performance> {
        /**
         * <p>
         * Peak IOPS related to read operations.
         * </p>
         * 
         * @param iopsRead
         *        Peak IOPS related to read operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsRead(Double iopsRead);

        /**
         * <p>
         * Peak IOPS related to write operations.
         * </p>
         * 
         * @param iopsWrite
         *        Peak IOPS related to write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsWrite(Double iopsWrite);

        /**
         * <p>
         * Peak IOPS unrelated to read and write operations.
         * </p>
         * 
         * @param iopsOther
         *        Peak IOPS unrelated to read and write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsOther(Double iopsOther);

        /**
         * <p>
         * Peak total IOPS on your on-premises storage system resource.
         * </p>
         * 
         * @param iopsTotal
         *        Peak total IOPS on your on-premises storage system resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iopsTotal(Double iopsTotal);

        /**
         * <p>
         * Peak throughput related to read operations.
         * </p>
         * 
         * @param throughputRead
         *        Peak throughput related to read operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputRead(Double throughputRead);

        /**
         * <p>
         * Peak throughput related to write operations.
         * </p>
         * 
         * @param throughputWrite
         *        Peak throughput related to write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputWrite(Double throughputWrite);

        /**
         * <p>
         * Peak throughput unrelated to read and write operations.
         * </p>
         * 
         * @param throughputOther
         *        Peak throughput unrelated to read and write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputOther(Double throughputOther);

        /**
         * <p>
         * Peak total throughput on your on-premises storage system resource.
         * </p>
         * 
         * @param throughputTotal
         *        Peak total throughput on your on-premises storage system resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputTotal(Double throughputTotal);

        /**
         * <p>
         * Peak latency for read operations.
         * </p>
         * 
         * @param latencyRead
         *        Peak latency for read operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latencyRead(Double latencyRead);

        /**
         * <p>
         * Peak latency for write operations.
         * </p>
         * 
         * @param latencyWrite
         *        Peak latency for write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latencyWrite(Double latencyWrite);

        /**
         * <p>
         * Peak latency for operations unrelated to read and write operations.
         * </p>
         * 
         * @param latencyOther
         *        Peak latency for operations unrelated to read and write operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latencyOther(Double latencyOther);
    }

    static final class BuilderImpl implements Builder {
        private Double iopsRead;

        private Double iopsWrite;

        private Double iopsOther;

        private Double iopsTotal;

        private Double throughputRead;

        private Double throughputWrite;

        private Double throughputOther;

        private Double throughputTotal;

        private Double latencyRead;

        private Double latencyWrite;

        private Double latencyOther;

        private BuilderImpl() {
        }

        private BuilderImpl(MaxP95Performance model) {
            iopsRead(model.iopsRead);
            iopsWrite(model.iopsWrite);
            iopsOther(model.iopsOther);
            iopsTotal(model.iopsTotal);
            throughputRead(model.throughputRead);
            throughputWrite(model.throughputWrite);
            throughputOther(model.throughputOther);
            throughputTotal(model.throughputTotal);
            latencyRead(model.latencyRead);
            latencyWrite(model.latencyWrite);
            latencyOther(model.latencyOther);
        }

        public final Double getIopsRead() {
            return iopsRead;
        }

        public final void setIopsRead(Double iopsRead) {
            this.iopsRead = iopsRead;
        }

        @Override
        public final Builder iopsRead(Double iopsRead) {
            this.iopsRead = iopsRead;
            return this;
        }

        public final Double getIopsWrite() {
            return iopsWrite;
        }

        public final void setIopsWrite(Double iopsWrite) {
            this.iopsWrite = iopsWrite;
        }

        @Override
        public final Builder iopsWrite(Double iopsWrite) {
            this.iopsWrite = iopsWrite;
            return this;
        }

        public final Double getIopsOther() {
            return iopsOther;
        }

        public final void setIopsOther(Double iopsOther) {
            this.iopsOther = iopsOther;
        }

        @Override
        public final Builder iopsOther(Double iopsOther) {
            this.iopsOther = iopsOther;
            return this;
        }

        public final Double getIopsTotal() {
            return iopsTotal;
        }

        public final void setIopsTotal(Double iopsTotal) {
            this.iopsTotal = iopsTotal;
        }

        @Override
        public final Builder iopsTotal(Double iopsTotal) {
            this.iopsTotal = iopsTotal;
            return this;
        }

        public final Double getThroughputRead() {
            return throughputRead;
        }

        public final void setThroughputRead(Double throughputRead) {
            this.throughputRead = throughputRead;
        }

        @Override
        public final Builder throughputRead(Double throughputRead) {
            this.throughputRead = throughputRead;
            return this;
        }

        public final Double getThroughputWrite() {
            return throughputWrite;
        }

        public final void setThroughputWrite(Double throughputWrite) {
            this.throughputWrite = throughputWrite;
        }

        @Override
        public final Builder throughputWrite(Double throughputWrite) {
            this.throughputWrite = throughputWrite;
            return this;
        }

        public final Double getThroughputOther() {
            return throughputOther;
        }

        public final void setThroughputOther(Double throughputOther) {
            this.throughputOther = throughputOther;
        }

        @Override
        public final Builder throughputOther(Double throughputOther) {
            this.throughputOther = throughputOther;
            return this;
        }

        public final Double getThroughputTotal() {
            return throughputTotal;
        }

        public final void setThroughputTotal(Double throughputTotal) {
            this.throughputTotal = throughputTotal;
        }

        @Override
        public final Builder throughputTotal(Double throughputTotal) {
            this.throughputTotal = throughputTotal;
            return this;
        }

        public final Double getLatencyRead() {
            return latencyRead;
        }

        public final void setLatencyRead(Double latencyRead) {
            this.latencyRead = latencyRead;
        }

        @Override
        public final Builder latencyRead(Double latencyRead) {
            this.latencyRead = latencyRead;
            return this;
        }

        public final Double getLatencyWrite() {
            return latencyWrite;
        }

        public final void setLatencyWrite(Double latencyWrite) {
            this.latencyWrite = latencyWrite;
        }

        @Override
        public final Builder latencyWrite(Double latencyWrite) {
            this.latencyWrite = latencyWrite;
            return this;
        }

        public final Double getLatencyOther() {
            return latencyOther;
        }

        public final void setLatencyOther(Double latencyOther) {
            this.latencyOther = latencyOther;
        }

        @Override
        public final Builder latencyOther(Double latencyOther) {
            this.latencyOther = latencyOther;
            return this;
        }

        @Override
        public MaxP95Performance build() {
            return new MaxP95Performance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
