/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a replication instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReplicationInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<ReplicationInstance.Builder, ReplicationInstance> {
    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceIdentifier")
            .getter(getter(ReplicationInstance::replicationInstanceIdentifier))
            .setter(setter(Builder::replicationInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier")
                    .build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceClass").getter(getter(ReplicationInstance::replicationInstanceClass))
            .setter(setter(Builder::replicationInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceStatus").getter(getter(ReplicationInstance::replicationInstanceStatus))
            .setter(setter(Builder::replicationInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceStatus").build())
            .build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(ReplicationInstance::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Instant> INSTANCE_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InstanceCreateTime").getter(getter(ReplicationInstance::instanceCreateTime))
            .setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<VpcSecurityGroupMembership>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(ReplicationInstance::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcSecurityGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcSecurityGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(ReplicationInstance::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<ReplicationSubnetGroup> REPLICATION_SUBNET_GROUP_FIELD = SdkField
            .<ReplicationSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("ReplicationSubnetGroup")
            .getter(getter(ReplicationInstance::replicationSubnetGroup)).setter(setter(Builder::replicationSubnetGroup))
            .constructor(ReplicationSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroup").build())
            .build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(ReplicationInstance::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<ReplicationPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<ReplicationPendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(ReplicationInstance::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(ReplicationPendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(ReplicationInstance::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(ReplicationInstance::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(ReplicationInstance::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(ReplicationInstance::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceArn").getter(getter(ReplicationInstance::replicationInstanceArn))
            .setter(setter(Builder::replicationInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceArn").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstancePublicIpAddress")
            .getter(getter(ReplicationInstance::replicationInstancePublicIpAddress))
            .setter(setter(Builder::replicationInstancePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstancePublicIpAddress")
                    .build()).build();

    private static final SdkField<String> REPLICATION_INSTANCE_PRIVATE_IP_ADDRESS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstancePrivateIpAddress")
            .getter(getter(ReplicationInstance::replicationInstancePrivateIpAddress))
            .setter(setter(Builder::replicationInstancePrivateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationInstancePrivateIpAddress").build()).build();

    private static final SdkField<List<String>> REPLICATION_INSTANCE_PUBLIC_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationInstancePublicIpAddresses")
            .getter(getter(ReplicationInstance::replicationInstancePublicIpAddresses))
            .setter(setter(Builder::replicationInstancePublicIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationInstancePublicIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPLICATION_INSTANCE_PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationInstancePrivateIpAddresses")
            .getter(getter(ReplicationInstance::replicationInstancePrivateIpAddresses))
            .setter(setter(Builder::replicationInstancePrivateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReplicationInstancePrivateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REPLICATION_INSTANCE_IPV6_ADDRESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReplicationInstanceIpv6Addresses")
            .getter(getter(ReplicationInstance::replicationInstanceIpv6Addresses))
            .setter(setter(Builder::replicationInstanceIpv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIpv6Addresses")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(ReplicationInstance::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondaryAvailabilityZone").getter(getter(ReplicationInstance::secondaryAvailabilityZone))
            .setter(setter(Builder::secondaryAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAvailabilityZone").build())
            .build();

    private static final SdkField<Instant> FREE_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("FreeUntil").getter(getter(ReplicationInstance::freeUntil)).setter(setter(Builder::freeUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FreeUntil").build()).build();

    private static final SdkField<String> DNS_NAME_SERVERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsNameServers").getter(getter(ReplicationInstance::dnsNameServers))
            .setter(setter(Builder::dnsNameServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsNameServers").build()).build();

    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkType").getter(getter(ReplicationInstance::networkType)).setter(setter(Builder::networkType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            REPLICATION_INSTANCE_IDENTIFIER_FIELD, REPLICATION_INSTANCE_CLASS_FIELD, REPLICATION_INSTANCE_STATUS_FIELD,
            ALLOCATED_STORAGE_FIELD, INSTANCE_CREATE_TIME_FIELD, VPC_SECURITY_GROUPS_FIELD, AVAILABILITY_ZONE_FIELD,
            REPLICATION_SUBNET_GROUP_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, MULTI_AZ_FIELD,
            ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, KMS_KEY_ID_FIELD, REPLICATION_INSTANCE_ARN_FIELD,
            REPLICATION_INSTANCE_PUBLIC_IP_ADDRESS_FIELD, REPLICATION_INSTANCE_PRIVATE_IP_ADDRESS_FIELD,
            REPLICATION_INSTANCE_PUBLIC_IP_ADDRESSES_FIELD, REPLICATION_INSTANCE_PRIVATE_IP_ADDRESSES_FIELD,
            REPLICATION_INSTANCE_IPV6_ADDRESSES_FIELD, PUBLICLY_ACCESSIBLE_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD,
            FREE_UNTIL_FIELD, DNS_NAME_SERVERS_FIELD, NETWORK_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String replicationInstanceIdentifier;

    private final String replicationInstanceClass;

    private final String replicationInstanceStatus;

    private final Integer allocatedStorage;

    private final Instant instanceCreateTime;

    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;

    private final String availabilityZone;

    private final ReplicationSubnetGroup replicationSubnetGroup;

    private final String preferredMaintenanceWindow;

    private final ReplicationPendingModifiedValues pendingModifiedValues;

    private final Boolean multiAZ;

    private final String engineVersion;

    private final Boolean autoMinorVersionUpgrade;

    private final String kmsKeyId;

    private final String replicationInstanceArn;

    private final String replicationInstancePublicIpAddress;

    private final String replicationInstancePrivateIpAddress;

    private final List<String> replicationInstancePublicIpAddresses;

    private final List<String> replicationInstancePrivateIpAddresses;

    private final List<String> replicationInstanceIpv6Addresses;

    private final Boolean publiclyAccessible;

    private final String secondaryAvailabilityZone;

    private final Instant freeUntil;

    private final String dnsNameServers;

    private final String networkType;

    private ReplicationInstance(BuilderImpl builder) {
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.replicationInstanceStatus = builder.replicationInstanceStatus;
        this.allocatedStorage = builder.allocatedStorage;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.availabilityZone = builder.availabilityZone;
        this.replicationSubnetGroup = builder.replicationSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.kmsKeyId = builder.kmsKeyId;
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.replicationInstancePublicIpAddress = builder.replicationInstancePublicIpAddress;
        this.replicationInstancePrivateIpAddress = builder.replicationInstancePrivateIpAddress;
        this.replicationInstancePublicIpAddresses = builder.replicationInstancePublicIpAddresses;
        this.replicationInstancePrivateIpAddresses = builder.replicationInstancePrivateIpAddresses;
        this.replicationInstanceIpv6Addresses = builder.replicationInstanceIpv6Addresses;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.freeUntil = builder.freeUntil;
        this.dnsNameServers = builder.dnsNameServers;
        this.networkType = builder.networkType;
    }

    /**
     * <p>
     * The replication instance identifier is a required parameter. This parameter is stored as a lowercase string.
     * </p>
     * <p>
     * Constraints:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Must contain 1-63 alphanumeric characters or hyphens.
     * </p>
     * </li>
     * <li>
     * <p>
     * First character must be a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Example: <code>myrepinstance</code>
     * </p>
     * 
     * @return The replication instance identifier is a required parameter. This parameter is stored as a lowercase
     *         string.</p>
     *         <p>
     *         Constraints:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Must contain 1-63 alphanumeric characters or hyphens.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         First character must be a letter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Cannot end with a hyphen or contain two consecutive hyphens.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Example: <code>myrepinstance</code>
     */
    public final String replicationInstanceIdentifier() {
        return replicationInstanceIdentifier;
    }

    /**
     * <p>
     * The compute and memory capacity of the replication instance as defined for the specified replication instance
     * class. It is a required parameter, although a default value is pre-selected in the DMS console.
     * </p>
     * <p>
     * For more information on the settings and capacities for the available replication instance classes, see <a href=
     * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
     * > Selecting the right DMS replication instance for your migration</a>.
     * </p>
     * 
     * @return The compute and memory capacity of the replication instance as defined for the specified replication
     *         instance class. It is a required parameter, although a default value is pre-selected in the DMS
     *         console.</p>
     *         <p>
     *         For more information on the settings and capacities for the available replication instance classes, see
     *         <a href=
     *         "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
     *         > Selecting the right DMS replication instance for your migration</a>.
     */
    public final String replicationInstanceClass() {
        return replicationInstanceClass;
    }

    /**
     * <p>
     * The status of the replication instance. The possible return values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"available"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"creating"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"deleted"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"deleting"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"failed"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"modifying"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"upgrading"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"rebooting"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"resetting-master-credentials"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"storage-full"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"incompatible-credentials"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"incompatible-network"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"maintenance"</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the replication instance. The possible return values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>"available"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"creating"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"deleted"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"deleting"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"failed"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"modifying"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"upgrading"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"rebooting"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"resetting-master-credentials"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"storage-full"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"incompatible-credentials"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"incompatible-network"</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>"maintenance"</code>
     *         </p>
     *         </li>
     */
    public final String replicationInstanceStatus() {
        return replicationInstanceStatus;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) that is allocated for the replication instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) that is allocated for the replication instance.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The time the replication instance was created.
     * </p>
     * 
     * @return The time the replication instance was created.
     */
    public final Instant instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The VPC security group for the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return The VPC security group for the instance.
     */
    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * The Availability Zone for the instance.
     * </p>
     * 
     * @return The Availability Zone for the instance.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The subnet group for the replication instance.
     * </p>
     * 
     * @return The subnet group for the replication instance.
     */
    public final ReplicationSubnetGroup replicationSubnetGroup() {
        return replicationSubnetGroup;
    }

    /**
     * <p>
     * The maintenance window times for the replication instance. Any pending upgrades to the replication instance are
     * performed during this time.
     * </p>
     * 
     * @return The maintenance window times for the replication instance. Any pending upgrades to the replication
     *         instance are performed during this time.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * The pending modification values.
     * </p>
     * 
     * @return The pending modification values.
     */
    public final ReplicationPendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     * </p>
     * 
     * @return Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
     *         <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The engine version number of the replication instance.
     * </p>
     * <p>
     * If an engine version number is not specified when a replication instance is created, the default is the latest
     * engine version available.
     * </p>
     * <p>
     * When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to
     * <code>true</code>.
     * </p>
     * 
     * @return The engine version number of the replication instance.</p>
     *         <p>
     *         If an engine version number is not specified when a replication instance is created, the default is the
     *         latest engine version available.
     *         </p>
     *         <p>
     *         When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to
     *         <code>true</code>.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * Boolean value indicating if minor version upgrades will be automatically applied to the instance.
     * </p>
     * 
     * @return Boolean value indicating if minor version upgrades will be automatically applied to the instance.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * An KMS key identifier that is used to encrypt the data on the replication instance.
     * </p>
     * <p>
     * If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption key.
     * </p>
     * <p>
     * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account has
     * a different default encryption key for each Amazon Web Services Region.
     * </p>
     * 
     * @return An KMS key identifier that is used to encrypt the data on the replication instance.</p>
     *         <p>
     *         If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default
     *         encryption key.
     *         </p>
     *         <p>
     *         KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
     *         account has a different default encryption key for each Amazon Web Services Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the replication instance.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the replication instance.
     */
    public final String replicationInstanceArn() {
        return replicationInstanceArn;
    }

    /**
     * <p>
     * The public IP address of the replication instance.
     * </p>
     * 
     * @return The public IP address of the replication instance.
     * @deprecated
     */
    @Deprecated
    public final String replicationInstancePublicIpAddress() {
        return replicationInstancePublicIpAddress;
    }

    /**
     * <p>
     * The private IP address of the replication instance.
     * </p>
     * 
     * @return The private IP address of the replication instance.
     * @deprecated
     */
    @Deprecated
    public final String replicationInstancePrivateIpAddress() {
        return replicationInstancePrivateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInstancePublicIpAddresses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicationInstancePublicIpAddresses() {
        return replicationInstancePublicIpAddresses != null
                && !(replicationInstancePublicIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more public IP addresses for the replication instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInstancePublicIpAddresses}
     * method.
     * </p>
     * 
     * @return One or more public IP addresses for the replication instance.
     */
    public final List<String> replicationInstancePublicIpAddresses() {
        return replicationInstancePublicIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInstancePrivateIpAddresses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicationInstancePrivateIpAddresses() {
        return replicationInstancePrivateIpAddresses != null
                && !(replicationInstancePrivateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more private IP addresses for the replication instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInstancePrivateIpAddresses}
     * method.
     * </p>
     * 
     * @return One or more private IP addresses for the replication instance.
     */
    public final List<String> replicationInstancePrivateIpAddresses() {
        return replicationInstancePrivateIpAddresses;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReplicationInstanceIpv6Addresses
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReplicationInstanceIpv6Addresses() {
        return replicationInstanceIpv6Addresses != null && !(replicationInstanceIpv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 addresses for the replication instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReplicationInstanceIpv6Addresses}
     * method.
     * </p>
     * 
     * @return One or more IPv6 addresses for the replication instance.
     */
    public final List<String> replicationInstanceIpv6Addresses() {
        return replicationInstanceIpv6Addresses;
    }

    /**
     * <p>
     * Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an
     * instance with a public IP address. A value of <code>false</code> represents an instance with a private IP
     * address. The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies the accessibility options for the replication instance. A value of <code>true</code> represents
     *         an instance with a public IP address. A value of <code>false</code> represents an instance with a private
     *         IP address. The default value is <code>true</code>.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The Availability Zone of the standby replication instance in a Multi-AZ deployment.
     * </p>
     * 
     * @return The Availability Zone of the standby replication instance in a Multi-AZ deployment.
     */
    public final String secondaryAvailabilityZone() {
        return secondaryAvailabilityZone;
    }

    /**
     * <p>
     * The expiration date of the free replication instance that is part of the Free DMS program.
     * </p>
     * 
     * @return The expiration date of the free replication instance that is part of the Free DMS program.
     */
    public final Instant freeUntil() {
        return freeUntil;
    }

    /**
     * <p>
     * The DNS name servers supported for the replication instance to access your on-premise source or target database.
     * </p>
     * 
     * @return The DNS name servers supported for the replication instance to access your on-premise source or target
     *         database.
     */
    public final String dnsNameServers() {
        return dnsNameServers;
    }

    /**
     * <p>
     * The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that supports
     * both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
     * </p>
     * 
     * @return The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that
     *         supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
     */
    public final String networkType() {
        return networkType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstancePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstancePrivateIpAddress());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationInstancePublicIpAddresses() ? replicationInstancePublicIpAddresses() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationInstancePrivateIpAddresses() ? replicationInstancePrivateIpAddresses() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReplicationInstanceIpv6Addresses() ? replicationInstanceIpv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(freeUntil());
        hashCode = 31 * hashCode + Objects.hashCode(dnsNameServers());
        hashCode = 31 * hashCode + Objects.hashCode(networkType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationInstance)) {
            return false;
        }
        ReplicationInstance other = (ReplicationInstance) obj;
        return Objects.equals(replicationInstanceIdentifier(), other.replicationInstanceIdentifier())
                && Objects.equals(replicationInstanceClass(), other.replicationInstanceClass())
                && Objects.equals(replicationInstanceStatus(), other.replicationInstanceStatus())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(replicationSubnetGroup(), other.replicationSubnetGroup())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(multiAZ(), other.multiAZ()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(replicationInstanceArn(), other.replicationInstanceArn())
                && Objects.equals(replicationInstancePublicIpAddress(), other.replicationInstancePublicIpAddress())
                && Objects.equals(replicationInstancePrivateIpAddress(), other.replicationInstancePrivateIpAddress())
                && hasReplicationInstancePublicIpAddresses() == other.hasReplicationInstancePublicIpAddresses()
                && Objects.equals(replicationInstancePublicIpAddresses(), other.replicationInstancePublicIpAddresses())
                && hasReplicationInstancePrivateIpAddresses() == other.hasReplicationInstancePrivateIpAddresses()
                && Objects.equals(replicationInstancePrivateIpAddresses(), other.replicationInstancePrivateIpAddresses())
                && hasReplicationInstanceIpv6Addresses() == other.hasReplicationInstanceIpv6Addresses()
                && Objects.equals(replicationInstanceIpv6Addresses(), other.replicationInstanceIpv6Addresses())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(secondaryAvailabilityZone(), other.secondaryAvailabilityZone())
                && Objects.equals(freeUntil(), other.freeUntil()) && Objects.equals(dnsNameServers(), other.dnsNameServers())
                && Objects.equals(networkType(), other.networkType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ReplicationInstance")
                .add("ReplicationInstanceIdentifier", replicationInstanceIdentifier())
                .add("ReplicationInstanceClass", replicationInstanceClass())
                .add("ReplicationInstanceStatus", replicationInstanceStatus())
                .add("AllocatedStorage", allocatedStorage())
                .add("InstanceCreateTime", instanceCreateTime())
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("AvailabilityZone", availabilityZone())
                .add("ReplicationSubnetGroup", replicationSubnetGroup())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PendingModifiedValues", pendingModifiedValues())
                .add("MultiAZ", multiAZ())
                .add("EngineVersion", engineVersion())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("KmsKeyId", kmsKeyId())
                .add("ReplicationInstanceArn", replicationInstanceArn())
                .add("ReplicationInstancePublicIpAddress", replicationInstancePublicIpAddress())
                .add("ReplicationInstancePrivateIpAddress", replicationInstancePrivateIpAddress())
                .add("ReplicationInstancePublicIpAddresses",
                        hasReplicationInstancePublicIpAddresses() ? replicationInstancePublicIpAddresses() : null)
                .add("ReplicationInstancePrivateIpAddresses",
                        hasReplicationInstancePrivateIpAddresses() ? replicationInstancePrivateIpAddresses() : null)
                .add("ReplicationInstanceIpv6Addresses",
                        hasReplicationInstanceIpv6Addresses() ? replicationInstanceIpv6Addresses() : null)
                .add("PubliclyAccessible", publiclyAccessible()).add("SecondaryAvailabilityZone", secondaryAvailabilityZone())
                .add("FreeUntil", freeUntil()).add("DnsNameServers", dnsNameServers()).add("NetworkType", networkType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReplicationInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationInstanceIdentifier()));
        case "ReplicationInstanceClass":
            return Optional.ofNullable(clazz.cast(replicationInstanceClass()));
        case "ReplicationInstanceStatus":
            return Optional.ofNullable(clazz.cast(replicationInstanceStatus()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "ReplicationSubnetGroup":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroup()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "ReplicationInstanceArn":
            return Optional.ofNullable(clazz.cast(replicationInstanceArn()));
        case "ReplicationInstancePublicIpAddress":
            return Optional.ofNullable(clazz.cast(replicationInstancePublicIpAddress()));
        case "ReplicationInstancePrivateIpAddress":
            return Optional.ofNullable(clazz.cast(replicationInstancePrivateIpAddress()));
        case "ReplicationInstancePublicIpAddresses":
            return Optional.ofNullable(clazz.cast(replicationInstancePublicIpAddresses()));
        case "ReplicationInstancePrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(replicationInstancePrivateIpAddresses()));
        case "ReplicationInstanceIpv6Addresses":
            return Optional.ofNullable(clazz.cast(replicationInstanceIpv6Addresses()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "SecondaryAvailabilityZone":
            return Optional.ofNullable(clazz.cast(secondaryAvailabilityZone()));
        case "FreeUntil":
            return Optional.ofNullable(clazz.cast(freeUntil()));
        case "DnsNameServers":
            return Optional.ofNullable(clazz.cast(dnsNameServers()));
        case "NetworkType":
            return Optional.ofNullable(clazz.cast(networkType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplicationInstance, T> g) {
        return obj -> g.apply((ReplicationInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReplicationInstance> {
        /**
         * <p>
         * The replication instance identifier is a required parameter. This parameter is stored as a lowercase string.
         * </p>
         * <p>
         * Constraints:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Must contain 1-63 alphanumeric characters or hyphens.
         * </p>
         * </li>
         * <li>
         * <p>
         * First character must be a letter.
         * </p>
         * </li>
         * <li>
         * <p>
         * Cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Example: <code>myrepinstance</code>
         * </p>
         * 
         * @param replicationInstanceIdentifier
         *        The replication instance identifier is a required parameter. This parameter is stored as a lowercase
         *        string.</p>
         *        <p>
         *        Constraints:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Must contain 1-63 alphanumeric characters or hyphens.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        First character must be a letter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Cannot end with a hyphen or contain two consecutive hyphens.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Example: <code>myrepinstance</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIdentifier(String replicationInstanceIdentifier);

        /**
         * <p>
         * The compute and memory capacity of the replication instance as defined for the specified replication instance
         * class. It is a required parameter, although a default value is pre-selected in the DMS console.
         * </p>
         * <p>
         * For more information on the settings and capacities for the available replication instance classes, see <a
         * href=
         * "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
         * > Selecting the right DMS replication instance for your migration</a>.
         * </p>
         * 
         * @param replicationInstanceClass
         *        The compute and memory capacity of the replication instance as defined for the specified replication
         *        instance class. It is a required parameter, although a default value is pre-selected in the DMS
         *        console.</p>
         *        <p>
         *        For more information on the settings and capacities for the available replication instance classes,
         *        see <a href=
         *        "https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth"
         *        > Selecting the right DMS replication instance for your migration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceClass(String replicationInstanceClass);

        /**
         * <p>
         * The status of the replication instance. The possible return values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>"available"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"creating"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"deleted"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"deleting"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"failed"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"modifying"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"upgrading"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"rebooting"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"resetting-master-credentials"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"storage-full"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"incompatible-credentials"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"incompatible-network"</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>"maintenance"</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param replicationInstanceStatus
         *        The status of the replication instance. The possible return values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>"available"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"creating"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"deleted"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"deleting"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"failed"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"modifying"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"upgrading"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"rebooting"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"resetting-master-credentials"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"storage-full"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"incompatible-credentials"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"incompatible-network"</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>"maintenance"</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceStatus(String replicationInstanceStatus);

        /**
         * <p>
         * The amount of storage (in gigabytes) that is allocated for the replication instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) that is allocated for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The time the replication instance was created.
         * </p>
         * 
         * @param instanceCreateTime
         *        The time the replication instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(Instant instanceCreateTime);

        /**
         * <p>
         * The VPC security group for the instance.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The VPC security group for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups);

        /**
         * <p>
         * The VPC security group for the instance.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The VPC security group for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups);

        /**
         * <p>
         * The VPC security group for the instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupMembership.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupMembership.Builder#build()} is
         * called immediately and its result is passed to {@link #vpcSecurityGroups(List<VpcSecurityGroupMembership>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(java.util.Collection<VpcSecurityGroupMembership>)
         */
        Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * The Availability Zone for the instance.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The subnet group for the replication instance.
         * </p>
         * 
         * @param replicationSubnetGroup
         *        The subnet group for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroup(ReplicationSubnetGroup replicationSubnetGroup);

        /**
         * <p>
         * The subnet group for the replication instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationSubnetGroup.Builder} avoiding
         * the need to create one manually via {@link ReplicationSubnetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationSubnetGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #replicationSubnetGroup(ReplicationSubnetGroup)}.
         * 
         * @param replicationSubnetGroup
         *        a consumer that will call methods on {@link ReplicationSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationSubnetGroup(ReplicationSubnetGroup)
         */
        default Builder replicationSubnetGroup(Consumer<ReplicationSubnetGroup.Builder> replicationSubnetGroup) {
            return replicationSubnetGroup(ReplicationSubnetGroup.builder().applyMutation(replicationSubnetGroup).build());
        }

        /**
         * <p>
         * The maintenance window times for the replication instance. Any pending upgrades to the replication instance
         * are performed during this time.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The maintenance window times for the replication instance. Any pending upgrades to the replication
         *        instance are performed during this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * The pending modification values.
         * </p>
         * 
         * @param pendingModifiedValues
         *        The pending modification values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(ReplicationPendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * The pending modification values.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReplicationPendingModifiedValues.Builder}
         * avoiding the need to create one manually via {@link ReplicationPendingModifiedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReplicationPendingModifiedValues.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingModifiedValues(ReplicationPendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link ReplicationPendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(ReplicationPendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<ReplicationPendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(ReplicationPendingModifiedValues.builder().applyMutation(pendingModifiedValues).build());
        }

        /**
         * <p>
         * Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         * <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the replication instance is a Multi-AZ deployment. You can't set the
         *        <code>AvailabilityZone</code> parameter if the Multi-AZ parameter is set to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The engine version number of the replication instance.
         * </p>
         * <p>
         * If an engine version number is not specified when a replication instance is created, the default is the
         * latest engine version available.
         * </p>
         * <p>
         * When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code> to
         * <code>true</code>.
         * </p>
         * 
         * @param engineVersion
         *        The engine version number of the replication instance.</p>
         *        <p>
         *        If an engine version number is not specified when a replication instance is created, the default is
         *        the latest engine version available.
         *        </p>
         *        <p>
         *        When modifying a major engine version of an instance, also set <code>AllowMajorVersionUpgrade</code>
         *        to <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * Boolean value indicating if minor version upgrades will be automatically applied to the instance.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Boolean value indicating if minor version upgrades will be automatically applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * An KMS key identifier that is used to encrypt the data on the replication instance.
         * </p>
         * <p>
         * If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default encryption
         * key.
         * </p>
         * <p>
         * KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services account
         * has a different default encryption key for each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyId
         *        An KMS key identifier that is used to encrypt the data on the replication instance.</p>
         *        <p>
         *        If you don't specify a value for the <code>KmsKeyId</code> parameter, then DMS uses your default
         *        encryption key.
         *        </p>
         *        <p>
         *        KMS creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
         *        account has a different default encryption key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the replication instance.
         * </p>
         * 
         * @param replicationInstanceArn
         *        The Amazon Resource Name (ARN) of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceArn(String replicationInstanceArn);

        /**
         * <p>
         * The public IP address of the replication instance.
         * </p>
         * 
         * @param replicationInstancePublicIpAddress
         *        The public IP address of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder replicationInstancePublicIpAddress(String replicationInstancePublicIpAddress);

        /**
         * <p>
         * The private IP address of the replication instance.
         * </p>
         * 
         * @param replicationInstancePrivateIpAddress
         *        The private IP address of the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         * @deprecated
         */
        @Deprecated
        Builder replicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress);

        /**
         * <p>
         * One or more public IP addresses for the replication instance.
         * </p>
         * 
         * @param replicationInstancePublicIpAddresses
         *        One or more public IP addresses for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses);

        /**
         * <p>
         * One or more public IP addresses for the replication instance.
         * </p>
         * 
         * @param replicationInstancePublicIpAddresses
         *        One or more public IP addresses for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstancePublicIpAddresses(String... replicationInstancePublicIpAddresses);

        /**
         * <p>
         * One or more private IP addresses for the replication instance.
         * </p>
         * 
         * @param replicationInstancePrivateIpAddresses
         *        One or more private IP addresses for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses);

        /**
         * <p>
         * One or more private IP addresses for the replication instance.
         * </p>
         * 
         * @param replicationInstancePrivateIpAddresses
         *        One or more private IP addresses for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstancePrivateIpAddresses(String... replicationInstancePrivateIpAddresses);

        /**
         * <p>
         * One or more IPv6 addresses for the replication instance.
         * </p>
         * 
         * @param replicationInstanceIpv6Addresses
         *        One or more IPv6 addresses for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses);

        /**
         * <p>
         * One or more IPv6 addresses for the replication instance.
         * </p>
         * 
         * @param replicationInstanceIpv6Addresses
         *        One or more IPv6 addresses for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIpv6Addresses(String... replicationInstanceIpv6Addresses);

        /**
         * <p>
         * Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an
         * instance with a public IP address. A value of <code>false</code> represents an instance with a private IP
         * address. The default value is <code>true</code>.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for the replication instance. A value of <code>true</code>
         *        represents an instance with a public IP address. A value of <code>false</code> represents an instance
         *        with a private IP address. The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The Availability Zone of the standby replication instance in a Multi-AZ deployment.
         * </p>
         * 
         * @param secondaryAvailabilityZone
         *        The Availability Zone of the standby replication instance in a Multi-AZ deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAvailabilityZone(String secondaryAvailabilityZone);

        /**
         * <p>
         * The expiration date of the free replication instance that is part of the Free DMS program.
         * </p>
         * 
         * @param freeUntil
         *        The expiration date of the free replication instance that is part of the Free DMS program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder freeUntil(Instant freeUntil);

        /**
         * <p>
         * The DNS name servers supported for the replication instance to access your on-premise source or target
         * database.
         * </p>
         * 
         * @param dnsNameServers
         *        The DNS name servers supported for the replication instance to access your on-premise source or target
         *        database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsNameServers(String dnsNameServers);

        /**
         * <p>
         * The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that supports
         * both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         * </p>
         * 
         * @param networkType
         *        The type of IP address protocol used by a replication instance, such as IPv4 only or Dual-stack that
         *        supports both IPv4 and IPv6 addressing. IPv6 only is not yet supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkType(String networkType);
    }

    static final class BuilderImpl implements Builder {
        private String replicationInstanceIdentifier;

        private String replicationInstanceClass;

        private String replicationInstanceStatus;

        private Integer allocatedStorage;

        private Instant instanceCreateTime;

        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private ReplicationSubnetGroup replicationSubnetGroup;

        private String preferredMaintenanceWindow;

        private ReplicationPendingModifiedValues pendingModifiedValues;

        private Boolean multiAZ;

        private String engineVersion;

        private Boolean autoMinorVersionUpgrade;

        private String kmsKeyId;

        private String replicationInstanceArn;

        private String replicationInstancePublicIpAddress;

        private String replicationInstancePrivateIpAddress;

        private List<String> replicationInstancePublicIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> replicationInstancePrivateIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private List<String> replicationInstanceIpv6Addresses = DefaultSdkAutoConstructList.getInstance();

        private Boolean publiclyAccessible;

        private String secondaryAvailabilityZone;

        private Instant freeUntil;

        private String dnsNameServers;

        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(ReplicationInstance model) {
            replicationInstanceIdentifier(model.replicationInstanceIdentifier);
            replicationInstanceClass(model.replicationInstanceClass);
            replicationInstanceStatus(model.replicationInstanceStatus);
            allocatedStorage(model.allocatedStorage);
            instanceCreateTime(model.instanceCreateTime);
            vpcSecurityGroups(model.vpcSecurityGroups);
            availabilityZone(model.availabilityZone);
            replicationSubnetGroup(model.replicationSubnetGroup);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            pendingModifiedValues(model.pendingModifiedValues);
            multiAZ(model.multiAZ);
            engineVersion(model.engineVersion);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            kmsKeyId(model.kmsKeyId);
            replicationInstanceArn(model.replicationInstanceArn);
            replicationInstancePublicIpAddress(model.replicationInstancePublicIpAddress);
            replicationInstancePrivateIpAddress(model.replicationInstancePrivateIpAddress);
            replicationInstancePublicIpAddresses(model.replicationInstancePublicIpAddresses);
            replicationInstancePrivateIpAddresses(model.replicationInstancePrivateIpAddresses);
            replicationInstanceIpv6Addresses(model.replicationInstanceIpv6Addresses);
            publiclyAccessible(model.publiclyAccessible);
            secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            freeUntil(model.freeUntil);
            dnsNameServers(model.dnsNameServers);
            networkType(model.networkType);
        }

        public final String getReplicationInstanceIdentifier() {
            return replicationInstanceIdentifier;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final String getReplicationInstanceClass() {
            return replicationInstanceClass;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final String getReplicationInstanceStatus() {
            return replicationInstanceStatus;
        }

        public final void setReplicationInstanceStatus(String replicationInstanceStatus) {
            this.replicationInstanceStatus = replicationInstanceStatus;
        }

        @Override
        public final Builder replicationInstanceStatus(String replicationInstanceStatus) {
            this.replicationInstanceStatus = replicationInstanceStatus;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Instant getInstanceCreateTime() {
            return instanceCreateTime;
        }

        public final void setInstanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(Instant instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> VpcSecurityGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final ReplicationSubnetGroup.Builder getReplicationSubnetGroup() {
            return replicationSubnetGroup != null ? replicationSubnetGroup.toBuilder() : null;
        }

        public final void setReplicationSubnetGroup(ReplicationSubnetGroup.BuilderImpl replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup != null ? replicationSubnetGroup.build() : null;
        }

        @Override
        public final Builder replicationSubnetGroup(ReplicationSubnetGroup replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final ReplicationPendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(ReplicationPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(ReplicationPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getReplicationInstanceArn() {
            return replicationInstanceArn;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        @Deprecated
        public final String getReplicationInstancePublicIpAddress() {
            return replicationInstancePublicIpAddress;
        }

        @Deprecated
        public final void setReplicationInstancePublicIpAddress(String replicationInstancePublicIpAddress) {
            this.replicationInstancePublicIpAddress = replicationInstancePublicIpAddress;
        }

        @Override
        @Deprecated
        public final Builder replicationInstancePublicIpAddress(String replicationInstancePublicIpAddress) {
            this.replicationInstancePublicIpAddress = replicationInstancePublicIpAddress;
            return this;
        }

        @Deprecated
        public final String getReplicationInstancePrivateIpAddress() {
            return replicationInstancePrivateIpAddress;
        }

        @Deprecated
        public final void setReplicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress) {
            this.replicationInstancePrivateIpAddress = replicationInstancePrivateIpAddress;
        }

        @Override
        @Deprecated
        public final Builder replicationInstancePrivateIpAddress(String replicationInstancePrivateIpAddress) {
            this.replicationInstancePrivateIpAddress = replicationInstancePrivateIpAddress;
            return this;
        }

        public final Collection<String> getReplicationInstancePublicIpAddresses() {
            if (replicationInstancePublicIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationInstancePublicIpAddresses;
        }

        public final void setReplicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses) {
            this.replicationInstancePublicIpAddresses = ReplicationInstancePublicIpAddressListCopier
                    .copy(replicationInstancePublicIpAddresses);
        }

        @Override
        public final Builder replicationInstancePublicIpAddresses(Collection<String> replicationInstancePublicIpAddresses) {
            this.replicationInstancePublicIpAddresses = ReplicationInstancePublicIpAddressListCopier
                    .copy(replicationInstancePublicIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstancePublicIpAddresses(String... replicationInstancePublicIpAddresses) {
            replicationInstancePublicIpAddresses(Arrays.asList(replicationInstancePublicIpAddresses));
            return this;
        }

        public final Collection<String> getReplicationInstancePrivateIpAddresses() {
            if (replicationInstancePrivateIpAddresses instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationInstancePrivateIpAddresses;
        }

        public final void setReplicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses) {
            this.replicationInstancePrivateIpAddresses = ReplicationInstancePrivateIpAddressListCopier
                    .copy(replicationInstancePrivateIpAddresses);
        }

        @Override
        public final Builder replicationInstancePrivateIpAddresses(Collection<String> replicationInstancePrivateIpAddresses) {
            this.replicationInstancePrivateIpAddresses = ReplicationInstancePrivateIpAddressListCopier
                    .copy(replicationInstancePrivateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstancePrivateIpAddresses(String... replicationInstancePrivateIpAddresses) {
            replicationInstancePrivateIpAddresses(Arrays.asList(replicationInstancePrivateIpAddresses));
            return this;
        }

        public final Collection<String> getReplicationInstanceIpv6Addresses() {
            if (replicationInstanceIpv6Addresses instanceof SdkAutoConstructList) {
                return null;
            }
            return replicationInstanceIpv6Addresses;
        }

        public final void setReplicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses) {
            this.replicationInstanceIpv6Addresses = ReplicationInstanceIpv6AddressListCopier
                    .copy(replicationInstanceIpv6Addresses);
        }

        @Override
        public final Builder replicationInstanceIpv6Addresses(Collection<String> replicationInstanceIpv6Addresses) {
            this.replicationInstanceIpv6Addresses = ReplicationInstanceIpv6AddressListCopier
                    .copy(replicationInstanceIpv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceIpv6Addresses(String... replicationInstanceIpv6Addresses) {
            replicationInstanceIpv6Addresses(Arrays.asList(replicationInstanceIpv6Addresses));
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getSecondaryAvailabilityZone() {
            return secondaryAvailabilityZone;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final Instant getFreeUntil() {
            return freeUntil;
        }

        public final void setFreeUntil(Instant freeUntil) {
            this.freeUntil = freeUntil;
        }

        @Override
        public final Builder freeUntil(Instant freeUntil) {
            this.freeUntil = freeUntil;
            return this;
        }

        public final String getDnsNameServers() {
            return dnsNameServers;
        }

        public final void setDnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
        }

        @Override
        public final Builder dnsNameServers(String dnsNameServers) {
            this.dnsNameServers = dnsNameServers;
            return this;
        }

        public final String getNetworkType() {
            return networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public ReplicationInstance build() {
            return new ReplicationInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
