/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information that defines a MySQL data provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MySqlDataProviderSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<MySqlDataProviderSettings.Builder, MySqlDataProviderSettings> {
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerName").getter(getter(MySqlDataProviderSettings::serverName)).setter(setter(Builder::serverName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()).build();

    private static final SdkField<Integer> PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Port")
            .getter(getter(MySqlDataProviderSettings::port)).setter(setter(Builder::port))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()).build();

    private static final SdkField<String> SSL_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SslMode").getter(getter(MySqlDataProviderSettings::sslModeAsString)).setter(setter(Builder::sslMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslMode").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateArn").getter(getter(MySqlDataProviderSettings::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_NAME_FIELD, PORT_FIELD,
            SSL_MODE_FIELD, CERTIFICATE_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serverName;

    private final Integer port;

    private final String sslMode;

    private final String certificateArn;

    private MySqlDataProviderSettings(BuilderImpl builder) {
        this.serverName = builder.serverName;
        this.port = builder.port;
        this.sslMode = builder.sslMode;
        this.certificateArn = builder.certificateArn;
    }

    /**
     * <p>
     * The name of the MySQL server.
     * </p>
     * 
     * @return The name of the MySQL server.
     */
    public final String serverName() {
        return serverName;
    }

    /**
     * <p>
     * The port value for the MySQL data provider.
     * </p>
     * 
     * @return The port value for the MySQL data provider.
     */
    public final Integer port() {
        return port;
    }

    /**
     * <p>
     * The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public final DmsSslModeValue sslMode() {
        return DmsSslModeValue.fromValue(sslMode);
    }

    /**
     * <p>
     * The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sslMode} will
     * return {@link DmsSslModeValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sslModeAsString}.
     * </p>
     * 
     * @return The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
     * @see DmsSslModeValue
     */
    public final String sslModeAsString() {
        return sslMode;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate used for SSL connection.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverName());
        hashCode = 31 * hashCode + Objects.hashCode(port());
        hashCode = 31 * hashCode + Objects.hashCode(sslModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MySqlDataProviderSettings)) {
            return false;
        }
        MySqlDataProviderSettings other = (MySqlDataProviderSettings) obj;
        return Objects.equals(serverName(), other.serverName()) && Objects.equals(port(), other.port())
                && Objects.equals(sslModeAsString(), other.sslModeAsString())
                && Objects.equals(certificateArn(), other.certificateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MySqlDataProviderSettings").add("ServerName", serverName()).add("Port", port())
                .add("SslMode", sslModeAsString()).add("CertificateArn", certificateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerName":
            return Optional.ofNullable(clazz.cast(serverName()));
        case "Port":
            return Optional.ofNullable(clazz.cast(port()));
        case "SslMode":
            return Optional.ofNullable(clazz.cast(sslModeAsString()));
        case "CertificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MySqlDataProviderSettings, T> g) {
        return obj -> g.apply((MySqlDataProviderSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MySqlDataProviderSettings> {
        /**
         * <p>
         * The name of the MySQL server.
         * </p>
         * 
         * @param serverName
         *        The name of the MySQL server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverName(String serverName);

        /**
         * <p>
         * The port value for the MySQL data provider.
         * </p>
         * 
         * @param port
         *        The port value for the MySQL data provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder port(Integer port);

        /**
         * <p>
         * The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(String sslMode);

        /**
         * <p>
         * The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
         * </p>
         * 
         * @param sslMode
         *        The SSL mode used to connect to the MySQL data provider. The default value is <code>none</code>.
         * @see DmsSslModeValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DmsSslModeValue
         */
        Builder sslMode(DmsSslModeValue sslMode);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate used for SSL connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);
    }

    static final class BuilderImpl implements Builder {
        private String serverName;

        private Integer port;

        private String sslMode;

        private String certificateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MySqlDataProviderSettings model) {
            serverName(model.serverName);
            port(model.port);
            sslMode(model.sslMode);
            certificateArn(model.certificateArn);
        }

        public final String getServerName() {
            return serverName;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final Integer getPort() {
            return port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getSslMode() {
            return sslMode;
        }

        public final void setSslMode(String sslMode) {
            this.sslMode = sslMode;
        }

        @Override
        public final Builder sslMode(String sslMode) {
            this.sslMode = sslMode;
            return this;
        }

        @Override
        public final Builder sslMode(DmsSslModeValue sslMode) {
            this.sslMode(sslMode == null ? null : sslMode.toString());
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        @Override
        public MySqlDataProviderSettings build() {
            return new MySqlDataProviderSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
