/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStartRecommendationsRequest extends DatabaseMigrationRequest implements
        ToCopyableBuilder<BatchStartRecommendationsRequest.Builder, BatchStartRecommendationsRequest> {
    private static final SdkField<List<StartRecommendationsRequestEntry>> DATA_FIELD = SdkField
            .<List<StartRecommendationsRequestEntry>> builder(MarshallingType.LIST)
            .memberName("Data")
            .getter(getter(BatchStartRecommendationsRequest::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StartRecommendationsRequestEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(StartRecommendationsRequestEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD));

    private final List<StartRecommendationsRequestEntry> data;

    private BatchStartRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.data = builder.data;
    }

    /**
     * For responses, this returns true if the service returned a value for the Data property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends target
     * engines for each source database.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasData} method.
     * </p>
     * 
     * @return Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends
     *         target engines for each source database.
     */
    public final List<StartRecommendationsRequestEntry> data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStartRecommendationsRequest)) {
            return false;
        }
        BatchStartRecommendationsRequest other = (BatchStartRecommendationsRequest) obj;
        return hasData() == other.hasData() && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStartRecommendationsRequest").add("Data", hasData() ? data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchStartRecommendationsRequest, T> g) {
        return obj -> g.apply((BatchStartRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DatabaseMigrationRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchStartRecommendationsRequest> {
        /**
         * <p>
         * Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends target
         * engines for each source database.
         * </p>
         * 
         * @param data
         *        Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends
         *        target engines for each source database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Collection<StartRecommendationsRequestEntry> data);

        /**
         * <p>
         * Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends target
         * engines for each source database.
         * </p>
         * 
         * @param data
         *        Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends
         *        target engines for each source database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(StartRecommendationsRequestEntry... data);

        /**
         * <p>
         * Provides information about source databases to analyze. After this analysis, Fleet Advisor recommends target
         * engines for each source database.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry.Builder#build()}
         * is called immediately and its result is passed to {@link #data(List<StartRecommendationsRequestEntry>)}.
         * 
         * @param data
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.databasemigration.model.StartRecommendationsRequestEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(java.util.Collection<StartRecommendationsRequestEntry>)
         */
        Builder data(Consumer<StartRecommendationsRequestEntry.Builder>... data);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DatabaseMigrationRequest.BuilderImpl implements Builder {
        private List<StartRecommendationsRequestEntry> data = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStartRecommendationsRequest model) {
            super(model);
            data(model.data);
        }

        public final List<StartRecommendationsRequestEntry.Builder> getData() {
            List<StartRecommendationsRequestEntry.Builder> result = StartRecommendationsRequestEntryListCopier
                    .copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setData(Collection<StartRecommendationsRequestEntry.BuilderImpl> data) {
            this.data = StartRecommendationsRequestEntryListCopier.copyFromBuilder(data);
        }

        @Override
        public final Builder data(Collection<StartRecommendationsRequestEntry> data) {
            this.data = StartRecommendationsRequestEntryListCopier.copy(data);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(StartRecommendationsRequestEntry... data) {
            data(Arrays.asList(data));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder data(Consumer<StartRecommendationsRequestEntry.Builder>... data) {
            data(Stream.of(data).map(c -> StartRecommendationsRequestEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchStartRecommendationsRequest build() {
            return new BatchStartRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
