/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateViewMetadataRequest extends ConnectRequest implements
        ToCopyableBuilder<UpdateViewMetadataRequest.Builder, UpdateViewMetadataRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(UpdateViewMetadataRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ViewId")
            .getter(getter(UpdateViewMetadataRequest::viewId)).setter(setter(Builder::viewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ViewId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateViewMetadataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateViewMetadataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            VIEW_ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD));

    private final String instanceId;

    private final String viewId;

    private final String name;

    private final String description;

    private UpdateViewMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.viewId = builder.viewId;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
     * </p>
     * 
     * @return The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
     */
    public final String viewId() {
        return viewId;
    }

    /**
     * <p>
     * The name of the view.
     * </p>
     * 
     * @return The name of the view.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the view.
     * </p>
     * 
     * @return The description of the view.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(viewId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateViewMetadataRequest)) {
            return false;
        }
        UpdateViewMetadataRequest other = (UpdateViewMetadataRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(viewId(), other.viewId())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateViewMetadataRequest").add("InstanceId", instanceId()).add("ViewId", viewId())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ViewId":
            return Optional.ofNullable(clazz.cast(viewId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateViewMetadataRequest, T> g) {
        return obj -> g.apply((UpdateViewMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateViewMetadataRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
         * </p>
         * 
         * @param viewId
         *        The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewId(String viewId);

        /**
         * <p>
         * The name of the view.
         * </p>
         * 
         * @param name
         *        The name of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the view.
         * </p>
         * 
         * @param description
         *        The description of the view.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String viewId;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateViewMetadataRequest model) {
            super(model);
            instanceId(model.instanceId);
            viewId(model.viewId);
            name(model.name);
            description(model.description);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getViewId() {
            return viewId;
        }

        public final void setViewId(String viewId) {
            this.viewId = viewId;
        }

        @Override
        public final Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateViewMetadataRequest build() {
            return new UpdateViewMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
