/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the property value used in automation of a numeric questions. Label values are associated with
 * minimum and maximum values for the numeric question.
 * </p>
 * <ul>
 * <li>
 * <p>
 * Sentiment scores have a minimum value of -5 and maximum value of 5.
 * </p>
 * </li>
 * <li>
 * <p>
 * Duration labels, such as <code>NON_TALK_TIME</code>, <code>CONTACT_DURATION</code>,
 * <code>AGENT_INTERACTION_DURATION</code>, <code>CUSTOMER_HOLD_TIME</code> have a minimum value of 0 and maximum value
 * of 28800.
 * </p>
 * </li>
 * <li>
 * <p>
 * Percentages have a minimum value of 0 and maximum value of 100.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>NUMBER_OF_INTERRUPTIONS</code> has a minimum value of 0 and maximum value of 1000.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NumericQuestionPropertyValueAutomation implements SdkPojo, Serializable,
        ToCopyableBuilder<NumericQuestionPropertyValueAutomation.Builder, NumericQuestionPropertyValueAutomation> {
    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(NumericQuestionPropertyValueAutomation::labelAsString)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String label;

    private NumericQuestionPropertyValueAutomation(BuilderImpl builder) {
        this.label = builder.label;
    }

    /**
     * <p>
     * The property label of the automation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link NumericQuestionPropertyAutomationLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #labelAsString}.
     * </p>
     * 
     * @return The property label of the automation.
     * @see NumericQuestionPropertyAutomationLabel
     */
    public final NumericQuestionPropertyAutomationLabel label() {
        return NumericQuestionPropertyAutomationLabel.fromValue(label);
    }

    /**
     * <p>
     * The property label of the automation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #label} will return
     * {@link NumericQuestionPropertyAutomationLabel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #labelAsString}.
     * </p>
     * 
     * @return The property label of the automation.
     * @see NumericQuestionPropertyAutomationLabel
     */
    public final String labelAsString() {
        return label;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(labelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NumericQuestionPropertyValueAutomation)) {
            return false;
        }
        NumericQuestionPropertyValueAutomation other = (NumericQuestionPropertyValueAutomation) obj;
        return Objects.equals(labelAsString(), other.labelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NumericQuestionPropertyValueAutomation").add("Label", labelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Label":
            return Optional.ofNullable(clazz.cast(labelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NumericQuestionPropertyValueAutomation, T> g) {
        return obj -> g.apply((NumericQuestionPropertyValueAutomation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NumericQuestionPropertyValueAutomation> {
        /**
         * <p>
         * The property label of the automation.
         * </p>
         * 
         * @param label
         *        The property label of the automation.
         * @see NumericQuestionPropertyAutomationLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericQuestionPropertyAutomationLabel
         */
        Builder label(String label);

        /**
         * <p>
         * The property label of the automation.
         * </p>
         * 
         * @param label
         *        The property label of the automation.
         * @see NumericQuestionPropertyAutomationLabel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NumericQuestionPropertyAutomationLabel
         */
        Builder label(NumericQuestionPropertyAutomationLabel label);
    }

    static final class BuilderImpl implements Builder {
        private String label;

        private BuilderImpl() {
        }

        private BuilderImpl(NumericQuestionPropertyValueAutomation model) {
            label(model.label);
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        @Override
        public final Builder label(NumericQuestionPropertyAutomationLabel label) {
            this.label(label == null ? null : label.toString());
            return this;
        }

        @Override
        public NumericQuestionPropertyValueAutomation build() {
            return new NumericQuestionPropertyValueAutomation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
