/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLexBotsResponse extends ConnectResponse implements
        ToCopyableBuilder<ListLexBotsResponse.Builder, ListLexBotsResponse> {
    private static final SdkField<List<LexBot>> LEX_BOTS_FIELD = SdkField
            .<List<LexBot>> builder(MarshallingType.LIST)
            .memberName("LexBots")
            .getter(getter(ListLexBotsResponse::lexBots))
            .setter(setter(Builder::lexBots))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LexBots").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LexBot> builder(MarshallingType.SDK_POJO)
                                            .constructor(LexBot::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLexBotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEX_BOTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<LexBot> lexBots;

    private final String nextToken;

    private ListLexBotsResponse(BuilderImpl builder) {
        super(builder);
        this.lexBots = builder.lexBots;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the LexBots property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLexBots() {
        return lexBots != null && !(lexBots instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLexBots} method.
     * </p>
     * 
     * @return The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified instance.
     */
    public final List<LexBot> lexBots() {
        return lexBots;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLexBots() ? lexBots() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLexBotsResponse)) {
            return false;
        }
        ListLexBotsResponse other = (ListLexBotsResponse) obj;
        return hasLexBots() == other.hasLexBots() && Objects.equals(lexBots(), other.lexBots())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLexBotsResponse").add("LexBots", hasLexBots() ? lexBots() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LexBots":
            return Optional.ofNullable(clazz.cast(lexBots()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLexBotsResponse, T> g) {
        return obj -> g.apply((ListLexBotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLexBotsResponse> {
        /**
         * <p>
         * The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified instance.
         * </p>
         * 
         * @param lexBots
         *        The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBots(Collection<LexBot> lexBots);

        /**
         * <p>
         * The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified instance.
         * </p>
         * 
         * @param lexBots
         *        The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lexBots(LexBot... lexBots);

        /**
         * <p>
         * The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.LexBot.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.connect.model.LexBot#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.LexBot.Builder#build()} is called immediately and its
         * result is passed to {@link #lexBots(List<LexBot>)}.
         * 
         * @param lexBots
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.LexBot.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lexBots(java.util.Collection<LexBot>)
         */
        Builder lexBots(Consumer<LexBot.Builder>... lexBots);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ConnectResponse.BuilderImpl implements Builder {
        private List<LexBot> lexBots = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLexBotsResponse model) {
            super(model);
            lexBots(model.lexBots);
            nextToken(model.nextToken);
        }

        public final List<LexBot.Builder> getLexBots() {
            List<LexBot.Builder> result = LexBotsListCopier.copyToBuilder(this.lexBots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLexBots(Collection<LexBot.BuilderImpl> lexBots) {
            this.lexBots = LexBotsListCopier.copyFromBuilder(lexBots);
        }

        @Override
        public final Builder lexBots(Collection<LexBot> lexBots) {
            this.lexBots = LexBotsListCopier.copy(lexBots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(LexBot... lexBots) {
            lexBots(Arrays.asList(lexBots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lexBots(Consumer<LexBot.Builder>... lexBots) {
            lexBots(Stream.of(lexBots).map(c -> LexBot.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLexBotsResponse build() {
            return new ListLexBotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
