/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the automation configuration in single select questions. Automation options are evaluated in order,
 * and the first matched option is applied. If no automation option matches, and there is a default option, then the
 * default option is applied.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationFormSingleSelectQuestionAutomation implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationFormSingleSelectQuestionAutomation.Builder, EvaluationFormSingleSelectQuestionAutomation> {
    private static final SdkField<List<EvaluationFormSingleSelectQuestionAutomationOption>> OPTIONS_FIELD = SdkField
            .<List<EvaluationFormSingleSelectQuestionAutomationOption>> builder(MarshallingType.LIST)
            .memberName("Options")
            .getter(getter(EvaluationFormSingleSelectQuestionAutomation::options))
            .setter(setter(Builder::options))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EvaluationFormSingleSelectQuestionAutomationOption> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(EvaluationFormSingleSelectQuestionAutomationOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_OPTION_REF_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultOptionRefId").getter(getter(EvaluationFormSingleSelectQuestionAutomation::defaultOptionRefId))
            .setter(setter(Builder::defaultOptionRefId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOptionRefId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD,
            DEFAULT_OPTION_REF_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EvaluationFormSingleSelectQuestionAutomationOption> options;

    private final String defaultOptionRefId;

    private EvaluationFormSingleSelectQuestionAutomation(BuilderImpl builder) {
        this.options = builder.options;
        this.defaultOptionRefId = builder.defaultOptionRefId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Options property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOptions() {
        return options != null && !(options instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The automation options of the single select question.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptions} method.
     * </p>
     * 
     * @return The automation options of the single select question.
     */
    public final List<EvaluationFormSingleSelectQuestionAutomationOption> options() {
        return options;
    }

    /**
     * <p>
     * The identifier of the default answer option, when none of the automation options match the criteria.
     * </p>
     * 
     * @return The identifier of the default answer option, when none of the automation options match the criteria.
     */
    public final String defaultOptionRefId() {
        return defaultOptionRefId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasOptions() ? options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultOptionRefId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationFormSingleSelectQuestionAutomation)) {
            return false;
        }
        EvaluationFormSingleSelectQuestionAutomation other = (EvaluationFormSingleSelectQuestionAutomation) obj;
        return hasOptions() == other.hasOptions() && Objects.equals(options(), other.options())
                && Objects.equals(defaultOptionRefId(), other.defaultOptionRefId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationFormSingleSelectQuestionAutomation").add("Options", hasOptions() ? options() : null)
                .add("DefaultOptionRefId", defaultOptionRefId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "DefaultOptionRefId":
            return Optional.ofNullable(clazz.cast(defaultOptionRefId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluationFormSingleSelectQuestionAutomation, T> g) {
        return obj -> g.apply((EvaluationFormSingleSelectQuestionAutomation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationFormSingleSelectQuestionAutomation> {
        /**
         * <p>
         * The automation options of the single select question.
         * </p>
         * 
         * @param options
         *        The automation options of the single select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Collection<EvaluationFormSingleSelectQuestionAutomationOption> options);

        /**
         * <p>
         * The automation options of the single select question.
         * </p>
         * 
         * @param options
         *        The automation options of the single select question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(EvaluationFormSingleSelectQuestionAutomationOption... options);

        /**
         * <p>
         * The automation options of the single select question.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #options(List<EvaluationFormSingleSelectQuestionAutomationOption>)}.
         * 
         * @param options
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connect.model.EvaluationFormSingleSelectQuestionAutomationOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(java.util.Collection<EvaluationFormSingleSelectQuestionAutomationOption>)
         */
        Builder options(Consumer<EvaluationFormSingleSelectQuestionAutomationOption.Builder>... options);

        /**
         * <p>
         * The identifier of the default answer option, when none of the automation options match the criteria.
         * </p>
         * 
         * @param defaultOptionRefId
         *        The identifier of the default answer option, when none of the automation options match the criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOptionRefId(String defaultOptionRefId);
    }

    static final class BuilderImpl implements Builder {
        private List<EvaluationFormSingleSelectQuestionAutomationOption> options = DefaultSdkAutoConstructList.getInstance();

        private String defaultOptionRefId;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationFormSingleSelectQuestionAutomation model) {
            options(model.options);
            defaultOptionRefId(model.defaultOptionRefId);
        }

        public final List<EvaluationFormSingleSelectQuestionAutomationOption.Builder> getOptions() {
            List<EvaluationFormSingleSelectQuestionAutomationOption.Builder> result = EvaluationFormSingleSelectQuestionAutomationOptionListCopier
                    .copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<EvaluationFormSingleSelectQuestionAutomationOption.BuilderImpl> options) {
            this.options = EvaluationFormSingleSelectQuestionAutomationOptionListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<EvaluationFormSingleSelectQuestionAutomationOption> options) {
            this.options = EvaluationFormSingleSelectQuestionAutomationOptionListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(EvaluationFormSingleSelectQuestionAutomationOption... options) {
            options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<EvaluationFormSingleSelectQuestionAutomationOption.Builder>... options) {
            options(Stream.of(options)
                    .map(c -> EvaluationFormSingleSelectQuestionAutomationOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDefaultOptionRefId() {
            return defaultOptionRefId;
        }

        public final void setDefaultOptionRefId(String defaultOptionRefId) {
            this.defaultOptionRefId = defaultOptionRefId;
        }

        @Override
        public final Builder defaultOptionRefId(String defaultOptionRefId) {
            this.defaultOptionRefId = defaultOptionRefId;
            return this;
        }

        @Override
        public EvaluationFormSingleSelectQuestionAutomation build() {
            return new EvaluationFormSingleSelectQuestionAutomation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
