/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the data for a real-time metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CurrentMetricData implements SdkPojo, Serializable,
        ToCopyableBuilder<CurrentMetricData.Builder, CurrentMetricData> {
    private static final SdkField<CurrentMetric> METRIC_FIELD = SdkField.<CurrentMetric> builder(MarshallingType.SDK_POJO)
            .memberName("Metric").getter(getter(CurrentMetricData::metric)).setter(setter(Builder::metric))
            .constructor(CurrentMetric::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(CurrentMetricData::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final CurrentMetric metric;

    private final Double value;

    private CurrentMetricData(BuilderImpl builder) {
        this.metric = builder.metric;
        this.value = builder.value;
    }

    /**
     * <p>
     * Information about the metric.
     * </p>
     * 
     * @return Information about the metric.
     */
    public final CurrentMetric metric() {
        return metric;
    }

    /**
     * <p>
     * The value of the metric.
     * </p>
     * 
     * @return The value of the metric.
     */
    public final Double value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CurrentMetricData)) {
            return false;
        }
        CurrentMetricData other = (CurrentMetricData) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CurrentMetricData").add("Metric", metric()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CurrentMetricData, T> g) {
        return obj -> g.apply((CurrentMetricData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CurrentMetricData> {
        /**
         * <p>
         * Information about the metric.
         * </p>
         * 
         * @param metric
         *        Information about the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(CurrentMetric metric);

        /**
         * <p>
         * Information about the metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link CurrentMetric.Builder} avoiding the need
         * to create one manually via {@link CurrentMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CurrentMetric.Builder#build()} is called immediately and its
         * result is passed to {@link #metric(CurrentMetric)}.
         * 
         * @param metric
         *        a consumer that will call methods on {@link CurrentMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metric(CurrentMetric)
         */
        default Builder metric(Consumer<CurrentMetric.Builder> metric) {
            return metric(CurrentMetric.builder().applyMutation(metric).build());
        }

        /**
         * <p>
         * The value of the metric.
         * </p>
         * 
         * @param value
         *        The value of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);
    }

    static final class BuilderImpl implements Builder {
        private CurrentMetric metric;

        private Double value;

        private BuilderImpl() {
        }

        private BuilderImpl(CurrentMetricData model) {
            metric(model.metric);
            value(model.value);
        }

        public final CurrentMetric.Builder getMetric() {
            return metric != null ? metric.toBuilder() : null;
        }

        public final void setMetric(CurrentMetric.BuilderImpl metric) {
            this.metric = metric != null ? metric.build() : null;
        }

        @Override
        public final Builder metric(CurrentMetric metric) {
            this.metric = metric;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        @Override
        public CurrentMetricData build() {
            return new CurrentMetricData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
