/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateViewVersionRequest extends ConnectRequest implements
        ToCopyableBuilder<CreateViewVersionRequest.Builder, CreateViewVersionRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(CreateViewVersionRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("InstanceId").build()).build();

    private static final SdkField<String> VIEW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ViewId")
            .getter(getter(CreateViewVersionRequest::viewId)).setter(setter(Builder::viewId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ViewId").build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(CreateViewVersionRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<String> VIEW_CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ViewContentSha256").getter(getter(CreateViewVersionRequest::viewContentSha256))
            .setter(setter(Builder::viewContentSha256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewContentSha256").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            VIEW_ID_FIELD, VERSION_DESCRIPTION_FIELD, VIEW_CONTENT_SHA256_FIELD));

    private final String instanceId;

    private final String viewId;

    private final String versionDescription;

    private final String viewContentSha256;

    private CreateViewVersionRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.viewId = builder.viewId;
        this.versionDescription = builder.versionDescription;
        this.viewContentSha256 = builder.viewContentSha256;
    }

    /**
     * <p>
     * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     * </p>
     * 
     * @return The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
     * </p>
     * 
     * @return The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
     */
    public final String viewId() {
        return viewId;
    }

    /**
     * <p>
     * The description for the version being published.
     * </p>
     * 
     * @return The description for the version being published.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * Indicates the checksum value of the latest published view content.
     * </p>
     * 
     * @return Indicates the checksum value of the latest published view content.
     */
    public final String viewContentSha256() {
        return viewContentSha256;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(viewId());
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(viewContentSha256());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateViewVersionRequest)) {
            return false;
        }
        CreateViewVersionRequest other = (CreateViewVersionRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(viewId(), other.viewId())
                && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(viewContentSha256(), other.viewContentSha256());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateViewVersionRequest").add("InstanceId", instanceId()).add("ViewId", viewId())
                .add("VersionDescription", versionDescription()).add("ViewContentSha256", viewContentSha256()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "ViewId":
            return Optional.ofNullable(clazz.cast(viewId()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "ViewContentSha256":
            return Optional.ofNullable(clazz.cast(viewContentSha256()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateViewVersionRequest, T> g) {
        return obj -> g.apply((CreateViewVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateViewVersionRequest> {
        /**
         * <p>
         * The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
         * </p>
         * 
         * @param viewId
         *        The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewId(String viewId);

        /**
         * <p>
         * The description for the version being published.
         * </p>
         * 
         * @param versionDescription
         *        The description for the version being published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * Indicates the checksum value of the latest published view content.
         * </p>
         * 
         * @param viewContentSha256
         *        Indicates the checksum value of the latest published view content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewContentSha256(String viewContentSha256);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectRequest.BuilderImpl implements Builder {
        private String instanceId;

        private String viewId;

        private String versionDescription;

        private String viewContentSha256;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateViewVersionRequest model) {
            super(model);
            instanceId(model.instanceId);
            viewId(model.viewId);
            versionDescription(model.versionDescription);
            viewContentSha256(model.viewContentSha256);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getViewId() {
            return viewId;
        }

        public final void setViewId(String viewId) {
            this.viewId = viewId;
        }

        @Override
        public final Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final String getViewContentSha256() {
            return viewContentSha256;
        }

        public final void setViewContentSha256(String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
        }

        @Override
        public final Builder viewContentSha256(String viewContentSha256) {
            this.viewContentSha256 = viewContentSha256;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateViewVersionRequest build() {
            return new CreateViewVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
