/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The system identified one of the following warnings while processing the input document:
 * </p>
 * <ul>
 * <li>
 * <p>
 * The document to classify is plain text, but the classifier is a native model.
 * </p>
 * </li>
 * <li>
 * <p>
 * The document to classify is semi-structured, but the classifier is a plain-text model.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarningsListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<WarningsListItem.Builder, WarningsListItem> {
    private static final SdkField<Integer> PAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Page")
            .getter(getter(WarningsListItem::page)).setter(setter(Builder::page))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Page").build()).build();

    private static final SdkField<String> WARN_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarnCode").getter(getter(WarningsListItem::warnCodeAsString)).setter(setter(Builder::warnCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarnCode").build()).build();

    private static final SdkField<String> WARN_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WarnMessage").getter(getter(WarningsListItem::warnMessage)).setter(setter(Builder::warnMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WarnMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_FIELD, WARN_CODE_FIELD,
            WARN_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer page;

    private final String warnCode;

    private final String warnMessage;

    private WarningsListItem(BuilderImpl builder) {
        this.page = builder.page;
        this.warnCode = builder.warnCode;
        this.warnMessage = builder.warnMessage;
    }

    /**
     * <p>
     * Page number in the input document.
     * </p>
     * 
     * @return Page number in the input document.
     */
    public final Integer page() {
        return page;
    }

    /**
     * <p>
     * The type of warning.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warnCode} will
     * return {@link PageBasedWarningCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #warnCodeAsString}.
     * </p>
     * 
     * @return The type of warning.
     * @see PageBasedWarningCode
     */
    public final PageBasedWarningCode warnCode() {
        return PageBasedWarningCode.fromValue(warnCode);
    }

    /**
     * <p>
     * The type of warning.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #warnCode} will
     * return {@link PageBasedWarningCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #warnCodeAsString}.
     * </p>
     * 
     * @return The type of warning.
     * @see PageBasedWarningCode
     */
    public final String warnCodeAsString() {
        return warnCode;
    }

    /**
     * <p>
     * Text message associated with the warning.
     * </p>
     * 
     * @return Text message associated with the warning.
     */
    public final String warnMessage() {
        return warnMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(page());
        hashCode = 31 * hashCode + Objects.hashCode(warnCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(warnMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarningsListItem)) {
            return false;
        }
        WarningsListItem other = (WarningsListItem) obj;
        return Objects.equals(page(), other.page()) && Objects.equals(warnCodeAsString(), other.warnCodeAsString())
                && Objects.equals(warnMessage(), other.warnMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarningsListItem").add("Page", page()).add("WarnCode", warnCodeAsString())
                .add("WarnMessage", warnMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Page":
            return Optional.ofNullable(clazz.cast(page()));
        case "WarnCode":
            return Optional.ofNullable(clazz.cast(warnCodeAsString()));
        case "WarnMessage":
            return Optional.ofNullable(clazz.cast(warnMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WarningsListItem, T> g) {
        return obj -> g.apply((WarningsListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarningsListItem> {
        /**
         * <p>
         * Page number in the input document.
         * </p>
         * 
         * @param page
         *        Page number in the input document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder page(Integer page);

        /**
         * <p>
         * The type of warning.
         * </p>
         * 
         * @param warnCode
         *        The type of warning.
         * @see PageBasedWarningCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PageBasedWarningCode
         */
        Builder warnCode(String warnCode);

        /**
         * <p>
         * The type of warning.
         * </p>
         * 
         * @param warnCode
         *        The type of warning.
         * @see PageBasedWarningCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PageBasedWarningCode
         */
        Builder warnCode(PageBasedWarningCode warnCode);

        /**
         * <p>
         * Text message associated with the warning.
         * </p>
         * 
         * @param warnMessage
         *        Text message associated with the warning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnMessage(String warnMessage);
    }

    static final class BuilderImpl implements Builder {
        private Integer page;

        private String warnCode;

        private String warnMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(WarningsListItem model) {
            page(model.page);
            warnCode(model.warnCode);
            warnMessage(model.warnMessage);
        }

        public final Integer getPage() {
            return page;
        }

        public final void setPage(Integer page) {
            this.page = page;
        }

        @Override
        public final Builder page(Integer page) {
            this.page = page;
            return this;
        }

        public final String getWarnCode() {
            return warnCode;
        }

        public final void setWarnCode(String warnCode) {
            this.warnCode = warnCode;
        }

        @Override
        public final Builder warnCode(String warnCode) {
            this.warnCode = warnCode;
            return this;
        }

        @Override
        public final Builder warnCode(PageBasedWarningCode warnCode) {
            this.warnCode(warnCode == null ? null : warnCode.toString());
            return this;
        }

        public final String getWarnMessage() {
            return warnMessage;
        }

        public final void setWarnMessage(String warnMessage) {
            this.warnMessage = warnMessage;
        }

        @Override
        public final Builder warnMessage(String warnMessage) {
            this.warnMessage = warnMessage;
            return this;
        }

        @Override
        public WarningsListItem build() {
            return new WarningsListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
