/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request is invalid.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvalidRequestException extends ComprehendException implements
        ToCopyableBuilder<InvalidRequestException.Builder, InvalidRequestException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(InvalidRequestException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<InvalidRequestDetail> DETAIL_FIELD = SdkField
            .<InvalidRequestDetail> builder(MarshallingType.SDK_POJO).memberName("Detail")
            .getter(getter(InvalidRequestException::detail)).setter(setter(Builder::detail))
            .constructor(InvalidRequestDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD, DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final InvalidRequestDetail detail;

    private InvalidRequestException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.detail = builder.detail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link InvalidRequestReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see InvalidRequestReason
     */
    public InvalidRequestReason reason() {
        return InvalidRequestReason.fromValue(reason);
    }

    /**
     * Returns the value of the Reason property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link InvalidRequestReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return The value of the Reason property for this object.
     * @see InvalidRequestReason
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * Returns the value of the Detail property for this object.
     * 
     * @return The value of the Detail property for this object.
     */
    public InvalidRequestDetail detail() {
        return detail;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestException, T> g) {
        return obj -> g.apply((InvalidRequestException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvalidRequestException>, ComprehendException.Builder {
        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see InvalidRequestReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidRequestReason
         */
        Builder reason(String reason);

        /**
         * Sets the value of the Reason property for this object.
         *
         * @param reason
         *        The new value for the Reason property for this object.
         * @see InvalidRequestReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InvalidRequestReason
         */
        Builder reason(InvalidRequestReason reason);

        /**
         * Sets the value of the Detail property for this object.
         *
         * @param detail
         *        The new value for the Detail property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(InvalidRequestDetail detail);

        /**
         * Sets the value of the Detail property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InvalidRequestDetail.Builder} avoiding
         * the need to create one manually via {@link InvalidRequestDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvalidRequestDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #detail(InvalidRequestDetail)}.
         * 
         * @param detail
         *        a consumer that will call methods on {@link InvalidRequestDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #detail(InvalidRequestDetail)
         */
        default Builder detail(Consumer<InvalidRequestDetail.Builder> detail) {
            return detail(InvalidRequestDetail.builder().applyMutation(detail).build());
        }

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends ComprehendException.BuilderImpl implements Builder {
        private String reason;

        private InvalidRequestDetail detail;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestException model) {
            super(model);
            reason(model.reason);
            detail(model.detail);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(InvalidRequestReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final InvalidRequestDetail.Builder getDetail() {
            return detail != null ? detail.toBuilder() : null;
        }

        public final void setDetail(InvalidRequestDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(InvalidRequestDetail detail) {
            this.detail = detail;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public InvalidRequestException build() {
            return new InvalidRequestException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
