/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the dataset input data configuration for a document classifier model.
 * </p>
 * <p>
 * For more information on how the input file is formatted, see <a
 * href="https://docs.aws.amazon.com/comprehend/latest/dg/prep-classifier-data.html">Preparing training data</a> in the
 * Comprehend Developer Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatasetDocumentClassifierInputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DatasetDocumentClassifierInputDataConfig.Builder, DatasetDocumentClassifierInputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(DatasetDocumentClassifierInputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> LABEL_DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelDelimiter").getter(getter(DatasetDocumentClassifierInputDataConfig::labelDelimiter))
            .setter(setter(Builder::labelDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelDelimiter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            LABEL_DELIMITER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String labelDelimiter;

    private DatasetDocumentClassifierInputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.labelDelimiter = builder.labelDelimiter;
    }

    /**
     * <p>
     * The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you are
     * calling. The URI can point to a single input file or it can provide the prefix for a collection of input files.
     * </p>
     * <p>
     * For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon
     * Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all of
     * them as input.
     * </p>
     * <p>
     * This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.
     * </p>
     * 
     * @return The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that
     *         you are calling. The URI can point to a single input file or it can provide the prefix for a collection
     *         of input files.</p>
     *         <p>
     *         For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file,
     *         Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon
     *         Comprehend uses all of them as input.
     *         </p>
     *         <p>
     *         This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Indicates the delimiter used to separate each label for training a multi-label classifier. The default delimiter
     * between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed character) by
     * specifying it under Delimiter for labels. If the training documents use a delimiter other than the default or the
     * delimiter you specify, the labels on that line will be combined to make a single unique label, such as
     * LABELLABELLABEL.
     * </p>
     * 
     * @return Indicates the delimiter used to separate each label for training a multi-label classifier. The default
     *         delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an
     *         allowed character) by specifying it under Delimiter for labels. If the training documents use a delimiter
     *         other than the default or the delimiter you specify, the labels on that line will be combined to make a
     *         single unique label, such as LABELLABELLABEL.
     */
    public final String labelDelimiter() {
        return labelDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(labelDelimiter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatasetDocumentClassifierInputDataConfig)) {
            return false;
        }
        DatasetDocumentClassifierInputDataConfig other = (DatasetDocumentClassifierInputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(labelDelimiter(), other.labelDelimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatasetDocumentClassifierInputDataConfig").add("S3Uri", s3Uri())
                .add("LabelDelimiter", labelDelimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "LabelDelimiter":
            return Optional.ofNullable(clazz.cast(labelDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DatasetDocumentClassifierInputDataConfig, T> g) {
        return obj -> g.apply((DatasetDocumentClassifierInputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatasetDocumentClassifierInputDataConfig> {
        /**
         * <p>
         * The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint that you
         * are calling. The URI can point to a single input file or it can provide the prefix for a collection of input
         * files.
         * </p>
         * <p>
         * For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file, Amazon
         * Comprehend uses that file as input. If more than one file begins with the prefix, Amazon Comprehend uses all
         * of them as input.
         * </p>
         * <p>
         * This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 URI for the input data. The S3 bucket must be in the same Region as the API endpoint
         *        that you are calling. The URI can point to a single input file or it can provide the prefix for a
         *        collection of input files.</p>
         *        <p>
         *        For example, if you use the URI <code>S3://bucketName/prefix</code>, if the prefix is a single file,
         *        Amazon Comprehend uses that file as input. If more than one file begins with the prefix, Amazon
         *        Comprehend uses all of them as input.
         *        </p>
         *        <p>
         *        This parameter is required if you set <code>DataFormat</code> to <code>COMPREHEND_CSV</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Indicates the delimiter used to separate each label for training a multi-label classifier. The default
         * delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an allowed
         * character) by specifying it under Delimiter for labels. If the training documents use a delimiter other than
         * the default or the delimiter you specify, the labels on that line will be combined to make a single unique
         * label, such as LABELLABELLABEL.
         * </p>
         * 
         * @param labelDelimiter
         *        Indicates the delimiter used to separate each label for training a multi-label classifier. The default
         *        delimiter between labels is a pipe (|). You can use a different character as a delimiter (if it's an
         *        allowed character) by specifying it under Delimiter for labels. If the training documents use a
         *        delimiter other than the default or the delimiter you specify, the labels on that line will be
         *        combined to make a single unique label, such as LABELLABELLABEL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelDelimiter(String labelDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String labelDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(DatasetDocumentClassifierInputDataConfig model) {
            s3Uri(model.s3Uri);
            labelDelimiter(model.labelDelimiter);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getLabelDelimiter() {
            return labelDelimiter;
        }

        public final void setLabelDelimiter(String labelDelimiter) {
            this.labelDelimiter = labelDelimiter;
        }

        @Override
        public final Builder labelDelimiter(String labelDelimiter) {
            this.labelDelimiter = labelDelimiter;
            return this;
        }

        @Override
        public DatasetDocumentClassifierInputDataConfig build() {
            return new DatasetDocumentClassifierInputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
