/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Analysis results for one of the documents in the batch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDetectTargetedSentimentItemResult implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchDetectTargetedSentimentItemResult.Builder, BatchDetectTargetedSentimentItemResult> {
    private static final SdkField<Integer> INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Index")
            .getter(getter(BatchDetectTargetedSentimentItemResult::index)).setter(setter(Builder::index))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()).build();

    private static final SdkField<List<TargetedSentimentEntity>> ENTITIES_FIELD = SdkField
            .<List<TargetedSentimentEntity>> builder(MarshallingType.LIST)
            .memberName("Entities")
            .getter(getter(BatchDetectTargetedSentimentItemResult::entities))
            .setter(setter(Builder::entities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetedSentimentEntity> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetedSentimentEntity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer index;

    private final List<TargetedSentimentEntity> entities;

    private BatchDetectTargetedSentimentItemResult(BuilderImpl builder) {
        this.index = builder.index;
        this.entities = builder.entities;
    }

    /**
     * <p>
     * The zero-based index of this result in the input list.
     * </p>
     * 
     * @return The zero-based index of this result in the input list.
     */
    public final Integer index() {
        return index;
    }

    /**
     * For responses, this returns true if the service returned a value for the Entities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEntities() {
        return entities != null && !(entities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of targeted sentiment entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntities} method.
     * </p>
     * 
     * @return An array of targeted sentiment entities.
     */
    public final List<TargetedSentimentEntity> entities() {
        return entities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(index());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntities() ? entities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDetectTargetedSentimentItemResult)) {
            return false;
        }
        BatchDetectTargetedSentimentItemResult other = (BatchDetectTargetedSentimentItemResult) obj;
        return Objects.equals(index(), other.index()) && hasEntities() == other.hasEntities()
                && Objects.equals(entities(), other.entities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDetectTargetedSentimentItemResult").add("Index", index())
                .add("Entities", hasEntities() ? entities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Index":
            return Optional.ofNullable(clazz.cast(index()));
        case "Entities":
            return Optional.ofNullable(clazz.cast(entities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDetectTargetedSentimentItemResult, T> g) {
        return obj -> g.apply((BatchDetectTargetedSentimentItemResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchDetectTargetedSentimentItemResult> {
        /**
         * <p>
         * The zero-based index of this result in the input list.
         * </p>
         * 
         * @param index
         *        The zero-based index of this result in the input list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(Integer index);

        /**
         * <p>
         * An array of targeted sentiment entities.
         * </p>
         * 
         * @param entities
         *        An array of targeted sentiment entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(Collection<TargetedSentimentEntity> entities);

        /**
         * <p>
         * An array of targeted sentiment entities.
         * </p>
         * 
         * @param entities
         *        An array of targeted sentiment entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entities(TargetedSentimentEntity... entities);

        /**
         * <p>
         * An array of targeted sentiment entities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity.Builder#build()} is called
         * immediately and its result is passed to {@link #entities(List<TargetedSentimentEntity>)}.
         * 
         * @param entities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.comprehend.model.TargetedSentimentEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #entities(java.util.Collection<TargetedSentimentEntity>)
         */
        Builder entities(Consumer<TargetedSentimentEntity.Builder>... entities);
    }

    static final class BuilderImpl implements Builder {
        private Integer index;

        private List<TargetedSentimentEntity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDetectTargetedSentimentItemResult model) {
            index(model.index);
            entities(model.entities);
        }

        public final Integer getIndex() {
            return index;
        }

        public final void setIndex(Integer index) {
            this.index = index;
        }

        @Override
        public final Builder index(Integer index) {
            this.index = index;
            return this;
        }

        public final List<TargetedSentimentEntity.Builder> getEntities() {
            List<TargetedSentimentEntity.Builder> result = ListOfTargetedSentimentEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<TargetedSentimentEntity.BuilderImpl> entities) {
            this.entities = ListOfTargetedSentimentEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<TargetedSentimentEntity> entities) {
            this.entities = ListOfTargetedSentimentEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(TargetedSentimentEntity... entities) {
            entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<TargetedSentimentEntity.Builder>... entities) {
            entities(Stream.of(entities).map(c -> TargetedSentimentEntity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchDetectTargetedSentimentItemResult build() {
            return new BatchDetectTargetedSentimentItemResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
