/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ChallengeNameType {
    SMS_MFA("SMS_MFA"),

    SOFTWARE_TOKEN_MFA("SOFTWARE_TOKEN_MFA"),

    SELECT_MFA_TYPE("SELECT_MFA_TYPE"),

    MFA_SETUP("MFA_SETUP"),

    PASSWORD_VERIFIER("PASSWORD_VERIFIER"),

    CUSTOM_CHALLENGE("CUSTOM_CHALLENGE"),

    DEVICE_SRP_AUTH("DEVICE_SRP_AUTH"),

    DEVICE_PASSWORD_VERIFIER("DEVICE_PASSWORD_VERIFIER"),

    ADMIN_NO_SRP_AUTH("ADMIN_NO_SRP_AUTH"),

    NEW_PASSWORD_REQUIRED("NEW_PASSWORD_REQUIRED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChallengeNameType> VALUE_MAP = EnumUtils.uniqueIndex(ChallengeNameType.class,
            ChallengeNameType::toString);

    private final String value;

    private ChallengeNameType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ChallengeNameType corresponding to the value
     */
    public static ChallengeNameType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ChallengeNameType}s
     */
    public static Set<ChallengeNameType> knownValues() {
        Set<ChallengeNameType> knownValues = EnumSet.allOf(ChallengeNameType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
