/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns a summary of a pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineSummary implements SdkPojo, Serializable, ToCopyableBuilder<PipelineSummary.Builder, PipelineSummary> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(PipelineSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("version").getter(getter(PipelineSummary::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("created").getter(getter(PipelineSummary::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("created").build()).build();

    private static final SdkField<Instant> UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updated").getter(getter(PipelineSummary::updated)).setter(setter(Builder::updated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updated").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_FIELD,
            CREATED_FIELD, UPDATED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Integer version;

    private final Instant created;

    private final Instant updated;

    private PipelineSummary(BuilderImpl builder) {
        this.name = builder.name;
        this.version = builder.version;
        this.created = builder.created;
        this.updated = builder.updated;
    }

    /**
     * <p>
     * The name of the pipeline.
     * </p>
     * 
     * @return The name of the pipeline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version number of the pipeline.
     * </p>
     * 
     * @return The version number of the pipeline.
     */
    public final Integer version() {
        return version;
    }

    /**
     * <p>
     * The date and time the pipeline was created, in timestamp format.
     * </p>
     * 
     * @return The date and time the pipeline was created, in timestamp format.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time of the last update to the pipeline, in timestamp format.
     * </p>
     * 
     * @return The date and time of the last update to the pipeline, in timestamp format.
     */
    public final Instant updated() {
        return updated;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(updated());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineSummary)) {
            return false;
        }
        PipelineSummary other = (PipelineSummary) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(created(), other.created()) && Objects.equals(updated(), other.updated());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineSummary").add("Name", name()).add("Version", version()).add("Created", created())
                .add("Updated", updated()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "created":
            return Optional.ofNullable(clazz.cast(created()));
        case "updated":
            return Optional.ofNullable(clazz.cast(updated()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineSummary, T> g) {
        return obj -> g.apply((PipelineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineSummary> {
        /**
         * <p>
         * The name of the pipeline.
         * </p>
         * 
         * @param name
         *        The name of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version number of the pipeline.
         * </p>
         * 
         * @param version
         *        The version number of the pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(Integer version);

        /**
         * <p>
         * The date and time the pipeline was created, in timestamp format.
         * </p>
         * 
         * @param created
         *        The date and time the pipeline was created, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time of the last update to the pipeline, in timestamp format.
         * </p>
         * 
         * @param updated
         *        The date and time of the last update to the pipeline, in timestamp format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updated(Instant updated);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Integer version;

        private Instant created;

        private Instant updated;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineSummary model) {
            name(model.name);
            version(model.version);
            created(model.created);
            updated(model.updated);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getVersion() {
            return version;
        }

        public final void setVersion(Integer version) {
            this.version = version;
        }

        @Override
        public final Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getUpdated() {
            return updated;
        }

        public final void setUpdated(Instant updated) {
            this.updated = updated;
        }

        @Override
        public final Builder updated(Instant updated) {
            this.updated = updated;
            return this;
        }

        @Override
        public PipelineSummary build() {
            return new PipelineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
