/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoriesForApprovalRuleTemplateResponse extends CodeCommitResponse
        implements
        ToCopyableBuilder<ListRepositoriesForApprovalRuleTemplateResponse.Builder, ListRepositoriesForApprovalRuleTemplateResponse> {
    private static final SdkField<List<String>> REPOSITORY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("repositoryNames")
            .getter(getter(ListRepositoriesForApprovalRuleTemplateResponse::repositoryNames))
            .setter(setter(Builder::repositoryNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositoriesForApprovalRuleTemplateResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAMES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<String> repositoryNames;

    private final String nextToken;

    private ListRepositoriesForApprovalRuleTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryNames = builder.repositoryNames;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RepositoryNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRepositoryNames() {
        return repositoryNames != null && !(repositoryNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of repository names that are associated with the specified approval rule template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRepositoryNames} method.
     * </p>
     * 
     * @return A list of repository names that are associated with the specified approval rule template.
     */
    public final List<String> repositoryNames() {
        return repositoryNames;
    }

    /**
     * <p>
     * An enumeration token that allows the operation to batch the next results of the operation.
     * </p>
     * 
     * @return An enumeration token that allows the operation to batch the next results of the operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRepositoryNames() ? repositoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesForApprovalRuleTemplateResponse)) {
            return false;
        }
        ListRepositoriesForApprovalRuleTemplateResponse other = (ListRepositoriesForApprovalRuleTemplateResponse) obj;
        return hasRepositoryNames() == other.hasRepositoryNames() && Objects.equals(repositoryNames(), other.repositoryNames())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositoriesForApprovalRuleTemplateResponse")
                .add("RepositoryNames", hasRepositoryNames() ? repositoryNames() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "repositoryNames":
            return Optional.ofNullable(clazz.cast(repositoryNames()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesForApprovalRuleTemplateResponse, T> g) {
        return obj -> g.apply((ListRepositoriesForApprovalRuleTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRepositoriesForApprovalRuleTemplateResponse> {
        /**
         * <p>
         * A list of repository names that are associated with the specified approval rule template.
         * </p>
         * 
         * @param repositoryNames
         *        A list of repository names that are associated with the specified approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(Collection<String> repositoryNames);

        /**
         * <p>
         * A list of repository names that are associated with the specified approval rule template.
         * </p>
         * 
         * @param repositoryNames
         *        A list of repository names that are associated with the specified approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryNames(String... repositoryNames);

        /**
         * <p>
         * An enumeration token that allows the operation to batch the next results of the operation.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that allows the operation to batch the next results of the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private List<String> repositoryNames = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesForApprovalRuleTemplateResponse model) {
            super(model);
            repositoryNames(model.repositoryNames);
            nextToken(model.nextToken);
        }

        public final Collection<String> getRepositoryNames() {
            if (repositoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return repositoryNames;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String... repositoryNames) {
            repositoryNames(Arrays.asList(repositoryNames));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRepositoriesForApprovalRuleTemplateResponse build() {
            return new ListRepositoriesForApprovalRuleTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
