/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFolderResponse extends CodeCommitResponse implements
        ToCopyableBuilder<GetFolderResponse.Builder, GetFolderResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("commitId").getter(getter(GetFolderResponse::commitId)).setter(setter(Builder::commitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()).build();

    private static final SdkField<String> FOLDER_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("folderPath").getter(getter(GetFolderResponse::folderPath)).setter(setter(Builder::folderPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("folderPath").build()).build();

    private static final SdkField<String> TREE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("treeId")
            .getter(getter(GetFolderResponse::treeId)).setter(setter(Builder::treeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()).build();

    private static final SdkField<List<Folder>> SUB_FOLDERS_FIELD = SdkField
            .<List<Folder>> builder(MarshallingType.LIST)
            .memberName("subFolders")
            .getter(getter(GetFolderResponse::subFolders))
            .setter(setter(Builder::subFolders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subFolders").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Folder> builder(MarshallingType.SDK_POJO)
                                            .constructor(Folder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<File>> FILES_FIELD = SdkField
            .<List<File>> builder(MarshallingType.LIST)
            .memberName("files")
            .getter(getter(GetFolderResponse::files))
            .setter(setter(Builder::files))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<File> builder(MarshallingType.SDK_POJO)
                                            .constructor(File::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SymbolicLink>> SYMBOLIC_LINKS_FIELD = SdkField
            .<List<SymbolicLink>> builder(MarshallingType.LIST)
            .memberName("symbolicLinks")
            .getter(getter(GetFolderResponse::symbolicLinks))
            .setter(setter(Builder::symbolicLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("symbolicLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SymbolicLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(SymbolicLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SubModule>> SUB_MODULES_FIELD = SdkField
            .<List<SubModule>> builder(MarshallingType.LIST)
            .memberName("subModules")
            .getter(getter(GetFolderResponse::subModules))
            .setter(setter(Builder::subModules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subModules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubModule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubModule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD,
            FOLDER_PATH_FIELD, TREE_ID_FIELD, SUB_FOLDERS_FIELD, FILES_FIELD, SYMBOLIC_LINKS_FIELD, SUB_MODULES_FIELD));

    private final String commitId;

    private final String folderPath;

    private final String treeId;

    private final List<Folder> subFolders;

    private final List<File> files;

    private final List<SymbolicLink> symbolicLinks;

    private final List<SubModule> subModules;

    private GetFolderResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.folderPath = builder.folderPath;
        this.treeId = builder.treeId;
        this.subFolders = builder.subFolders;
        this.files = builder.files;
        this.symbolicLinks = builder.symbolicLinks;
        this.subModules = builder.subModules;
    }

    /**
     * <p>
     * The full commit ID used as a reference for the returned version of the folder content.
     * </p>
     * 
     * @return The full commit ID used as a reference for the returned version of the folder content.
     */
    public final String commitId() {
        return commitId;
    }

    /**
     * <p>
     * The fully qualified path of the folder whose contents are returned.
     * </p>
     * 
     * @return The fully qualified path of the folder whose contents are returned.
     */
    public final String folderPath() {
        return folderPath;
    }

    /**
     * <p>
     * The full SHA-1 pointer of the tree information for the commit that contains the folder.
     * </p>
     * 
     * @return The full SHA-1 pointer of the tree information for the commit that contains the folder.
     */
    public final String treeId() {
        return treeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubFolders property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubFolders() {
        return subFolders != null && !(subFolders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of folders that exist under the specified folder, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubFolders} method.
     * </p>
     * 
     * @return The list of folders that exist under the specified folder, if any.
     */
    public final List<Folder> subFolders() {
        return subFolders;
    }

    /**
     * For responses, this returns true if the service returned a value for the Files property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasFiles() {
        return files != null && !(files instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of files in the specified folder, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFiles} method.
     * </p>
     * 
     * @return The list of files in the specified folder, if any.
     */
    public final List<File> files() {
        return files;
    }

    /**
     * For responses, this returns true if the service returned a value for the SymbolicLinks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSymbolicLinks() {
        return symbolicLinks != null && !(symbolicLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of symbolic links to other files and folders in the specified folder, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSymbolicLinks} method.
     * </p>
     * 
     * @return The list of symbolic links to other files and folders in the specified folder, if any.
     */
    public final List<SymbolicLink> symbolicLinks() {
        return symbolicLinks;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubModules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSubModules() {
        return subModules != null && !(subModules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of submodules in the specified folder, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubModules} method.
     * </p>
     * 
     * @return The list of submodules in the specified folder, if any.
     */
    public final List<SubModule> subModules() {
        return subModules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commitId());
        hashCode = 31 * hashCode + Objects.hashCode(folderPath());
        hashCode = 31 * hashCode + Objects.hashCode(treeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubFolders() ? subFolders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFiles() ? files() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSymbolicLinks() ? symbolicLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubModules() ? subModules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFolderResponse)) {
            return false;
        }
        GetFolderResponse other = (GetFolderResponse) obj;
        return Objects.equals(commitId(), other.commitId()) && Objects.equals(folderPath(), other.folderPath())
                && Objects.equals(treeId(), other.treeId()) && hasSubFolders() == other.hasSubFolders()
                && Objects.equals(subFolders(), other.subFolders()) && hasFiles() == other.hasFiles()
                && Objects.equals(files(), other.files()) && hasSymbolicLinks() == other.hasSymbolicLinks()
                && Objects.equals(symbolicLinks(), other.symbolicLinks()) && hasSubModules() == other.hasSubModules()
                && Objects.equals(subModules(), other.subModules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFolderResponse").add("CommitId", commitId()).add("FolderPath", folderPath())
                .add("TreeId", treeId()).add("SubFolders", hasSubFolders() ? subFolders() : null)
                .add("Files", hasFiles() ? files() : null).add("SymbolicLinks", hasSymbolicLinks() ? symbolicLinks() : null)
                .add("SubModules", hasSubModules() ? subModules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "commitId":
            return Optional.ofNullable(clazz.cast(commitId()));
        case "folderPath":
            return Optional.ofNullable(clazz.cast(folderPath()));
        case "treeId":
            return Optional.ofNullable(clazz.cast(treeId()));
        case "subFolders":
            return Optional.ofNullable(clazz.cast(subFolders()));
        case "files":
            return Optional.ofNullable(clazz.cast(files()));
        case "symbolicLinks":
            return Optional.ofNullable(clazz.cast(symbolicLinks()));
        case "subModules":
            return Optional.ofNullable(clazz.cast(subModules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFolderResponse, T> g) {
        return obj -> g.apply((GetFolderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFolderResponse> {
        /**
         * <p>
         * The full commit ID used as a reference for the returned version of the folder content.
         * </p>
         * 
         * @param commitId
         *        The full commit ID used as a reference for the returned version of the folder content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitId(String commitId);

        /**
         * <p>
         * The fully qualified path of the folder whose contents are returned.
         * </p>
         * 
         * @param folderPath
         *        The fully qualified path of the folder whose contents are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderPath(String folderPath);

        /**
         * <p>
         * The full SHA-1 pointer of the tree information for the commit that contains the folder.
         * </p>
         * 
         * @param treeId
         *        The full SHA-1 pointer of the tree information for the commit that contains the folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder treeId(String treeId);

        /**
         * <p>
         * The list of folders that exist under the specified folder, if any.
         * </p>
         * 
         * @param subFolders
         *        The list of folders that exist under the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subFolders(Collection<Folder> subFolders);

        /**
         * <p>
         * The list of folders that exist under the specified folder, if any.
         * </p>
         * 
         * @param subFolders
         *        The list of folders that exist under the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subFolders(Folder... subFolders);

        /**
         * <p>
         * The list of folders that exist under the specified folder, if any.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.Folder.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.Folder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.Folder.Builder#build()} is called immediately and its
         * result is passed to {@link #subFolders(List<Folder>)}.
         * 
         * @param subFolders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.Folder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subFolders(java.util.Collection<Folder>)
         */
        Builder subFolders(Consumer<Folder.Builder>... subFolders);

        /**
         * <p>
         * The list of files in the specified folder, if any.
         * </p>
         * 
         * @param files
         *        The list of files in the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(Collection<File> files);

        /**
         * <p>
         * The list of files in the specified folder, if any.
         * </p>
         * 
         * @param files
         *        The list of files in the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder files(File... files);

        /**
         * <p>
         * The list of files in the specified folder, if any.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.File.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.File#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.File.Builder#build()} is called immediately and its
         * result is passed to {@link #files(List<File>)}.
         * 
         * @param files
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.File.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #files(java.util.Collection<File>)
         */
        Builder files(Consumer<File.Builder>... files);

        /**
         * <p>
         * The list of symbolic links to other files and folders in the specified folder, if any.
         * </p>
         * 
         * @param symbolicLinks
         *        The list of symbolic links to other files and folders in the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder symbolicLinks(Collection<SymbolicLink> symbolicLinks);

        /**
         * <p>
         * The list of symbolic links to other files and folders in the specified folder, if any.
         * </p>
         * 
         * @param symbolicLinks
         *        The list of symbolic links to other files and folders in the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder symbolicLinks(SymbolicLink... symbolicLinks);

        /**
         * <p>
         * The list of symbolic links to other files and folders in the specified folder, if any.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.SymbolicLink.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.SymbolicLink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.SymbolicLink.Builder#build()} is called immediately
         * and its result is passed to {@link #symbolicLinks(List<SymbolicLink>)}.
         * 
         * @param symbolicLinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.SymbolicLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #symbolicLinks(java.util.Collection<SymbolicLink>)
         */
        Builder symbolicLinks(Consumer<SymbolicLink.Builder>... symbolicLinks);

        /**
         * <p>
         * The list of submodules in the specified folder, if any.
         * </p>
         * 
         * @param subModules
         *        The list of submodules in the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subModules(Collection<SubModule> subModules);

        /**
         * <p>
         * The list of submodules in the specified folder, if any.
         * </p>
         * 
         * @param subModules
         *        The list of submodules in the specified folder, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subModules(SubModule... subModules);

        /**
         * <p>
         * The list of submodules in the specified folder, if any.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codecommit.model.SubModule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.codecommit.model.SubModule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codecommit.model.SubModule.Builder#build()} is called immediately and
         * its result is passed to {@link #subModules(List<SubModule>)}.
         * 
         * @param subModules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codecommit.model.SubModule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subModules(java.util.Collection<SubModule>)
         */
        Builder subModules(Consumer<SubModule.Builder>... subModules);
    }

    static final class BuilderImpl extends CodeCommitResponse.BuilderImpl implements Builder {
        private String commitId;

        private String folderPath;

        private String treeId;

        private List<Folder> subFolders = DefaultSdkAutoConstructList.getInstance();

        private List<File> files = DefaultSdkAutoConstructList.getInstance();

        private List<SymbolicLink> symbolicLinks = DefaultSdkAutoConstructList.getInstance();

        private List<SubModule> subModules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFolderResponse model) {
            super(model);
            commitId(model.commitId);
            folderPath(model.folderPath);
            treeId(model.treeId);
            subFolders(model.subFolders);
            files(model.files);
            symbolicLinks(model.symbolicLinks);
            subModules(model.subModules);
        }

        public final String getCommitId() {
            return commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getFolderPath() {
            return folderPath;
        }

        public final void setFolderPath(String folderPath) {
            this.folderPath = folderPath;
        }

        @Override
        public final Builder folderPath(String folderPath) {
            this.folderPath = folderPath;
            return this;
        }

        public final String getTreeId() {
            return treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final List<Folder.Builder> getSubFolders() {
            List<Folder.Builder> result = FolderListCopier.copyToBuilder(this.subFolders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubFolders(Collection<Folder.BuilderImpl> subFolders) {
            this.subFolders = FolderListCopier.copyFromBuilder(subFolders);
        }

        @Override
        public final Builder subFolders(Collection<Folder> subFolders) {
            this.subFolders = FolderListCopier.copy(subFolders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subFolders(Folder... subFolders) {
            subFolders(Arrays.asList(subFolders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subFolders(Consumer<Folder.Builder>... subFolders) {
            subFolders(Stream.of(subFolders).map(c -> Folder.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<File.Builder> getFiles() {
            List<File.Builder> result = FileListCopier.copyToBuilder(this.files);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFiles(Collection<File.BuilderImpl> files) {
            this.files = FileListCopier.copyFromBuilder(files);
        }

        @Override
        public final Builder files(Collection<File> files) {
            this.files = FileListCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(File... files) {
            files(Arrays.asList(files));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(Consumer<File.Builder>... files) {
            files(Stream.of(files).map(c -> File.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SymbolicLink.Builder> getSymbolicLinks() {
            List<SymbolicLink.Builder> result = SymbolicLinkListCopier.copyToBuilder(this.symbolicLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSymbolicLinks(Collection<SymbolicLink.BuilderImpl> symbolicLinks) {
            this.symbolicLinks = SymbolicLinkListCopier.copyFromBuilder(symbolicLinks);
        }

        @Override
        public final Builder symbolicLinks(Collection<SymbolicLink> symbolicLinks) {
            this.symbolicLinks = SymbolicLinkListCopier.copy(symbolicLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder symbolicLinks(SymbolicLink... symbolicLinks) {
            symbolicLinks(Arrays.asList(symbolicLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder symbolicLinks(Consumer<SymbolicLink.Builder>... symbolicLinks) {
            symbolicLinks(Stream.of(symbolicLinks).map(c -> SymbolicLink.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<SubModule.Builder> getSubModules() {
            List<SubModule.Builder> result = SubModuleListCopier.copyToBuilder(this.subModules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubModules(Collection<SubModule.BuilderImpl> subModules) {
            this.subModules = SubModuleListCopier.copyFromBuilder(subModules);
        }

        @Override
        public final Builder subModules(Collection<SubModule> subModules) {
            this.subModules = SubModuleListCopier.copy(subModules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subModules(SubModule... subModules) {
            subModules(Arrays.asList(subModules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subModules(Consumer<SubModule.Builder>... subModules) {
            subModules(Stream.of(subModules).map(c -> SubModule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetFolderResponse build() {
            return new GetFolderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
