/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutAccountPolicyRequest extends CloudWatchLogsRequest implements
        ToCopyableBuilder<PutAccountPolicyRequest.Builder, PutAccountPolicyRequest> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(PutAccountPolicyRequest::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(PutAccountPolicyRequest::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyType").getter(getter(PutAccountPolicyRequest::policyTypeAsString))
            .setter(setter(Builder::policyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()).build();

    private static final SdkField<String> SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("scope")
            .getter(getter(PutAccountPolicyRequest::scopeAsString)).setter(setter(Builder::scope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scope").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_DOCUMENT_FIELD, POLICY_TYPE_FIELD, SCOPE_FIELD));

    private final String policyName;

    private final String policyDocument;

    private final String policyType;

    private final String scope;

    private PutAccountPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
        this.policyType = builder.policyType;
        this.scope = builder.scope;
    }

    /**
     * <p>
     * A name for the policy. This must be unique within the account.
     * </p>
     * 
     * @return A name for the policy. This must be unique within the account.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * Specify the data protection policy, in JSON.
     * </p>
     * <p>
     * This policy must include two JSON blocks:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with
     * an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of sensitive data that you
     * want to mask. For more information about the available options, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types of data
     * that you can mask</a>.
     * </p>
     * <p>
     * The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive data
     * terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You can optionally
     * use that <code>FindingsDestination</code> object to list one or more destinations to send audit findings to. If
     * you specify destinations such as log groups, Kinesis Data Firehose streams, and S3 buckets, they must already
     * exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property with
     * an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match the
     * <code>DataIdentifer</code> array in the first block of the policy.
     * </p>
     * <p>
     * The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the data, and
     * it must contain the <code> "MaskConfig": {}</code> object. The <code> "MaskConfig": {}</code> object must be
     * empty.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For an example data protection policy, see the <b>Examples</b> section on this page.
     * </p>
     * <important>
     * <p>
     * The contents of the two <code>DataIdentifer</code> arrays must match exactly.
     * </p>
     * </important>
     * <p>
     * In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>,
     * <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is different than the
     * operation's <code>policyName</code> parameter, and is used as a dimension when CloudWatch Logs reports audit
     * findings metrics to CloudWatch.
     * </p>
     * <p>
     * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
     * </p>
     * 
     * @return Specify the data protection policy, in JSON.</p>
     *         <p>
     *         This policy must include two JSON blocks:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
     *         property with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of
     *         sensitive data that you want to mask. For more information about the available options, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types
     *         of data that you can mask</a>.
     *         </p>
     *         <p>
     *         The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive
     *         data terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You
     *         can optionally use that <code>FindingsDestination</code> object to list one or more destinations to send
     *         audit findings to. If you specify destinations such as log groups, Kinesis Data Firehose streams, and S3
     *         buckets, they must already exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
     *         property with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match
     *         the <code>DataIdentifer</code> array in the first block of the policy.
     *         </p>
     *         <p>
     *         The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the
     *         data, and it must contain the <code> "MaskConfig": {}</code> object. The <code> "MaskConfig": {}</code>
     *         object must be empty.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For an example data protection policy, see the <b>Examples</b> section on this page.
     *         </p>
     *         <important>
     *         <p>
     *         The contents of the two <code>DataIdentifer</code> arrays must match exactly.
     *         </p>
     *         </important>
     *         <p>
     *         In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>,
     *         <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is different than the
     *         operation's <code>policyName</code> parameter, and is used as a dimension when CloudWatch Logs reports
     *         audit findings metrics to CloudWatch.
     *         </p>
     *         <p>
     *         The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
     * @see PolicyType
     */
    public final PolicyType policyType() {
        return PolicyType.fromValue(policyType);
    }

    /**
     * <p>
     * Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #policyType} will
     * return {@link PolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #policyTypeAsString}.
     * </p>
     * 
     * @return Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
     * @see PolicyType
     */
    public final String policyTypeAsString() {
        return policyType;
    }

    /**
     * <p>
     * Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data protection
     * policy applies to all log groups in the account. If you omit this parameter, the default of <code>ALL</code> is
     * used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data
     *         protection policy applies to all log groups in the account. If you omit this parameter, the default of
     *         <code>ALL</code> is used.
     * @see Scope
     */
    public final Scope scope() {
        return Scope.fromValue(scope);
    }

    /**
     * <p>
     * Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data protection
     * policy applies to all log groups in the account. If you omit this parameter, the default of <code>ALL</code> is
     * used.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scope} will return
     * {@link Scope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scopeAsString}.
     * </p>
     * 
     * @return Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data
     *         protection policy applies to all log groups in the account. If you omit this parameter, the default of
     *         <code>ALL</code> is used.
     * @see Scope
     */
    public final String scopeAsString() {
        return scope;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scopeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAccountPolicyRequest)) {
            return false;
        }
        PutAccountPolicyRequest other = (PutAccountPolicyRequest) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyTypeAsString(), other.policyTypeAsString())
                && Objects.equals(scopeAsString(), other.scopeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutAccountPolicyRequest").add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument()).add("PolicyType", policyTypeAsString()).add("Scope", scopeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "policyType":
            return Optional.ofNullable(clazz.cast(policyTypeAsString()));
        case "scope":
            return Optional.ofNullable(clazz.cast(scopeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutAccountPolicyRequest, T> g) {
        return obj -> g.apply((PutAccountPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutAccountPolicyRequest> {
        /**
         * <p>
         * A name for the policy. This must be unique within the account.
         * </p>
         * 
         * @param policyName
         *        A name for the policy. This must be unique within the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * Specify the data protection policy, in JSON.
         * </p>
         * <p>
         * This policy must include two JSON blocks:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property
         * with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of sensitive data
         * that you want to mask. For more information about the available options, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html">Types of
         * data that you can mask</a>.
         * </p>
         * <p>
         * The <code>Operation</code> property with an <code>Audit</code> action is required to find the sensitive data
         * terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code> object. You can
         * optionally use that <code>FindingsDestination</code> object to list one or more destinations to send audit
         * findings to. If you specify destinations such as log groups, Kinesis Data Firehose streams, and S3 buckets,
         * they must already exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code> property
         * with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly match the
         * <code>DataIdentifer</code> array in the first block of the policy.
         * </p>
         * <p>
         * The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the data,
         * and it must contain the <code> "MaskConfig": {}</code> object. The <code> "MaskConfig": {}</code> object must
         * be empty.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For an example data protection policy, see the <b>Examples</b> section on this page.
         * </p>
         * <important>
         * <p>
         * The contents of the two <code>DataIdentifer</code> arrays must match exactly.
         * </p>
         * </important>
         * <p>
         * In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>,
         * <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is different than the
         * operation's <code>policyName</code> parameter, and is used as a dimension when CloudWatch Logs reports audit
         * findings metrics to CloudWatch.
         * </p>
         * <p>
         * The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
         * </p>
         * 
         * @param policyDocument
         *        Specify the data protection policy, in JSON.</p>
         *        <p>
         *        This policy must include two JSON blocks:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        The first block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
         *        property with an <code>Audit</code> action. The <code>DataIdentifer</code> array lists the types of
         *        sensitive data that you want to mask. For more information about the available options, see <a
         *        href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/mask-sensitive-log-data-types.html"
         *        >Types of data that you can mask</a>.
         *        </p>
         *        <p>
         *        The <code>Operation</code> property with an <code>Audit</code> action is required to find the
         *        sensitive data terms. This <code>Audit</code> action must contain a <code>FindingsDestination</code>
         *        object. You can optionally use that <code>FindingsDestination</code> object to list one or more
         *        destinations to send audit findings to. If you specify destinations such as log groups, Kinesis Data
         *        Firehose streams, and S3 buckets, they must already exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The second block must include both a <code>DataIdentifer</code> array and an <code>Operation</code>
         *        property with an <code>Deidentify</code> action. The <code>DataIdentifer</code> array must exactly
         *        match the <code>DataIdentifer</code> array in the first block of the policy.
         *        </p>
         *        <p>
         *        The <code>Operation</code> property with the <code>Deidentify</code> action is what actually masks the
         *        data, and it must contain the <code> "MaskConfig": {}</code> object. The
         *        <code> "MaskConfig": {}</code> object must be empty.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For an example data protection policy, see the <b>Examples</b> section on this page.
         *        </p>
         *        <important>
         *        <p>
         *        The contents of the two <code>DataIdentifer</code> arrays must match exactly.
         *        </p>
         *        </important>
         *        <p>
         *        In addition to the two JSON blocks, the <code>policyDocument</code> can also include <code>Name</code>, <code>Description</code>, and <code>Version</code> fields. The <code>Name</code> is different than
         *        the operation's <code>policyName</code> parameter, and is used as a dimension when CloudWatch Logs
         *        reports audit findings metrics to CloudWatch.
         *        </p>
         *        <p>
         *        The JSON specified in <code>policyDocument</code> can be up to 30,720 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
         * </p>
         * 
         * @param policyType
         *        Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(String policyType);

        /**
         * <p>
         * Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
         * </p>
         * 
         * @param policyType
         *        Currently the only valid value for this parameter is <code>DATA_PROTECTION_POLICY</code>.
         * @see PolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PolicyType
         */
        Builder policyType(PolicyType policyType);

        /**
         * <p>
         * Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data
         * protection policy applies to all log groups in the account. If you omit this parameter, the default of
         * <code>ALL</code> is used.
         * </p>
         * 
         * @param scope
         *        Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data
         *        protection policy applies to all log groups in the account. If you omit this parameter, the default of
         *        <code>ALL</code> is used.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(String scope);

        /**
         * <p>
         * Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data
         * protection policy applies to all log groups in the account. If you omit this parameter, the default of
         * <code>ALL</code> is used.
         * </p>
         * 
         * @param scope
         *        Currently the only valid value for this parameter is <code>ALL</code>, which specifies that the data
         *        protection policy applies to all log groups in the account. If you omit this parameter, the default of
         *        <code>ALL</code> is used.
         * @see Scope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Scope
         */
        Builder scope(Scope scope);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudWatchLogsRequest.BuilderImpl implements Builder {
        private String policyName;

        private String policyDocument;

        private String policyType;

        private String scope;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAccountPolicyRequest model) {
            super(model);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
            policyType(model.policyType);
            scope(model.scope);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyType() {
            return policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(PolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        public final String getScope() {
            return scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(Scope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAccountPolicyRequest build() {
            return new PutAccountPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
