/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEventDataStoreRequest extends CloudTrailRequest implements
        ToCopyableBuilder<CreateEventDataStoreRequest.Builder, CreateEventDataStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateEventDataStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<AdvancedEventSelector>> ADVANCED_EVENT_SELECTORS_FIELD = SdkField
            .<List<AdvancedEventSelector>> builder(MarshallingType.LIST)
            .memberName("AdvancedEventSelectors")
            .getter(getter(CreateEventDataStoreRequest::advancedEventSelectors))
            .setter(setter(Builder::advancedEventSelectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedEventSelectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdvancedEventSelector> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdvancedEventSelector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MULTI_REGION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiRegionEnabled").getter(getter(CreateEventDataStoreRequest::multiRegionEnabled))
            .setter(setter(Builder::multiRegionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionEnabled").build())
            .build();

    private static final SdkField<Boolean> ORGANIZATION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("OrganizationEnabled").getter(getter(CreateEventDataStoreRequest::organizationEnabled))
            .setter(setter(Builder::organizationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationEnabled").build())
            .build();

    private static final SdkField<Integer> RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriod").getter(getter(CreateEventDataStoreRequest::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()).build();

    private static final SdkField<Boolean> TERMINATION_PROTECTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TerminationProtectionEnabled")
            .getter(getter(CreateEventDataStoreRequest::terminationProtectionEnabled))
            .setter(setter(Builder::terminationProtectionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationProtectionEnabled")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("TagsList")
            .getter(getter(CreateEventDataStoreRequest::tagsList))
            .setter(setter(Builder::tagsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateEventDataStoreRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> START_INGESTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StartIngestion").getter(getter(CreateEventDataStoreRequest::startIngestion))
            .setter(setter(Builder::startIngestion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartIngestion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            ADVANCED_EVENT_SELECTORS_FIELD, MULTI_REGION_ENABLED_FIELD, ORGANIZATION_ENABLED_FIELD, RETENTION_PERIOD_FIELD,
            TERMINATION_PROTECTION_ENABLED_FIELD, TAGS_LIST_FIELD, KMS_KEY_ID_FIELD, START_INGESTION_FIELD));

    private final String name;

    private final List<AdvancedEventSelector> advancedEventSelectors;

    private final Boolean multiRegionEnabled;

    private final Boolean organizationEnabled;

    private final Integer retentionPeriod;

    private final Boolean terminationProtectionEnabled;

    private final List<Tag> tagsList;

    private final String kmsKeyId;

    private final Boolean startIngestion;

    private CreateEventDataStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.advancedEventSelectors = builder.advancedEventSelectors;
        this.multiRegionEnabled = builder.multiRegionEnabled;
        this.organizationEnabled = builder.organizationEnabled;
        this.retentionPeriod = builder.retentionPeriod;
        this.terminationProtectionEnabled = builder.terminationProtectionEnabled;
        this.tagsList = builder.tagsList;
        this.kmsKeyId = builder.kmsKeyId;
        this.startIngestion = builder.startIngestion;
    }

    /**
     * <p>
     * The name of the event data store.
     * </p>
     * 
     * @return The name of the event data store.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdvancedEventSelectors property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdvancedEventSelectors() {
        return advancedEventSelectors != null && !(advancedEventSelectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The advanced event selectors to use to select the events for the data store. You can configure up to five
     * advanced event selectors for each event data store.
     * </p>
     * <p>
     * For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
     * >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     * </p>
     * <p>
     * For more information about how to use advanced event selectors to include Config configuration items in your
     * event data store, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
     * >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
     * </p>
     * <p>
     * For more information about how to use advanced event selectors to include non-Amazon Web Services events in your
     * event data store, see <a href=
     * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
     * >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdvancedEventSelectors} method.
     * </p>
     * 
     * @return The advanced event selectors to use to select the events for the data store. You can configure up to five
     *         advanced event selectors for each event data store.</p>
     *         <p>
     *         For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
     *         >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
     *         </p>
     *         <p>
     *         For more information about how to use advanced event selectors to include Config configuration items in
     *         your event data store, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
     *         >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
     *         </p>
     *         <p>
     *         For more information about how to use advanced event selectors to include non-Amazon Web Services events
     *         in your event data store, see <a href=
     *         "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
     *         >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User Guide.
     */
    public final List<AdvancedEventSelector> advancedEventSelectors() {
        return advancedEventSelectors;
    }

    /**
     * <p>
     * Specifies whether the event data store includes events from all Regions, or only from the Region in which the
     * event data store is created.
     * </p>
     * 
     * @return Specifies whether the event data store includes events from all Regions, or only from the Region in which
     *         the event data store is created.
     */
    public final Boolean multiRegionEnabled() {
        return multiRegionEnabled;
    }

    /**
     * <p>
     * Specifies whether an event data store collects events logged for an organization in Organizations.
     * </p>
     * 
     * @return Specifies whether an event data store collects events logged for an organization in Organizations.
     */
    public final Boolean organizationEnabled() {
        return organizationEnabled;
    }

    /**
     * <p>
     * The retention period of the event data store, in days. You can set a retention period of up to 2557 days, the
     * equivalent of seven years. CloudTrail Lake determines whether to retain an event by checking if the
     * <code>eventTime</code> of the event is within the specified retention period. For example, if you set a retention
     * period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90 days.
     * </p>
     * <note>
     * <p>
     * If you plan to copy trail events to this event data store, we recommend that you consider both the age of the
     * events that you want to copy as well as how long you want to keep the copied events in your event data store. For
     * example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the event data
     * store will retain those events for two years.
     * </p>
     * </note>
     * 
     * @return The retention period of the event data store, in days. You can set a retention period of up to 2557 days,
     *         the equivalent of seven years. CloudTrail Lake determines whether to retain an event by checking if the
     *         <code>eventTime</code> of the event is within the specified retention period. For example, if you set a
     *         retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than
     *         90 days.</p> <note>
     *         <p>
     *         If you plan to copy trail events to this event data store, we recommend that you consider both the age of
     *         the events that you want to copy as well as how long you want to keep the copied events in your event
     *         data store. For example, if you copy trail events that are 5 years old and specify a retention period of
     *         7 years, the event data store will retain those events for two years.
     *         </p>
     */
    public final Integer retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * Specifies whether termination protection is enabled for the event data store. If termination protection is
     * enabled, you cannot delete the event data store until termination protection is disabled.
     * </p>
     * 
     * @return Specifies whether termination protection is enabled for the event data store. If termination protection
     *         is enabled, you cannot delete the event data store until termination protection is disabled.
     */
    public final Boolean terminationProtectionEnabled() {
        return terminationProtectionEnabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagsList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagsList() {
        return tagsList != null && !(tagsList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagsList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagsList} method.
     * </p>
     * 
     * @return The value of the TagsList property for this object.
     */
    public final List<Tag> tagsList() {
        return tagsList;
    }

    /**
     * <p>
     * Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name
     * prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN to a key, or a globally
     * unique identifier.
     * </p>
     * <important>
     * <p>
     * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from
     * logging events to the event data store, and prevents users from querying the data in the event data store that
     * was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot be removed
     * or changed. Before you disable or delete a KMS key that you are using with an event data store, delete or back up
     * your event data store.
     * </p>
     * </important>
     * <p>
     * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region
     * keys</a> in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>alias/MyAliasName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>12345678-1234-1234-1234-123456789012</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias
     *         name prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN to a key,
     *         or a globally unique identifier.</p> <important>
     *         <p>
     *         Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail
     *         from logging events to the event data store, and prevents users from querying the data in the event data
     *         store that was encrypted with the key. After you associate an event data store with a KMS key, the KMS
     *         key cannot be removed or changed. Before you disable or delete a KMS key that you are using with an event
     *         data store, delete or back up your event data store.
     *         </p>
     *         </important>
     *         <p>
     *         CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using
     *         multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>alias/MyAliasName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>12345678-1234-1234-1234-123456789012</code>
     *         </p>
     *         </li>
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether the event data store should start ingesting live events. The default is true.
     * </p>
     * 
     * @return Specifies whether the event data store should start ingesting live events. The default is true.
     */
    public final Boolean startIngestion() {
        return startIngestion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdvancedEventSelectors() ? advancedEventSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiRegionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(organizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(terminationProtectionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagsList() ? tagsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(startIngestion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEventDataStoreRequest)) {
            return false;
        }
        CreateEventDataStoreRequest other = (CreateEventDataStoreRequest) obj;
        return Objects.equals(name(), other.name()) && hasAdvancedEventSelectors() == other.hasAdvancedEventSelectors()
                && Objects.equals(advancedEventSelectors(), other.advancedEventSelectors())
                && Objects.equals(multiRegionEnabled(), other.multiRegionEnabled())
                && Objects.equals(organizationEnabled(), other.organizationEnabled())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(terminationProtectionEnabled(), other.terminationProtectionEnabled())
                && hasTagsList() == other.hasTagsList() && Objects.equals(tagsList(), other.tagsList())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(startIngestion(), other.startIngestion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEventDataStoreRequest").add("Name", name())
                .add("AdvancedEventSelectors", hasAdvancedEventSelectors() ? advancedEventSelectors() : null)
                .add("MultiRegionEnabled", multiRegionEnabled()).add("OrganizationEnabled", organizationEnabled())
                .add("RetentionPeriod", retentionPeriod()).add("TerminationProtectionEnabled", terminationProtectionEnabled())
                .add("TagsList", hasTagsList() ? tagsList() : null).add("KmsKeyId", kmsKeyId())
                .add("StartIngestion", startIngestion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "AdvancedEventSelectors":
            return Optional.ofNullable(clazz.cast(advancedEventSelectors()));
        case "MultiRegionEnabled":
            return Optional.ofNullable(clazz.cast(multiRegionEnabled()));
        case "OrganizationEnabled":
            return Optional.ofNullable(clazz.cast(organizationEnabled()));
        case "RetentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "TerminationProtectionEnabled":
            return Optional.ofNullable(clazz.cast(terminationProtectionEnabled()));
        case "TagsList":
            return Optional.ofNullable(clazz.cast(tagsList()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "StartIngestion":
            return Optional.ofNullable(clazz.cast(startIngestion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEventDataStoreRequest, T> g) {
        return obj -> g.apply((CreateEventDataStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEventDataStoreRequest> {
        /**
         * <p>
         * The name of the event data store.
         * </p>
         * 
         * @param name
         *        The name of the event data store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The advanced event selectors to use to select the events for the data store. You can configure up to five
         * advanced event selectors for each event data store.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
         * >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to include Config configuration items in your
         * event data store, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
         * >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to include non-Amazon Web Services events in
         * your event data store, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
         * >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User Guide.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors to use to select the events for the data store. You can configure up to
         *        five advanced event selectors for each event data store.</p>
         *        <p>
         *        For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
         *        >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         *        </p>
         *        <p>
         *        For more information about how to use advanced event selectors to include Config configuration items
         *        in your event data store, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
         *        >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
         *        </p>
         *        <p>
         *        For more information about how to use advanced event selectors to include non-Amazon Web Services
         *        events in your event data store, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
         *        >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors to use to select the events for the data store. You can configure up to five
         * advanced event selectors for each event data store.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
         * >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to include Config configuration items in your
         * event data store, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
         * >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to include non-Amazon Web Services events in
         * your event data store, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
         * >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User Guide.
         * </p>
         * 
         * @param advancedEventSelectors
         *        The advanced event selectors to use to select the events for the data store. You can configure up to
         *        five advanced event selectors for each event data store.</p>
         *        <p>
         *        For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
         *        >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         *        </p>
         *        <p>
         *        For more information about how to use advanced event selectors to include Config configuration items
         *        in your event data store, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
         *        >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
         *        </p>
         *        <p>
         *        For more information about how to use advanced event selectors to include non-Amazon Web Services
         *        events in your event data store, see <a href=
         *        "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
         *        >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User
         *        Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors);

        /**
         * <p>
         * The advanced event selectors to use to select the events for the data store. You can configure up to five
         * advanced event selectors for each event data store.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to log CloudTrail events, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#creating-data-event-selectors-advanced"
         * >Log events by using advanced event selectors</a> in the CloudTrail User Guide.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to include Config configuration items in your
         * event data store, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-eds-config"
         * >Create an event data store for Config configuration items</a> in the CloudTrail User Guide.
         * </p>
         * <p>
         * For more information about how to use advanced event selectors to include non-Amazon Web Services events in
         * your event data store, see <a href=
         * "https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-lake-cli.html#lake-cli-create-integration"
         * >Create an integration to log events from outside Amazon Web Services</a> in the CloudTrail User Guide.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder#build()} is called
         * immediately and its result is passed to {@link #advancedEventSelectors(List<AdvancedEventSelector>)}.
         * 
         * @param advancedEventSelectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.AdvancedEventSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #advancedEventSelectors(java.util.Collection<AdvancedEventSelector>)
         */
        Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors);

        /**
         * <p>
         * Specifies whether the event data store includes events from all Regions, or only from the Region in which the
         * event data store is created.
         * </p>
         * 
         * @param multiRegionEnabled
         *        Specifies whether the event data store includes events from all Regions, or only from the Region in
         *        which the event data store is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiRegionEnabled(Boolean multiRegionEnabled);

        /**
         * <p>
         * Specifies whether an event data store collects events logged for an organization in Organizations.
         * </p>
         * 
         * @param organizationEnabled
         *        Specifies whether an event data store collects events logged for an organization in Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationEnabled(Boolean organizationEnabled);

        /**
         * <p>
         * The retention period of the event data store, in days. You can set a retention period of up to 2557 days, the
         * equivalent of seven years. CloudTrail Lake determines whether to retain an event by checking if the
         * <code>eventTime</code> of the event is within the specified retention period. For example, if you set a
         * retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code> is older than 90
         * days.
         * </p>
         * <note>
         * <p>
         * If you plan to copy trail events to this event data store, we recommend that you consider both the age of the
         * events that you want to copy as well as how long you want to keep the copied events in your event data store.
         * For example, if you copy trail events that are 5 years old and specify a retention period of 7 years, the
         * event data store will retain those events for two years.
         * </p>
         * </note>
         * 
         * @param retentionPeriod
         *        The retention period of the event data store, in days. You can set a retention period of up to 2557
         *        days, the equivalent of seven years. CloudTrail Lake determines whether to retain an event by checking
         *        if the <code>eventTime</code> of the event is within the specified retention period. For example, if
         *        you set a retention period of 90 days, CloudTrail will remove events when the <code>eventTime</code>
         *        is older than 90 days.</p> <note>
         *        <p>
         *        If you plan to copy trail events to this event data store, we recommend that you consider both the age
         *        of the events that you want to copy as well as how long you want to keep the copied events in your
         *        event data store. For example, if you copy trail events that are 5 years old and specify a retention
         *        period of 7 years, the event data store will retain those events for two years.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(Integer retentionPeriod);

        /**
         * <p>
         * Specifies whether termination protection is enabled for the event data store. If termination protection is
         * enabled, you cannot delete the event data store until termination protection is disabled.
         * </p>
         * 
         * @param terminationProtectionEnabled
         *        Specifies whether termination protection is enabled for the event data store. If termination
         *        protection is enabled, you cannot delete the event data store until termination protection is
         *        disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * @param tagsList
         *        The new value for the TagsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Collection<Tag> tagsList);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * @param tagsList
         *        The new value for the TagsList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagsList(Tag... tagsList);

        /**
         * Sets the value of the TagsList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.cloudtrail.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagsList(List<Tag>)}.
         * 
         * @param tagsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagsList(java.util.Collection<Tag>)
         */
        Builder tagsList(Consumer<Tag.Builder>... tagsList);

        /**
         * <p>
         * Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an alias name
         * prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN to a key, or a
         * globally unique identifier.
         * </p>
         * <important>
         * <p>
         * Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail from
         * logging events to the event data store, and prevents users from querying the data in the event data store
         * that was encrypted with the key. After you associate an event data store with a KMS key, the KMS key cannot
         * be removed or changed. Before you disable or delete a KMS key that you are using with an event data store,
         * delete or back up your event data store.
         * </p>
         * </important>
         * <p>
         * CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using
         * multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>alias/MyAliasName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>12345678-1234-1234-1234-123456789012</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyId
         *        Specifies the KMS key ID to use to encrypt the events delivered by CloudTrail. The value can be an
         *        alias name prefixed by <code>alias/</code>, a fully specified ARN to an alias, a fully specified ARN
         *        to a key, or a globally unique identifier.</p> <important>
         *        <p>
         *        Disabling or deleting the KMS key, or removing CloudTrail permissions on the key, prevents CloudTrail
         *        from logging events to the event data store, and prevents users from querying the data in the event
         *        data store that was encrypted with the key. After you associate an event data store with a KMS key,
         *        the KMS key cannot be removed or changed. Before you disable or delete a KMS key that you are using
         *        with an event data store, delete or back up your event data store.
         *        </p>
         *        </important>
         *        <p>
         *        CloudTrail also supports KMS multi-Region keys. For more information about multi-Region keys, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using
         *        multi-Region keys</a> in the <i>Key Management Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>alias/MyAliasName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>12345678-1234-1234-1234-123456789012</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether the event data store should start ingesting live events. The default is true.
         * </p>
         * 
         * @param startIngestion
         *        Specifies whether the event data store should start ingesting live events. The default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startIngestion(Boolean startIngestion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private String name;

        private List<AdvancedEventSelector> advancedEventSelectors = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiRegionEnabled;

        private Boolean organizationEnabled;

        private Integer retentionPeriod;

        private Boolean terminationProtectionEnabled;

        private List<Tag> tagsList = DefaultSdkAutoConstructList.getInstance();

        private String kmsKeyId;

        private Boolean startIngestion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEventDataStoreRequest model) {
            super(model);
            name(model.name);
            advancedEventSelectors(model.advancedEventSelectors);
            multiRegionEnabled(model.multiRegionEnabled);
            organizationEnabled(model.organizationEnabled);
            retentionPeriod(model.retentionPeriod);
            terminationProtectionEnabled(model.terminationProtectionEnabled);
            tagsList(model.tagsList);
            kmsKeyId(model.kmsKeyId);
            startIngestion(model.startIngestion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<AdvancedEventSelector.Builder> getAdvancedEventSelectors() {
            List<AdvancedEventSelector.Builder> result = AdvancedEventSelectorsCopier.copyToBuilder(this.advancedEventSelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdvancedEventSelectors(Collection<AdvancedEventSelector.BuilderImpl> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copyFromBuilder(advancedEventSelectors);
        }

        @Override
        public final Builder advancedEventSelectors(Collection<AdvancedEventSelector> advancedEventSelectors) {
            this.advancedEventSelectors = AdvancedEventSelectorsCopier.copy(advancedEventSelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(AdvancedEventSelector... advancedEventSelectors) {
            advancedEventSelectors(Arrays.asList(advancedEventSelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder advancedEventSelectors(Consumer<AdvancedEventSelector.Builder>... advancedEventSelectors) {
            advancedEventSelectors(Stream.of(advancedEventSelectors)
                    .map(c -> AdvancedEventSelector.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiRegionEnabled() {
            return multiRegionEnabled;
        }

        public final void setMultiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
        }

        @Override
        public final Builder multiRegionEnabled(Boolean multiRegionEnabled) {
            this.multiRegionEnabled = multiRegionEnabled;
            return this;
        }

        public final Boolean getOrganizationEnabled() {
            return organizationEnabled;
        }

        public final void setOrganizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
        }

        @Override
        public final Builder organizationEnabled(Boolean organizationEnabled) {
            this.organizationEnabled = organizationEnabled;
            return this;
        }

        public final Integer getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Integer retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Boolean getTerminationProtectionEnabled() {
            return terminationProtectionEnabled;
        }

        public final void setTerminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
        }

        @Override
        public final Builder terminationProtectionEnabled(Boolean terminationProtectionEnabled) {
            this.terminationProtectionEnabled = terminationProtectionEnabled;
            return this;
        }

        public final List<Tag.Builder> getTagsList() {
            List<Tag.Builder> result = TagsListCopier.copyToBuilder(this.tagsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagsList(Collection<Tag.BuilderImpl> tagsList) {
            this.tagsList = TagsListCopier.copyFromBuilder(tagsList);
        }

        @Override
        public final Builder tagsList(Collection<Tag> tagsList) {
            this.tagsList = TagsListCopier.copy(tagsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Tag... tagsList) {
            tagsList(Arrays.asList(tagsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsList(Consumer<Tag.Builder>... tagsList) {
            tagsList(Stream.of(tagsList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getStartIngestion() {
            return startIngestion;
        }

        public final void setStartIngestion(Boolean startIngestion) {
            this.startIngestion = startIngestion;
        }

        @Override
        public final Builder startIngestion(Boolean startIngestion) {
            this.startIngestion = startIngestion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEventDataStoreRequest build() {
            return new CreateEventDataStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
