/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelQueryResponse extends CloudTrailResponse implements
        ToCopyableBuilder<CancelQueryResponse.Builder, CancelQueryResponse> {
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryId").getter(getter(CancelQueryResponse::queryId)).setter(setter(Builder::queryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryId").build()).build();

    private static final SdkField<String> QUERY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryStatus").getter(getter(CancelQueryResponse::queryStatusAsString))
            .setter(setter(Builder::queryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_ID_FIELD,
            QUERY_STATUS_FIELD));

    private final String queryId;

    private final String queryStatus;

    private CancelQueryResponse(BuilderImpl builder) {
        super(builder);
        this.queryId = builder.queryId;
        this.queryStatus = builder.queryStatus;
    }

    /**
     * <p>
     * The ID of the canceled query.
     * </p>
     * 
     * @return The ID of the canceled query.
     */
    public final String queryId() {
        return queryId;
    }

    /**
     * <p>
     * Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either
     * <code>RUNNING</code> or <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are
     *         either <code>RUNNING</code> or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final QueryStatus queryStatus() {
        return QueryStatus.fromValue(queryStatus);
    }

    /**
     * <p>
     * Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either
     * <code>RUNNING</code> or <code>CANCELLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #queryStatus} will
     * return {@link QueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #queryStatusAsString}.
     * </p>
     * 
     * @return Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are
     *         either <code>RUNNING</code> or <code>CANCELLED</code>.
     * @see QueryStatus
     */
    public final String queryStatusAsString() {
        return queryStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(queryId());
        hashCode = 31 * hashCode + Objects.hashCode(queryStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelQueryResponse)) {
            return false;
        }
        CancelQueryResponse other = (CancelQueryResponse) obj;
        return Objects.equals(queryId(), other.queryId()) && Objects.equals(queryStatusAsString(), other.queryStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelQueryResponse").add("QueryId", queryId()).add("QueryStatus", queryStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "QueryId":
            return Optional.ofNullable(clazz.cast(queryId()));
        case "QueryStatus":
            return Optional.ofNullable(clazz.cast(queryStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelQueryResponse, T> g) {
        return obj -> g.apply((CancelQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelQueryResponse> {
        /**
         * <p>
         * The ID of the canceled query.
         * </p>
         * 
         * @param queryId
         *        The ID of the canceled query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryId(String queryId);

        /**
         * <p>
         * Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either
         * <code>RUNNING</code> or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are
         *        either <code>RUNNING</code> or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(String queryStatus);

        /**
         * <p>
         * Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are either
         * <code>RUNNING</code> or <code>CANCELLED</code>.
         * </p>
         * 
         * @param queryStatus
         *        Shows the status of a query after a <code>CancelQuery</code> request. Typically, the values shown are
         *        either <code>RUNNING</code> or <code>CANCELLED</code>.
         * @see QueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryStatus
         */
        Builder queryStatus(QueryStatus queryStatus);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private String queryId;

        private String queryStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelQueryResponse model) {
            super(model);
            queryId(model.queryId);
            queryStatus(model.queryStatus);
        }

        public final String getQueryId() {
            return queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        public final String getQueryStatus() {
            return queryStatus;
        }

        public final void setQueryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
        }

        @Override
        public final Builder queryStatus(String queryStatus) {
            this.queryStatus = queryStatus;
            return this;
        }

        @Override
        public final Builder queryStatus(QueryStatus queryStatus) {
            this.queryStatus(queryStatus == null ? null : queryStatus.toString());
            return this;
        }

        @Override
        public CancelQueryResponse build() {
            return new CancelQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
