/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.internal;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.http.auth.spi.scheme.AuthScheme;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.IdentityProviders;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtrail.CloudTrailServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtrail.auth.scheme.CloudTrailAuthSchemeProvider;
import software.amazon.awssdk.utils.Validate;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
public class CloudTrailServiceClientConfigurationBuilder {
    public static CloudTrailServiceClientConfiguration.Builder builder() {
        return new BuilderImpl();
    }

    public static BuilderInternal builder(SdkClientConfiguration.Builder builder) {
        return new BuilderImpl(builder);
    }

    public interface BuilderInternal extends CloudTrailServiceClientConfiguration.Builder {
        SdkClientConfiguration buildSdkClientConfiguration();
    }

    public static class BuilderImpl implements BuilderInternal {
        private final SdkClientConfiguration.Builder internalBuilder;

        private ClientOverrideConfiguration overrideConfiguration;

        private URI endpointOverride;

        private IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider;

        private Map<String, AuthScheme<?>> authSchemes;

        private BuilderImpl() {
            this.internalBuilder = SdkClientConfiguration.builder();
        }

        private BuilderImpl(SdkClientConfiguration.Builder internalBuilder) {
            this.internalBuilder = internalBuilder;
            if (Boolean.TRUE.equals(internalBuilder.option(SdkClientOption.ENDPOINT_OVERRIDDEN))) {
                this.endpointOverride = internalBuilder.option(SdkClientOption.ENDPOINT);
            }
            this.credentialsProvider = internalBuilder.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER);
            Map<String, AuthScheme<?>> authSchemes = internalBuilder.option(SdkClientOption.AUTH_SCHEMES);
            if (authSchemes != null) {
                authSchemes = new HashMap<>(authSchemes);
            }
            this.authSchemes = authSchemes;
        }

        /**
         * Sets the value for client override configuration
         */
        @Override
        public CloudTrailServiceClientConfiguration.Builder overrideConfiguration(
                ClientOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        /**
         * Gets the value for client override configuration
         */
        @Override
        public ClientOverrideConfiguration overrideConfiguration() {
            return overrideConfiguration;
        }

        /**
         * Sets the value for endpoint override
         */
        @Override
        public CloudTrailServiceClientConfiguration.Builder endpointOverride(URI endpointOverride) {
            this.endpointOverride = endpointOverride;
            return this;
        }

        /**
         * Gets the value for endpoint override
         */
        @Override
        public URI endpointOverride() {
            return endpointOverride;
        }

        /**
         * Sets the value for endpoint provider
         */
        @Override
        public CloudTrailServiceClientConfiguration.Builder endpointProvider(EndpointProvider endpointProvider) {
            internalBuilder.option(SdkClientOption.ENDPOINT_PROVIDER, endpointProvider);
            return this;
        }

        /**
         * Gets the value for endpoint provider
         */
        @Override
        public EndpointProvider endpointProvider() {
            return internalBuilder.option(SdkClientOption.ENDPOINT_PROVIDER);
        }

        /**
         * Sets the value for AWS region
         */
        @Override
        public CloudTrailServiceClientConfiguration.Builder region(Region region) {
            internalBuilder.option(AwsClientOption.AWS_REGION, region);
            return this;
        }

        /**
         * Gets the value for AWS region
         */
        @Override
        public Region region() {
            return internalBuilder.option(AwsClientOption.AWS_REGION);
        }

        /**
         * Sets the value for credentials provider
         */
        @Override
        public CloudTrailServiceClientConfiguration.Builder credentialsProvider(
                IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        /**
         * Gets the value for credentials provider
         */
        @Override
        public IdentityProvider<? extends AwsCredentialsIdentity> credentialsProvider() {
            return credentialsProvider;
        }

        @Override
        public CloudTrailServiceClientConfiguration.Builder putAuthScheme(AuthScheme<?> authScheme) {
            if (authSchemes == null) {
                authSchemes = new HashMap<>();
            }
            authSchemes.put(authScheme.schemeId(), authScheme);
            return this;
        }

        @Override
        public Map<String, AuthScheme<?>> authSchemes() {
            if (authSchemes == null) {
                return Collections.emptyMap();
            }
            return Collections.unmodifiableMap(new HashMap<>(authSchemes));
        }

        /**
         * Sets the value for auth scheme provider
         */
        @Override
        public CloudTrailServiceClientConfiguration.Builder authSchemeProvider(CloudTrailAuthSchemeProvider authSchemeProvider) {
            internalBuilder.option(SdkClientOption.AUTH_SCHEME_PROVIDER, authSchemeProvider);
            return this;
        }

        /**
         * Gets the value for auth scheme provider
         */
        @Override
        public CloudTrailAuthSchemeProvider authSchemeProvider() {
            AuthSchemeProvider result = internalBuilder.option(SdkClientOption.AUTH_SCHEME_PROVIDER);
            if (result == null) {
                return null;
            }
            return Validate.isInstanceOf(CloudTrailAuthSchemeProvider.class, result, "Expected an instance of "
                    + CloudTrailAuthSchemeProvider.class.getSimpleName());
        }

        @Override
        public CloudTrailServiceClientConfiguration build() {
            return new CloudTrailServiceClientConfiguration(this);
        }

        @Override
        public SdkClientConfiguration buildSdkClientConfiguration() {
            if (overrideConfiguration != null) {
                SdkClientConfigurationUtil.copyOverridesToConfiguration(overrideConfiguration, internalBuilder);
            }
            if (endpointOverride != null) {
                internalBuilder.option(SdkClientOption.ENDPOINT, endpointOverride);
                internalBuilder.option(SdkClientOption.ENDPOINT_OVERRIDDEN, true);
            }
            if (credentialsProvider != null
                    && !credentialsProvider.equals(internalBuilder.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER))) {
                internalBuilder.option(AwsClientOption.CREDENTIALS_IDENTITY_PROVIDER, credentialsProvider);
                IdentityProviders identityProviders = internalBuilder.option(SdkClientOption.IDENTITY_PROVIDERS);
                if (identityProviders == null) {
                    identityProviders = IdentityProviders.builder().putIdentityProvider(credentialsProvider).build();
                } else {
                    identityProviders = identityProviders.toBuilder().putIdentityProvider(credentialsProvider).build();
                }
                internalBuilder.option(SdkClientOption.IDENTITY_PROVIDERS, identityProviders);
            }
            if (authSchemes != null && !authSchemes.equals(internalBuilder.option(SdkClientOption.AUTH_SCHEMES))) {
                internalBuilder.option(SdkClientOption.AUTH_SCHEMES, authSchemes());
            }
            return internalBuilder.build();
        }
    }
}
