/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>UpdateDomainEndpointOptions</a></code> operation. Specifies the name of
 * the domain you want to update and the domain endpoint options.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainEndpointOptionsRequest extends CloudSearchRequest implements
        ToCopyableBuilder<UpdateDomainEndpointOptionsRequest.Builder, UpdateDomainEndpointOptionsRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateDomainEndpointOptionsRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<DomainEndpointOptions> DOMAIN_ENDPOINT_OPTIONS_FIELD = SdkField
            .<DomainEndpointOptions> builder(MarshallingType.SDK_POJO).memberName("DomainEndpointOptions")
            .getter(getter(UpdateDomainEndpointOptionsRequest::domainEndpointOptions))
            .setter(setter(Builder::domainEndpointOptions)).constructor(DomainEndpointOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainEndpointOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DOMAIN_ENDPOINT_OPTIONS_FIELD));

    private final String domainName;

    private final DomainEndpointOptions domainEndpointOptions;

    private UpdateDomainEndpointOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.domainEndpointOptions = builder.domainEndpointOptions;
    }

    /**
     * <p>
     * A string that represents the name of a domain.
     * </p>
     * 
     * @return A string that represents the name of a domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Whether to require that all requests to the domain arrive over HTTPS. We recommend Policy-Min-TLS-1-2-2019-07 for
     * TLSSecurityPolicy. For compatibility with older clients, the default is Policy-Min-TLS-1-0-2019-07.
     * </p>
     * 
     * @return Whether to require that all requests to the domain arrive over HTTPS. We recommend
     *         Policy-Min-TLS-1-2-2019-07 for TLSSecurityPolicy. For compatibility with older clients, the default is
     *         Policy-Min-TLS-1-0-2019-07.
     */
    public final DomainEndpointOptions domainEndpointOptions() {
        return domainEndpointOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpointOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainEndpointOptionsRequest)) {
            return false;
        }
        UpdateDomainEndpointOptionsRequest other = (UpdateDomainEndpointOptionsRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(domainEndpointOptions(), other.domainEndpointOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDomainEndpointOptionsRequest").add("DomainName", domainName())
                .add("DomainEndpointOptions", domainEndpointOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DomainEndpointOptions":
            return Optional.ofNullable(clazz.cast(domainEndpointOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainEndpointOptionsRequest, T> g) {
        return obj -> g.apply((UpdateDomainEndpointOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDomainEndpointOptionsRequest> {
        /**
         * <p>
         * A string that represents the name of a domain.
         * </p>
         * 
         * @param domainName
         *        A string that represents the name of a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Whether to require that all requests to the domain arrive over HTTPS. We recommend Policy-Min-TLS-1-2-2019-07
         * for TLSSecurityPolicy. For compatibility with older clients, the default is Policy-Min-TLS-1-0-2019-07.
         * </p>
         * 
         * @param domainEndpointOptions
         *        Whether to require that all requests to the domain arrive over HTTPS. We recommend
         *        Policy-Min-TLS-1-2-2019-07 for TLSSecurityPolicy. For compatibility with older clients, the default is
         *        Policy-Min-TLS-1-0-2019-07.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions);

        /**
         * <p>
         * Whether to require that all requests to the domain arrive over HTTPS. We recommend Policy-Min-TLS-1-2-2019-07
         * for TLSSecurityPolicy. For compatibility with older clients, the default is Policy-Min-TLS-1-0-2019-07.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainEndpointOptions.Builder} avoiding
         * the need to create one manually via {@link DomainEndpointOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainEndpointOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #domainEndpointOptions(DomainEndpointOptions)}.
         * 
         * @param domainEndpointOptions
         *        a consumer that will call methods on {@link DomainEndpointOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainEndpointOptions(DomainEndpointOptions)
         */
        default Builder domainEndpointOptions(Consumer<DomainEndpointOptions.Builder> domainEndpointOptions) {
            return domainEndpointOptions(DomainEndpointOptions.builder().applyMutation(domainEndpointOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private DomainEndpointOptions domainEndpointOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainEndpointOptionsRequest model) {
            super(model);
            domainName(model.domainName);
            domainEndpointOptions(model.domainEndpointOptions);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final DomainEndpointOptions.Builder getDomainEndpointOptions() {
            return domainEndpointOptions != null ? domainEndpointOptions.toBuilder() : null;
        }

        public final void setDomainEndpointOptions(DomainEndpointOptions.BuilderImpl domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions != null ? domainEndpointOptions.build() : null;
        }

        @Override
        public final Builder domainEndpointOptions(DomainEndpointOptions domainEndpointOptions) {
            this.domainEndpointOptions = domainEndpointOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainEndpointOptionsRequest build() {
            return new UpdateDomainEndpointOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
