/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information about a public key that you can use with <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and signed
 * cookies</a>, or with <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
 * encryption</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PublicKeyConfig implements SdkPojo, Serializable, ToCopyableBuilder<PublicKeyConfig.Builder, PublicKeyConfig> {
    private static final SdkField<String> CALLER_REFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CallerReference")
            .getter(getter(PublicKeyConfig::callerReference))
            .setter(setter(Builder::callerReference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallerReference")
                    .unmarshallLocationName("CallerReference").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(PublicKeyConfig::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> ENCODED_KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EncodedKey")
            .getter(getter(PublicKeyConfig::encodedKey))
            .setter(setter(Builder::encodedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncodedKey")
                    .unmarshallLocationName("EncodedKey").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(PublicKeyConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLER_REFERENCE_FIELD,
            NAME_FIELD, ENCODED_KEY_FIELD, COMMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String callerReference;

    private final String name;

    private final String encodedKey;

    private final String comment;

    private PublicKeyConfig(BuilderImpl builder) {
        this.callerReference = builder.callerReference;
        this.name = builder.name;
        this.encodedKey = builder.encodedKey;
        this.comment = builder.comment;
    }

    /**
     * <p>
     * A string included in the request to help make sure that the request can't be replayed.
     * </p>
     * 
     * @return A string included in the request to help make sure that the request can't be replayed.
     */
    public final String callerReference() {
        return callerReference;
    }

    /**
     * <p>
     * A name to help identify the public key.
     * </p>
     * 
     * @return A name to help identify the public key.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The public key that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     * 
     * @return The public key that you can use with <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs
     *         and signed cookies</a>, or with <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html"
     *         >field-level encryption</a>.
     */
    public final String encodedKey() {
        return encodedKey;
    }

    /**
     * <p>
     * A comment to describe the public key. The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return A comment to describe the public key. The comment cannot be longer than 128 characters.
     */
    public final String comment() {
        return comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callerReference());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(encodedKey());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublicKeyConfig)) {
            return false;
        }
        PublicKeyConfig other = (PublicKeyConfig) obj;
        return Objects.equals(callerReference(), other.callerReference()) && Objects.equals(name(), other.name())
                && Objects.equals(encodedKey(), other.encodedKey()) && Objects.equals(comment(), other.comment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PublicKeyConfig").add("CallerReference", callerReference()).add("Name", name())
                .add("EncodedKey", encodedKey()).add("Comment", comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallerReference":
            return Optional.ofNullable(clazz.cast(callerReference()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EncodedKey":
            return Optional.ofNullable(clazz.cast(encodedKey()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PublicKeyConfig, T> g) {
        return obj -> g.apply((PublicKeyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PublicKeyConfig> {
        /**
         * <p>
         * A string included in the request to help make sure that the request can't be replayed.
         * </p>
         * 
         * @param callerReference
         *        A string included in the request to help make sure that the request can't be replayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callerReference(String callerReference);

        /**
         * <p>
         * A name to help identify the public key.
         * </p>
         * 
         * @param name
         *        A name to help identify the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The public key that you can use with <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
         * signed cookies</a>, or with <a
         * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html"
         * >field-level encryption</a>.
         * </p>
         * 
         * @param encodedKey
         *        The public key that you can use with <a
         *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed
         *        URLs and signed cookies</a>, or with <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html"
         *        >field-level encryption</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encodedKey(String encodedKey);

        /**
         * <p>
         * A comment to describe the public key. The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        A comment to describe the public key. The comment cannot be longer than 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);
    }

    static final class BuilderImpl implements Builder {
        private String callerReference;

        private String name;

        private String encodedKey;

        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PublicKeyConfig model) {
            callerReference(model.callerReference);
            name(model.name);
            encodedKey(model.encodedKey);
            comment(model.comment);
        }

        public final String getCallerReference() {
            return callerReference;
        }

        public final void setCallerReference(String callerReference) {
            this.callerReference = callerReference;
        }

        @Override
        public final Builder callerReference(String callerReference) {
            this.callerReference = callerReference;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEncodedKey() {
            return encodedKey;
        }

        public final void setEncodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
        }

        @Override
        public final Builder encodedKey(String encodedKey) {
            this.encodedKey = encodedKey;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public PublicKeyConfig build() {
            return new PublicKeyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
