/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * CloudFront Origin Shield.
 * </p>
 * <p>
 * Using Origin Shield can help reduce the load on your origin. For more information, see <a
 * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">Using Origin Shield</a>
 * in the <i>Amazon CloudFront Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginShield implements SdkPojo, Serializable, ToCopyableBuilder<OriginShield.Builder, OriginShield> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(OriginShield::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final SdkField<String> ORIGIN_SHIELD_REGION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginShieldRegion")
            .getter(getter(OriginShield::originShieldRegion))
            .setter(setter(Builder::originShieldRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginShieldRegion")
                    .unmarshallLocationName("OriginShieldRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            ORIGIN_SHIELD_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String originShieldRegion;

    private OriginShield(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.originShieldRegion = builder.originShieldRegion;
    }

    /**
     * <p>
     * A flag that specifies whether Origin Shield is enabled.
     * </p>
     * <p>
     * When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin. When
     * it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or regional
     * edge caches.
     * </p>
     * 
     * @return A flag that specifies whether Origin Shield is enabled.</p>
     *         <p>
     *         When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your
     *         origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge
     *         locations or regional edge caches.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The Amazon Web Services Region for Origin Shield.
     * </p>
     * <p>
     * Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a region, use the
     * region code, not the region name. For example, specify the US East (Ohio) region as <code>us-east-2</code>.
     * </p>
     * <p>
     * When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin Shield. For
     * the list of Amazon Web Services Regions that you can specify, and for help choosing the best Region for your
     * origin, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region"
     * >Choosing the Amazon Web Services Region for Origin Shield</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return The Amazon Web Services Region for Origin Shield.</p>
     *         <p>
     *         Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a region,
     *         use the region code, not the region name. For example, specify the US East (Ohio) region as
     *         <code>us-east-2</code>.
     *         </p>
     *         <p>
     *         When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin
     *         Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the best
     *         Region for your origin, see <a href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region"
     *         >Choosing the Amazon Web Services Region for Origin Shield</a> in the <i>Amazon CloudFront Developer
     *         Guide</i>.
     */
    public final String originShieldRegion() {
        return originShieldRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(originShieldRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginShield)) {
            return false;
        }
        OriginShield other = (OriginShield) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(originShieldRegion(), other.originShieldRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginShield").add("Enabled", enabled()).add("OriginShieldRegion", originShieldRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "OriginShieldRegion":
            return Optional.ofNullable(clazz.cast(originShieldRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginShield, T> g) {
        return obj -> g.apply((OriginShield) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginShield> {
        /**
         * <p>
         * A flag that specifies whether Origin Shield is enabled.
         * </p>
         * <p>
         * When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your origin.
         * When it's disabled, CloudFront might send requests directly to your origin from multiple edge locations or
         * regional edge caches.
         * </p>
         * 
         * @param enabled
         *        A flag that specifies whether Origin Shield is enabled.</p>
         *        <p>
         *        When it's enabled, CloudFront routes all requests through Origin Shield, which can help protect your
         *        origin. When it's disabled, CloudFront might send requests directly to your origin from multiple edge
         *        locations or regional edge caches.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The Amazon Web Services Region for Origin Shield.
         * </p>
         * <p>
         * Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a region, use
         * the region code, not the region name. For example, specify the US East (Ohio) region as
         * <code>us-east-2</code>.
         * </p>
         * <p>
         * When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin Shield.
         * For the list of Amazon Web Services Regions that you can specify, and for help choosing the best Region for
         * your origin, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region"
         * >Choosing the Amazon Web Services Region for Origin Shield</a> in the <i>Amazon CloudFront Developer
         * Guide</i>.
         * </p>
         * 
         * @param originShieldRegion
         *        The Amazon Web Services Region for Origin Shield.</p>
         *        <p>
         *        Specify the Amazon Web Services Region that has the lowest latency to your origin. To specify a
         *        region, use the region code, not the region name. For example, specify the US East (Ohio) region as
         *        <code>us-east-2</code>.
         *        </p>
         *        <p>
         *        When you enable CloudFront Origin Shield, you must specify the Amazon Web Services Region for Origin
         *        Shield. For the list of Amazon Web Services Regions that you can specify, and for help choosing the
         *        best Region for your origin, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html#choose-origin-shield-region"
         *        >Choosing the Amazon Web Services Region for Origin Shield</a> in the <i>Amazon CloudFront Developer
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originShieldRegion(String originShieldRegion);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String originShieldRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginShield model) {
            enabled(model.enabled);
            originShieldRegion(model.originShieldRegion);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getOriginShieldRegion() {
            return originShieldRegion;
        }

        public final void setOriginShieldRegion(String originShieldRegion) {
            this.originShieldRegion = originShieldRegion;
        }

        @Override
        public final Builder originShieldRegion(String originShieldRegion) {
            this.originShieldRegion = originShieldRegion;
            return this;
        }

        @Override
        public OriginShield build() {
            return new OriginShield(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
