/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOriginAccessControlsResponse extends CloudFrontResponse implements
        ToCopyableBuilder<ListOriginAccessControlsResponse.Builder, ListOriginAccessControlsResponse> {
    private static final SdkField<OriginAccessControlList> ORIGIN_ACCESS_CONTROL_LIST_FIELD = SdkField
            .<OriginAccessControlList> builder(MarshallingType.SDK_POJO)
            .memberName("OriginAccessControlList")
            .getter(getter(ListOriginAccessControlsResponse::originAccessControlList))
            .setter(setter(Builder::originAccessControlList))
            .constructor(OriginAccessControlList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlList")
                    .unmarshallLocationName("OriginAccessControlList").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ORIGIN_ACCESS_CONTROL_LIST_FIELD));

    private final OriginAccessControlList originAccessControlList;

    private ListOriginAccessControlsResponse(BuilderImpl builder) {
        super(builder);
        this.originAccessControlList = builder.originAccessControlList;
    }

    /**
     * <p>
     * A list of origin access controls.
     * </p>
     * 
     * @return A list of origin access controls.
     */
    public final OriginAccessControlList originAccessControlList() {
        return originAccessControlList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(originAccessControlList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOriginAccessControlsResponse)) {
            return false;
        }
        ListOriginAccessControlsResponse other = (ListOriginAccessControlsResponse) obj;
        return Objects.equals(originAccessControlList(), other.originAccessControlList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOriginAccessControlsResponse").add("OriginAccessControlList", originAccessControlList())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OriginAccessControlList":
            return Optional.ofNullable(clazz.cast(originAccessControlList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListOriginAccessControlsResponse, T> g) {
        return obj -> g.apply((ListOriginAccessControlsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOriginAccessControlsResponse> {
        /**
         * <p>
         * A list of origin access controls.
         * </p>
         * 
         * @param originAccessControlList
         *        A list of origin access controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originAccessControlList(OriginAccessControlList originAccessControlList);

        /**
         * <p>
         * A list of origin access controls.
         * </p>
         * This is a convenience method that creates an instance of the {@link OriginAccessControlList.Builder} avoiding
         * the need to create one manually via {@link OriginAccessControlList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OriginAccessControlList.Builder#build()} is called immediately
         * and its result is passed to {@link #originAccessControlList(OriginAccessControlList)}.
         * 
         * @param originAccessControlList
         *        a consumer that will call methods on {@link OriginAccessControlList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originAccessControlList(OriginAccessControlList)
         */
        default Builder originAccessControlList(Consumer<OriginAccessControlList.Builder> originAccessControlList) {
            return originAccessControlList(OriginAccessControlList.builder().applyMutation(originAccessControlList).build());
        }
    }

    static final class BuilderImpl extends CloudFrontResponse.BuilderImpl implements Builder {
        private OriginAccessControlList originAccessControlList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOriginAccessControlsResponse model) {
            super(model);
            originAccessControlList(model.originAccessControlList);
        }

        public final OriginAccessControlList.Builder getOriginAccessControlList() {
            return originAccessControlList != null ? originAccessControlList.toBuilder() : null;
        }

        public final void setOriginAccessControlList(OriginAccessControlList.BuilderImpl originAccessControlList) {
            this.originAccessControlList = originAccessControlList != null ? originAccessControlList.build() : null;
        }

        @Override
        public final Builder originAccessControlList(OriginAccessControlList originAccessControlList) {
            this.originAccessControlList = originAccessControlList;
            return this;
        }

        @Override
        public ListOriginAccessControlsResponse build() {
            return new ListOriginAccessControlsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
