/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of aliases (also called CNAMEs) and the CloudFront distributions and Amazon Web Services accounts that they
 * are associated with. In the list, the distribution and account IDs are partially hidden, which allows you to identify
 * the distributions and accounts that you own, but helps to protect the information of ones that you don't own.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictingAliasesList implements SdkPojo, Serializable,
        ToCopyableBuilder<ConflictingAliasesList.Builder, ConflictingAliasesList> {
    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextMarker")
            .getter(getter(ConflictingAliasesList::nextMarker))
            .setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMarker")
                    .unmarshallLocationName("NextMarker").build()).build();

    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxItems")
            .getter(getter(ConflictingAliasesList::maxItems))
            .setter(setter(Builder::maxItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems")
                    .unmarshallLocationName("MaxItems").build()).build();

    private static final SdkField<Integer> QUANTITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Quantity")
            .getter(getter(ConflictingAliasesList::quantity))
            .setter(setter(Builder::quantity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Quantity")
                    .unmarshallLocationName("Quantity").build()).build();

    private static final SdkField<List<ConflictingAlias>> ITEMS_FIELD = SdkField
            .<List<ConflictingAlias>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ConflictingAliasesList::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items")
                    .unmarshallLocationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ConflictingAlias")
                            .memberFieldInfo(
                                    SdkField.<ConflictingAlias> builder(MarshallingType.SDK_POJO)
                                            .constructor(ConflictingAlias::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ConflictingAlias").unmarshallLocationName("ConflictingAlias")
                                                    .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_MARKER_FIELD,
            MAX_ITEMS_FIELD, QUANTITY_FIELD, ITEMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String nextMarker;

    private final Integer maxItems;

    private final Integer quantity;

    private final List<ConflictingAlias> items;

    private ConflictingAliasesList(BuilderImpl builder) {
        this.nextMarker = builder.nextMarker;
        this.maxItems = builder.maxItems;
        this.quantity = builder.quantity;
        this.items = builder.items;
    }

    /**
     * <p>
     * If there are more items in the list than are in this response, this element is present. It contains the value
     * that you should use in the <code>Marker</code> field of a subsequent request to continue listing conflicting
     * aliases where you left off.
     * </p>
     * 
     * @return If there are more items in the list than are in this response, this element is present. It contains the
     *         value that you should use in the <code>Marker</code> field of a subsequent request to continue listing
     *         conflicting aliases where you left off.
     */
    public final String nextMarker() {
        return nextMarker;
    }

    /**
     * <p>
     * The maximum number of conflicting aliases requested.
     * </p>
     * 
     * @return The maximum number of conflicting aliases requested.
     */
    public final Integer maxItems() {
        return maxItems;
    }

    /**
     * <p>
     * The number of conflicting aliases returned in the response.
     * </p>
     * 
     * @return The number of conflicting aliases returned in the response.
     */
    public final Integer quantity() {
        return quantity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the conflicting aliases in the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Contains the conflicting aliases in the list.
     */
    public final List<ConflictingAlias> items() {
        return items;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        hashCode = 31 * hashCode + Objects.hashCode(maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(quantity());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictingAliasesList)) {
            return false;
        }
        ConflictingAliasesList other = (ConflictingAliasesList) obj;
        return Objects.equals(nextMarker(), other.nextMarker()) && Objects.equals(maxItems(), other.maxItems())
                && Objects.equals(quantity(), other.quantity()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConflictingAliasesList").add("NextMarker", nextMarker()).add("MaxItems", maxItems())
                .add("Quantity", quantity()).add("Items", hasItems() ? items() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        case "MaxItems":
            return Optional.ofNullable(clazz.cast(maxItems()));
        case "Quantity":
            return Optional.ofNullable(clazz.cast(quantity()));
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConflictingAliasesList, T> g) {
        return obj -> g.apply((ConflictingAliasesList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictingAliasesList> {
        /**
         * <p>
         * If there are more items in the list than are in this response, this element is present. It contains the value
         * that you should use in the <code>Marker</code> field of a subsequent request to continue listing conflicting
         * aliases where you left off.
         * </p>
         * 
         * @param nextMarker
         *        If there are more items in the list than are in this response, this element is present. It contains
         *        the value that you should use in the <code>Marker</code> field of a subsequent request to continue
         *        listing conflicting aliases where you left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);

        /**
         * <p>
         * The maximum number of conflicting aliases requested.
         * </p>
         * 
         * @param maxItems
         *        The maximum number of conflicting aliases requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxItems(Integer maxItems);

        /**
         * <p>
         * The number of conflicting aliases returned in the response.
         * </p>
         * 
         * @param quantity
         *        The number of conflicting aliases returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantity(Integer quantity);

        /**
         * <p>
         * Contains the conflicting aliases in the list.
         * </p>
         * 
         * @param items
         *        Contains the conflicting aliases in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ConflictingAlias> items);

        /**
         * <p>
         * Contains the conflicting aliases in the list.
         * </p>
         * 
         * @param items
         *        Contains the conflicting aliases in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ConflictingAlias... items);

        /**
         * <p>
         * Contains the conflicting aliases in the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudfront.model.ConflictingAlias.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.cloudfront.model.ConflictingAlias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudfront.model.ConflictingAlias.Builder#build()} is called
         * immediately and its result is passed to {@link #items(List<ConflictingAlias>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudfront.model.ConflictingAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<ConflictingAlias>)
         */
        Builder items(Consumer<ConflictingAlias.Builder>... items);
    }

    static final class BuilderImpl implements Builder {
        private String nextMarker;

        private Integer maxItems;

        private Integer quantity;

        private List<ConflictingAlias> items = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictingAliasesList model) {
            nextMarker(model.nextMarker);
            maxItems(model.maxItems);
            quantity(model.quantity);
            items(model.items);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final Integer getMaxItems() {
            return maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final Integer getQuantity() {
            return quantity;
        }

        public final void setQuantity(Integer quantity) {
            this.quantity = quantity;
        }

        @Override
        public final Builder quantity(Integer quantity) {
            this.quantity = quantity;
            return this;
        }

        public final List<ConflictingAlias.Builder> getItems() {
            List<ConflictingAlias.Builder> result = ConflictingAliasesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ConflictingAlias.BuilderImpl> items) {
            this.items = ConflictingAliasesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ConflictingAlias> items) {
            this.items = ConflictingAliasesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ConflictingAlias... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ConflictingAlias.Builder>... items) {
            items(Stream.of(items).map(c -> ConflictingAlias.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ConflictingAliasesList build() {
            return new ConflictingAliasesList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
