/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelRequest extends ChimeRequest implements
        ToCopyableBuilder<UpdateChannelRequest.Builder, UpdateChannelRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelArn").getter(getter(UpdateChannelRequest::channelArn)).setter(setter(Builder::channelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("channelArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateChannelRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(UpdateChannelRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Metadata").getter(getter(UpdateChannelRequest::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<String> CHIME_BEARER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChimeBearer").getter(getter(UpdateChannelRequest::chimeBearer)).setter(setter(Builder::chimeBearer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-chime-bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, NAME_FIELD,
            MODE_FIELD, METADATA_FIELD, CHIME_BEARER_FIELD));

    private final String channelArn;

    private final String name;

    private final String mode;

    private final String metadata;

    private final String chimeBearer;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelArn = builder.channelArn;
        this.name = builder.name;
        this.mode = builder.mode;
        this.metadata = builder.metadata;
        this.chimeBearer = builder.chimeBearer;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String channelArn() {
        return channelArn;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The mode of the update request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the update request.
     * @see ChannelMode
     */
    public final ChannelMode mode() {
        return ChannelMode.fromValue(mode);
    }

    /**
     * <p>
     * The mode of the update request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ChannelMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The mode of the update request.
     * @see ChannelMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The metadata for the update request.
     * </p>
     * 
     * @return The metadata for the update request.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * The <code>AppInstanceUserArn</code> of the user that makes the API call.
     * </p>
     * 
     * @return The <code>AppInstanceUserArn</code> of the user that makes the API call.
     */
    public final String chimeBearer() {
        return chimeBearer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(channelArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(chimeBearer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest) obj;
        return Objects.equals(channelArn(), other.channelArn()) && Objects.equals(name(), other.name())
                && Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(chimeBearer(), other.chimeBearer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelRequest").add("ChannelArn", channelArn())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Mode", modeAsString())
                .add("Metadata", metadata() == null ? null : "*** Sensitive Data Redacted ***").add("ChimeBearer", chimeBearer())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelArn":
            return Optional.ofNullable(clazz.cast(channelArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "ChimeBearer":
            return Optional.ofNullable(clazz.cast(chimeBearer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelRequest> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param channelArn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelArn(String channelArn);

        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param name
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The mode of the update request.
         * </p>
         * 
         * @param mode
         *        The mode of the update request.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The mode of the update request.
         * </p>
         * 
         * @param mode
         *        The mode of the update request.
         * @see ChannelMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelMode
         */
        Builder mode(ChannelMode mode);

        /**
         * <p>
         * The metadata for the update request.
         * </p>
         * 
         * @param metadata
         *        The metadata for the update request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * </p>
         * 
         * @param chimeBearer
         *        The <code>AppInstanceUserArn</code> of the user that makes the API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chimeBearer(String chimeBearer);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ChimeRequest.BuilderImpl implements Builder {
        private String channelArn;

        private String name;

        private String mode;

        private String metadata;

        private String chimeBearer;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            channelArn(model.channelArn);
            name(model.name);
            mode(model.mode);
            metadata(model.metadata);
            chimeBearer(model.chimeBearer);
        }

        public final String getChannelArn() {
            return channelArn;
        }

        public final void setChannelArn(String channelArn) {
            this.channelArn = channelArn;
        }

        @Override
        public final Builder channelArn(String channelArn) {
            this.channelArn = channelArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ChannelMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getChimeBearer() {
            return chimeBearer;
        }

        public final void setChimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
        }

        @Override
        public final Builder chimeBearer(String chimeBearer) {
            this.chimeBearer = chimeBearer;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
