/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.chime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVoiceConnectorTerminationCredentialsResponse extends ChimeResponse
        implements
        ToCopyableBuilder<ListVoiceConnectorTerminationCredentialsResponse.Builder, ListVoiceConnectorTerminationCredentialsResponse> {
    private static final SdkField<List<String>> USERNAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Usernames")
            .getter(getter(ListVoiceConnectorTerminationCredentialsResponse::usernames))
            .setter(setter(Builder::usernames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Usernames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USERNAMES_FIELD));

    private final List<String> usernames;

    private ListVoiceConnectorTerminationCredentialsResponse(BuilderImpl builder) {
        super(builder);
        this.usernames = builder.usernames;
    }

    /**
     * For responses, this returns true if the service returned a value for the Usernames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUsernames() {
        return usernames != null && !(usernames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsernames} method.
     * </p>
     * 
     * @return A list of user names.
     */
    public final List<String> usernames() {
        return usernames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUsernames() ? usernames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVoiceConnectorTerminationCredentialsResponse)) {
            return false;
        }
        ListVoiceConnectorTerminationCredentialsResponse other = (ListVoiceConnectorTerminationCredentialsResponse) obj;
        return hasUsernames() == other.hasUsernames() && Objects.equals(usernames(), other.usernames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVoiceConnectorTerminationCredentialsResponse")
                .add("Usernames", usernames() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Usernames":
            return Optional.ofNullable(clazz.cast(usernames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVoiceConnectorTerminationCredentialsResponse, T> g) {
        return obj -> g.apply((ListVoiceConnectorTerminationCredentialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ChimeResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVoiceConnectorTerminationCredentialsResponse> {
        /**
         * <p>
         * A list of user names.
         * </p>
         * 
         * @param usernames
         *        A list of user names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernames(Collection<String> usernames);

        /**
         * <p>
         * A list of user names.
         * </p>
         * 
         * @param usernames
         *        A list of user names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usernames(String... usernames);
    }

    static final class BuilderImpl extends ChimeResponse.BuilderImpl implements Builder {
        private List<String> usernames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVoiceConnectorTerminationCredentialsResponse model) {
            super(model);
            usernames(model.usernames);
        }

        public final Collection<String> getUsernames() {
            if (usernames instanceof SdkAutoConstructList) {
                return null;
            }
            return usernames;
        }

        public final void setUsernames(Collection<String> usernames) {
            this.usernames = SensitiveStringListCopier.copy(usernames);
        }

        @Override
        public final Builder usernames(Collection<String> usernames) {
            this.usernames = SensitiveStringListCopier.copy(usernames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usernames(String... usernames) {
            usernames(Arrays.asList(usernames));
            return this;
        }

        @Override
        public ListVoiceConnectorTerminationCredentialsResponse build() {
            return new ListVoiceConnectorTerminationCredentialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
